/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.amd64.AMD64MoveFactory;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotMove;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.gen.MoveFactory;

public class AMD64HotSpotMoveFactory
extends AMD64MoveFactory {
    public AMD64HotSpotMoveFactory(MoveFactory.BackupSlotProvider backupSlotProvider) {
        super(backupSlotProvider);
    }

    @Override
    public boolean canInlineConstant(Constant c) {
        if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
            return true;
        }
        if (c instanceof HotSpotObjectConstant) {
            return ((HotSpotObjectConstant)c).isCompressed();
        }
        if (c instanceof HotSpotMetaspaceConstant) {
            return ((HotSpotMetaspaceConstant)c).isCompressed();
        }
        return super.canInlineConstant(c);
    }

    @Override
    public boolean allowConstantToStackMove(Constant value) {
        if (value instanceof HotSpotConstant) {
            return ((HotSpotConstant)value).isCompressed();
        }
        return super.allowConstantToStackMove(value);
    }

    @Override
    public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(src)) {
            return super.createLoad(dst, (Constant)JavaConstant.INT_0);
        }
        if (src instanceof HotSpotObjectConstant) {
            return new AMD64HotSpotMove.HotSpotLoadObjectConstantOp(dst, (HotSpotObjectConstant)src);
        }
        if (src instanceof HotSpotMetaspaceConstant) {
            return new AMD64HotSpotMove.HotSpotLoadMetaspaceConstantOp(dst, (HotSpotMetaspaceConstant)src);
        }
        return super.createLoad(dst, src);
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
        if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(src)) {
            return super.createStackLoad(dst, (Constant)JavaConstant.INT_0);
        }
        if (src instanceof HotSpotObjectConstant) {
            assert (((HotSpotConstant)src).isCompressed());
            return new AMD64HotSpotMove.HotSpotLoadObjectConstantOp(dst, (HotSpotObjectConstant)src);
        }
        if (src instanceof HotSpotMetaspaceConstant) {
            assert (((HotSpotConstant)src).isCompressed());
            return new AMD64HotSpotMove.HotSpotLoadMetaspaceConstantOp(dst, (HotSpotMetaspaceConstant)src);
        }
        return super.createStackLoad(dst, src);
    }
}

