/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.nodes.gc.G1BarrierSet;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;

public class HotSpotPlatformConfigurationProvider
implements PlatformConfigurationProvider {
    private final BarrierSet barrierSet;
    private final boolean canVirtualizeLargeByteArrayAccess;

    public HotSpotPlatformConfigurationProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        this.barrierSet = this.createBarrierSet(config, metaAccess);
        this.canVirtualizeLargeByteArrayAccess = config.deoptimizationSupportLargeAccessByteArrayVirtualization;
    }

    @Override
    public boolean canVirtualizeLargeByteArrayAccess() {
        return this.canVirtualizeLargeByteArrayAccess;
    }

    @Override
    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }

    private BarrierSet createBarrierSet(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        final boolean useDeferredInitBarriers = config.useDeferredInitBarriers;
        ResolvedJavaType objectArrayType = metaAccess.lookupJavaType(Object[].class);
        if (config.useG1GC) {
            ResolvedJavaField referentField = HotSpotReplacementsUtil.referentField(metaAccess);
            return new G1BarrierSet(objectArrayType, referentField){

                @Override
                protected boolean writeRequiresPostBarrier(FixedAccessNode node, ValueNode writtenValue) {
                    if (!super.writeRequiresPostBarrier(node, writtenValue)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(node);
                }
            };
        }
        return new CardTableBarrierSet(objectArrayType){

            @Override
            protected boolean writeRequiresBarrier(FixedAccessNode node, ValueNode writtenValue) {
                if (!super.writeRequiresBarrier(node, writtenValue)) {
                    return false;
                }
                return !useDeferredInitBarriers || !HotSpotPlatformConfigurationProvider.this.isWriteToNewObject(node);
            }
        };
    }

    protected boolean isWriteToNewObject(FixedAccessNode node) {
        if (!node.getLocationIdentity().isInit()) {
            return false;
        }
        ValueNode base = node.getAddress().getBase();
        if (base instanceof AbstractNewObjectNode) {
            for (Node pred = node.predecessor(); pred != null; pred = pred.predecessor()) {
                if (pred == base) {
                    return true;
                }
                if (!(pred instanceof AbstractNewObjectNode)) continue;
                node.getDebug().log(2, "Disallowed deferred init because %s was last allocation instead of %s", (Object)pred, (Object)base);
                return false;
            }
        }
        node.getDebug().log(2, "Unable to find allocation for deferred init for %s with base %s", (Object)node, (Object)base);
        return false;
    }
}

