/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class ObjectSnippets
implements Snippets {
    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native boolean fastNotifyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Snippet
    public static void fastNotify(Object thisObj) {
        if (ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY, thisObj)) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notify();
    }

    @Snippet
    public static void fastNotifyAll(Object thisObj) {
        if (ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY_ALL, thisObj)) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notifyAll();
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo notifySnippet = this.snippet(ObjectSnippets.class, "fastNotify", this.originalNotifyCall(false), null, new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo notifyAllSnippet = this.snippet(ObjectSnippets.class, "fastNotifyAll", this.originalNotifyCall(true), null, new LocationIdentity[0]);

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
        }

        private ResolvedJavaMethod originalNotifyCall(boolean notifyAll) throws GraalError {
            if (notifyAll) {
                return Templates.findMethod(this.providers.getMetaAccess(), Object.class, "notifyAll");
            }
            return Templates.findMethod(this.providers.getMetaAccess(), Object.class, "notify");
        }

        public void lower(Node n, LoweringTool tool) {
            if (n instanceof FastNotifyNode) {
                FastNotifyNode fn = (FastNotifyNode)n;
                StructuredGraph graph = (StructuredGraph)n.graph();
                FrameState stateDuringCall = fn.stateDuring();
                assert (stateDuringCall != null) : "Must have valid state for snippet recursive notify call";
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(fn.isNotifyAll() ? this.notifyAllSnippet : this.notifySnippet, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("thisObj", fn.object);
                SnippetTemplate template = this.template(fn, args);
                graph.getDebug().log("Lowering fast notify in %s: node=%s, template=%s, arguments=%s", graph, (Object)fn, (Object)template, (Object)args);
                UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(this.providers.getMetaAccess(), fn, SnippetTemplate.DEFAULT_REPLACER, args);
                for (Node originalNode : duplicates.getKeys()) {
                    if (originalNode instanceof InvokeNode) {
                        InvokeNode invoke = (InvokeNode)duplicates.get((Object)originalNode);
                        assert (invoke.asNode().graph() == graph);
                        invoke.setBci(fn.getBci());
                        invoke.setStateDuring(null);
                        invoke.setStateAfter(null);
                        invoke.setStateDuring(stateDuringCall);
                        continue;
                    }
                    if (!(originalNode instanceof InvokeWithExceptionNode)) continue;
                    throw new GraalError("unexpected invoke with exception %s in snippet", originalNode);
                }
            } else {
                GraalError.shouldNotReachHere("Unknown object snippet lowered node");
            }
        }
    }
}

