/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.AllocaNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.hotspot.stubs.OutOfBoundsExceptionStub;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;

public class NegativeArraySizeExceptionStub
extends CreateExceptionStub {
    private static final boolean PRINT_LENGTH_IN_EXCEPTION = JavaVersionUtil.JAVA_SPEC >= 11;

    public NegativeArraySizeExceptionStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("createNegativeArraySizeException", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        switch (index) {
            case 1: {
                return this.providers.getRegisters().getThreadRegister();
            }
            case 2: {
                return OutOfBoundsExceptionStub.MAX_INT_STRING_SIZE + 1;
            }
            case 3: {
                return PRINT_LENGTH_IN_EXCEPTION;
            }
        }
        throw GraalError.shouldNotReachHere("unknown parameter " + name + " at index " + index);
    }

    @Snippet
    private static Object createNegativeArraySizeException(int length, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter int bufferSizeInBytes, @Snippet.ConstantParameter boolean printLengthInException) {
        if (printLengthInException) {
            Word buffer = AllocaNode.alloca(bufferSizeInBytes, HotSpotReplacementsUtil.wordSize());
            Word ptr = StubUtil.printNumber(buffer, length);
            ptr.writeByte(0, (byte)0);
            return NegativeArraySizeExceptionStub.createException(threadRegister, NegativeArraySizeException.class, buffer);
        }
        return NegativeArraySizeExceptionStub.createException(threadRegister, NegativeArraySizeException.class);
    }
}

