/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import org.graalvm.compiler.java.BciBlockMapping;

public final class JsrScope {
    public static final JsrScope EMPTY_SCOPE = new JsrScope();
    private final char returnAddress;
    private final JsrScope parent;
    private final BciBlockMapping.BciBlock jsrEntryBlock;

    private JsrScope(int returnBci, BciBlockMapping.BciBlock jsrEntryBlock, JsrScope parent) {
        this.returnAddress = (char)returnBci;
        this.parent = parent;
        this.jsrEntryBlock = jsrEntryBlock;
    }

    private JsrScope() {
        this.returnAddress = '\u0000';
        this.parent = null;
        this.jsrEntryBlock = null;
    }

    public int nextReturnAddress() {
        return this.returnAddress;
    }

    public BciBlockMapping.BciBlock getJsrEntryBlock() {
        return this.jsrEntryBlock;
    }

    public JsrScope push(int returnBci, BciBlockMapping.BciBlock newJsrEntryBlock) {
        if (returnBci == 0) {
            throw new IllegalArgumentException("A bytecode subroutine cannot have a return address of 0");
        }
        if (returnBci < 1 || returnBci > 65535) {
            throw new IllegalArgumentException("Bytecode subroutine return address cannot be encoded as a char: " + returnBci);
        }
        return new JsrScope(returnBci, newJsrEntryBlock, this);
    }

    public JsrScope push(int returnBci) {
        return this.push(returnBci, null);
    }

    public boolean isEmpty() {
        return this.returnAddress == '\u0000';
    }

    public String getAncestry() {
        String result = "";
        JsrScope s = this;
        while (s != null) {
            if (!s.isEmpty()) {
                result = s.returnAddress + result;
            }
            s = s.parent;
        }
        return result;
    }

    public boolean isPrefixOf(JsrScope other) {
        if (this.isEmpty()) {
            return true;
        }
        String ancestry = this.getAncestry();
        String otherAncestry = other.getAncestry();
        return otherAncestry.startsWith(ancestry);
    }

    public JsrScope pop() {
        if (this.isEmpty()) {
            return this;
        }
        return this.parent;
    }

    public int hashCode() {
        int hc = this.returnAddress;
        JsrScope ancestor = this.parent;
        while (ancestor != null) {
            hc ^= ancestor.returnAddress;
            ancestor = ancestor.parent;
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            JsrScope ancestor = this;
            JsrScope otherAncestor = (JsrScope)obj;
            while (ancestor != null) {
                if (otherAncestor == null) {
                    return false;
                }
                if (otherAncestor.returnAddress != ancestor.returnAddress) {
                    return false;
                }
                ancestor = ancestor.parent;
                otherAncestor = otherAncestor.parent;
            }
            if (otherAncestor == null) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        JsrScope ancestor = this;
        while (ancestor != null) {
            if (!ancestor.isEmpty()) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append((int)ancestor.returnAddress);
            }
            ancestor = ancestor.parent;
        }
        return "[" + sb + "]";
    }
}

