/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.BitSet;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.LocalLiveness;

public final class SmallLocalLiveness
extends LocalLiveness {
    private final long[] localsLiveIn;
    private final long[] localsLiveOut;
    private final long[] localsLiveGen;
    private final long[] localsLiveKill;
    private final long[] localsLiveAsync;
    private final long[] localsChangedInLoop;
    private final int maxLocals;

    public SmallLocalLiveness(BciBlockMapping mapping, int maxLocals, int loopCount, boolean asyncLiveness) {
        super(mapping, asyncLiveness);
        this.maxLocals = maxLocals;
        int blockSize = this.blocks.length;
        this.localsLiveIn = new long[blockSize];
        this.localsLiveOut = new long[blockSize];
        this.localsLiveGen = new long[blockSize];
        this.localsLiveKill = new long[blockSize];
        this.localsLiveAsync = new long[blockSize];
        this.localsChangedInLoop = new long[loopCount];
    }

    private String debugString(long value) {
        StringBuilder str = new StringBuilder("{");
        long current = value;
        for (int i = 0; i < this.maxLocals; ++i) {
            if ((current & 1L) == 1L) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append(i);
            }
            current >>= 1;
        }
        return str.append('}').toString();
    }

    @Override
    protected String debugLiveIn(int blockID) {
        return this.debugString(this.localsLiveIn[blockID]);
    }

    @Override
    protected String debugLiveOut(int blockID) {
        return this.debugString(this.localsLiveOut[blockID]);
    }

    @Override
    protected String debugLiveGen(int blockID) {
        return this.debugString(this.localsLiveGen[blockID]);
    }

    @Override
    protected String debugLiveKill(int blockID) {
        return this.debugString(this.localsLiveKill[blockID]);
    }

    @Override
    protected int liveOutCardinality(int blockID) {
        return Long.bitCount(this.localsLiveOut[blockID]);
    }

    @Override
    protected int liveAsyncCardinality(int blockID) {
        return Long.bitCount(this.localsLiveAsync[blockID]);
    }

    @Override
    protected void propagateLiveness(int blockID, int successorID) {
        int n = blockID;
        this.localsLiveOut[n] = this.localsLiveOut[n] | this.localsLiveIn[successorID];
    }

    @Override
    protected void propagateAsyncLiveness(int blockID, int successorID) {
        int n = blockID;
        this.localsLiveAsync[n] = this.localsLiveAsync[n] | this.localsLiveIn[successorID];
    }

    @Override
    protected void updateLiveness(int blockID) {
        this.localsLiveIn[blockID] = this.localsLiveOut[blockID] & (this.localsLiveKill[blockID] ^ 0xFFFFFFFFFFFFFFFFL) | this.localsLiveGen[blockID] | this.localsLiveAsync[blockID];
    }

    @Override
    protected void loadOne(int blockID, int local) {
        long bit = 1L << local;
        if ((this.localsLiveKill[blockID] & bit) == 0L) {
            int n = blockID;
            this.localsLiveGen[n] = this.localsLiveGen[n] | bit;
        }
    }

    @Override
    protected void storeOne(int blockID, int local) {
        long bit = 1L << local;
        if ((this.localsLiveGen[blockID] & bit) == 0L) {
            int n = blockID;
            this.localsLiveKill[n] = this.localsLiveKill[n] | bit;
        }
        BciBlockMapping.BciBlock block = this.blocks[blockID];
        BitSet loops = block.loops;
        int pos = -1;
        while ((pos = loops.nextSetBit(pos + 1)) >= 0) {
            int n = pos;
            this.localsChangedInLoop[n] = this.localsChangedInLoop[n] | bit;
        }
    }

    @Override
    public boolean localIsLiveIn(BciBlockMapping.BciBlock block, int local) {
        int blockID = block.getId();
        return blockID >= Integer.MAX_VALUE ? false : (this.localsLiveIn[blockID] & 1L << local) != 0L;
    }

    @Override
    public boolean localIsLiveOut(BciBlockMapping.BciBlock block, int local) {
        int blockID = block.getId();
        return blockID >= Integer.MAX_VALUE ? false : (this.localsLiveOut[blockID] & 1L << local) != 0L;
    }

    @Override
    public boolean localIsChangedInLoop(int loopId, int local) {
        return (this.localsChangedInLoop[loopId] & 1L << local) != 0L;
    }
}

