/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AArch64_ARRAY_INDEX_OF")
public final class AArch64ArrayIndexOfOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ArrayIndexOfOp> TYPE = LIRInstructionClass.create(AArch64ArrayIndexOfOp.class);
    private final boolean findTwoConsecutive;
    private final int arrayBaseOffset;
    private final int elementByteSize;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayPtrValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayLengthValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue fromIndexValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue searchValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp5;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp4;

    public AArch64ArrayIndexOfOp(int arrayBaseOffset, JavaKind valueKind, boolean findTwoConsecutive, LIRGeneratorTool tool, AllocatableValue result, AllocatableValue arrayPtr, AllocatableValue arrayLength, AllocatableValue fromIndex, AllocatableValue searchValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.arrayBaseOffset = arrayBaseOffset;
        this.elementByteSize = AArch64ArrayIndexOfOp.getElementByteSize(valueKind);
        this.findTwoConsecutive = findTwoConsecutive;
        this.resultValue = result;
        this.arrayPtrValue = arrayPtr;
        this.arrayLengthValue = arrayLength;
        this.fromIndexValue = fromIndex;
        this.searchValue = searchValue;
        LIRKind archWordKind = LIRKind.value(tool.target().arch.getWordKind());
        this.temp1 = tool.newVariable(archWordKind);
        this.temp2 = tool.newVariable(archWordKind);
        this.temp3 = tool.newVariable(archWordKind);
        this.temp4 = tool.newVariable(archWordKind);
        this.temp5 = tool.newVariable(archWordKind);
        LIRKind vectorKind = LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD));
        this.vectorTemp1 = tool.newVariable(vectorKind);
        this.vectorTemp2 = tool.newVariable(vectorKind);
        this.vectorTemp3 = tool.newVariable(vectorKind);
        this.vectorTemp4 = tool.newVariable(vectorKind);
    }

    private static int getElementByteSize(JavaKind kind) {
        switch (kind) {
            case Byte: {
                return 1;
            }
            case Char: {
                return 2;
            }
            case Int: {
                return 4;
            }
        }
        throw GraalError.shouldNotReachHere("Unexpected JavaKind");
    }

    private int getShiftSize() {
        switch (this.elementByteSize) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private void emitScalarCode(AArch64MacroAssembler masm, Register searchLength, Register baseAddress) {
        Register endIndex;
        Register searchValueReg;
        int compareSize;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register curValue = ValueUtil.asRegister((Value)this.temp3);
        Label match = new Label();
        Label searchByElementLoop = new Label();
        Label end = new Label();
        int shiftSize = this.getShiftSize();
        int memAccessSize = (this.findTwoConsecutive ? 2 : 1) * this.elementByteSize * 8;
        if (memAccessSize < 32) {
            compareSize = 32;
            searchValueReg = ValueUtil.asRegister((Value)this.temp4);
            masm.and(32, searchValueReg, ValueUtil.asRegister((Value)this.searchValue), NumUtil.getNbitNumberLong(memAccessSize));
        } else {
            compareSize = memAccessSize;
            searchValueReg = ValueUtil.asRegister((Value)this.searchValue);
        }
        if (this.findTwoConsecutive) {
            endIndex = ValueUtil.asRegister((Value)this.temp5);
            masm.sub(64, endIndex, arrayLength, 1);
            masm.sub(64, searchLength, searchLength, 1);
        } else {
            endIndex = arrayLength;
        }
        masm.add(64, baseAddress, baseAddress, endIndex, AArch64Assembler.ShiftType.LSL, shiftSize);
        Register curIndex = searchLength;
        masm.sub(64, curIndex, AArch64.zr, curIndex, AArch64Assembler.ShiftType.LSL, shiftSize);
        masm.align(16);
        masm.bind(searchByElementLoop);
        masm.ldr(memAccessSize, curValue, AArch64Address.createRegisterOffsetAddress(memAccessSize, baseAddress, curIndex, false));
        masm.cmp(compareSize, searchValueReg, curValue);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, match);
        masm.adds(64, curIndex, curIndex, this.elementByteSize);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.MI, searchByElementLoop);
        masm.jmp(end);
        masm.align(16);
        masm.bind(match);
        masm.add(64, result, endIndex, curIndex, AArch64Assembler.ShiftType.ASR, shiftSize);
        masm.bind(end);
    }

    private void emitSIMDCode(AArch64MacroAssembler masm, Register baseAddress) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
        Register searchElement = ValueUtil.asRegister((Value)this.searchValue);
        Register currOffset = ValueUtil.asRegister((Value)this.temp2);
        Register endOfString = ValueUtil.asRegister((Value)this.temp3);
        Register refAddress = ValueUtil.asRegister((Value)this.temp4);
        Register chunkToReadAddress = ValueUtil.asRegister((Value)this.temp5);
        Register searchElementRegV = ValueUtil.asRegister((Value)this.vectorTemp1);
        Register chunkPart1RegV = ValueUtil.asRegister((Value)this.vectorTemp2);
        Register chunkPart2RegV = ValueUtil.asRegister((Value)this.vectorTemp3);
        Register tmpRegV1 = ValueUtil.asRegister((Value)this.vectorTemp4);
        Label matchInChunk = new Label();
        Label searchByChunkLoopHead = new Label();
        Label searchByChunkLoopTail = new Label();
        Label processTail = new Label();
        Label end = new Label();
        int shiftSize = this.getShiftSize();
        AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromSize(this.elementByteSize * 8);
        long magicConstant = -4598162009296466941L;
        masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, searchElementRegV, searchElement);
        masm.add(64, endOfString, baseAddress, arrayLength, AArch64Assembler.ShiftType.LSL, shiftSize);
        masm.bic(64, refAddress, endOfString, 31L);
        masm.add(64, chunkToReadAddress, baseAddress, fromIndex, AArch64Assembler.ShiftType.LSL, shiftSize);
        masm.align(16);
        masm.bind(searchByChunkLoopHead);
        masm.cmp(64, refAddress, chunkToReadAddress);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, processTail);
        masm.bind(searchByChunkLoopTail);
        masm.sub(64, currOffset, chunkToReadAddress, baseAddress);
        masm.fldp(128, chunkPart1RegV, chunkPart2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, chunkToReadAddress, 32));
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, chunkPart1RegV, chunkPart1RegV, searchElementRegV);
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, chunkPart2RegV, chunkPart2RegV, searchElementRegV);
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, tmpRegV1, chunkPart1RegV, chunkPart2RegV);
        if (this.elementByteSize == 1) {
            masm.neon.umaxvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, tmpRegV1, tmpRegV1);
        } else {
            masm.neon.xtnVV(eSize.narrow(), tmpRegV1, tmpRegV1);
        }
        try (AArch64MacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            Register matchReg = scratchReg.getRegister();
            masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.DoubleWord, matchReg, tmpRegV1, 0);
            masm.cbnz(64, matchReg, matchInChunk);
        }
        masm.bic(64, chunkToReadAddress, chunkToReadAddress, 31L);
        masm.jmp(searchByChunkLoopHead);
        masm.align(16);
        masm.bind(processTail);
        masm.cmp(64, chunkToReadAddress, endOfString);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, end);
        masm.sub(64, chunkToReadAddress, endOfString, 32);
        masm.mov(64, endOfString, chunkToReadAddress);
        masm.jmp(searchByChunkLoopTail);
        masm.align(16);
        masm.bind(matchInChunk);
        scratchReg = masm.getScratchRegister();
        var25_24 = null;
        try {
            Register magicConstantReg = scratchReg.getRegister();
            masm.mov(magicConstantReg, magicConstant);
            masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, tmpRegV1, magicConstantReg);
        }
        catch (Throwable magicConstantReg) {
            var25_24 = magicConstantReg;
            throw magicConstantReg;
        }
        finally {
            if (scratchReg != null) {
                if (var25_24 != null) {
                    try {
                        scratchReg.close();
                    }
                    catch (Throwable magicConstantReg) {
                        var25_24.addSuppressed(magicConstantReg);
                    }
                } else {
                    scratchReg.close();
                }
            }
        }
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, chunkPart1RegV, chunkPart1RegV, tmpRegV1);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, chunkPart2RegV, chunkPart2RegV, tmpRegV1);
        masm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, chunkPart1RegV, chunkPart1RegV, chunkPart2RegV);
        masm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, chunkPart1RegV, chunkPart1RegV, tmpRegV1);
        scratchReg = masm.getScratchRegister();
        var25_24 = null;
        try {
            Register matchPositionReg = scratchReg.getRegister();
            masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.DoubleWord, matchPositionReg, chunkPart1RegV, 0);
            masm.rbit(64, matchPositionReg, matchPositionReg);
            masm.clz(64, matchPositionReg, matchPositionReg);
            masm.add(64, result, currOffset, matchPositionReg, AArch64Assembler.ShiftType.ASR, 1);
        }
        catch (Throwable throwable) {
            var25_24 = throwable;
            throw throwable;
        }
        finally {
            if (scratchReg != null) {
                if (var25_24 != null) {
                    try {
                        scratchReg.close();
                    }
                    catch (Throwable throwable) {
                        var25_24.addSuppressed(throwable);
                    }
                } else {
                    scratchReg.close();
                }
            }
        }
        if (shiftSize != 0) {
            masm.asr(64, result, result, shiftSize);
        }
        masm.bind(end);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
        Register baseAddress = ValueUtil.asRegister((Value)this.temp1);
        Register searchLength = ValueUtil.asRegister((Value)this.temp2);
        Label ret = new Label();
        masm.mov(result, -1);
        masm.cbz(64, arrayLength, ret);
        masm.add(64, baseAddress, ValueUtil.asRegister((Value)this.arrayPtrValue), this.arrayBaseOffset);
        masm.sub(64, searchLength, arrayLength, fromIndex);
        if (this.findTwoConsecutive) {
            this.emitScalarCode(masm, searchLength, baseAddress);
        } else {
            Label searchByChunk = new Label();
            int chunkByteSize = 32;
            masm.compare(64, searchLength, chunkByteSize / this.elementByteSize);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, searchByChunk);
            this.emitScalarCode(masm, searchLength, baseAddress);
            masm.jmp(ret);
            masm.align(16);
            masm.bind(searchByChunk);
            this.emitSIMDCode(masm, baseAddress);
        }
        masm.bind(ret);
    }
}

