/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRFlags;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerator;

public class AArch64AtomicMove {
    public static AArch64LIRInstruction createAtomicReadAndAdd(LIRGenerator gen, AArch64Kind kind, AllocatableValue result, AllocatableValue address, Value delta) {
        if (AArch64LIRFlags.useLSE(gen.target().arch)) {
            return new AtomicReadAndAddLSEOp(kind, result, address, gen.asAllocatable(delta));
        }
        return new AtomicReadAndAddOp(kind, result, address, delta);
    }

    @Opcode(value="ATOMIC_READ_AND_WRITE")
    public static final class AtomicReadAndWriteOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndWriteOp> TYPE = LIRInstructionClass.create(AtomicReadAndWriteOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue newValue;

        public AtomicReadAndWriteOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue newValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (kind.isInteger());
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.newValue = newValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register value = ValueUtil.asRegister((Value)this.newValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            if (AArch64LIRFlags.useLSE(masm.target.arch)) {
                masm.swp(memAccessSize, value, result, address, true, true);
            } else {
                try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
                    Register scratch = scratchRegister.getRegister();
                    Label retry = new Label();
                    masm.bind(retry);
                    masm.loadExclusive(memAccessSize, result, address, false);
                    masm.storeExclusive(memAccessSize, scratch, value, address, true);
                    masm.cbnz(32, scratch, retry);
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
            }
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddLSEOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddLSEOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddLSEOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue deltaValue;

        AtomicReadAndAddLSEOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register delta = ValueUtil.asRegister((Value)this.deltaValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            masm.ldadd(memAccessSize, delta, result, address, true, true);
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value deltaValue;

        AtomicReadAndAddOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, Value delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            int addSize = Math.max(memAccessSize, 32);
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Label retry = new Label();
            masm.bind(retry);
            masm.loadExclusive(memAccessSize, result, address, false);
            try (AArch64MacroAssembler.ScratchRegister scratchRegister1 = masm.getScratchRegister();){
                Register scratch1 = scratchRegister1.getRegister();
                if (LIRValueUtil.isConstantValue(this.deltaValue)) {
                    long delta = LIRValueUtil.asConstantValue(this.deltaValue).getJavaConstant().asLong();
                    masm.add(addSize, scratch1, result, delta);
                } else {
                    masm.add(addSize, scratch1, result, ValueUtil.asRegister((Value)this.deltaValue));
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister2 = masm.getScratchRegister();){
                    Register scratch2 = scratchRegister2.getRegister();
                    masm.storeExclusive(memAccessSize, scratch2, scratch1, address, true);
                    masm.cbnz(32, scratch2, retry);
                }
            }
            masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
        }
    }

    @Opcode(value="CAS")
    public static class CompareAndSwapOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompareAndSwapOp> TYPE = LIRInstructionClass.create(CompareAndSwapOp.class);
        private final AArch64Kind accessKind;
        private final MemoryOrderMode memoryOrder;
        private final boolean setConditionFlags;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value expectedValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue newValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;

        public CompareAndSwapOp(AArch64Kind accessKind, MemoryOrderMode memoryOrder, boolean setConditionFlags, AllocatableValue result, Value expectedValue, AllocatableValue newValue, AllocatableValue addressValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = accessKind;
            this.memoryOrder = memoryOrder;
            this.setConditionFlags = setConditionFlags;
            this.resultValue = result;
            this.expectedValue = expectedValue;
            this.newValue = newValue;
            this.addressValue = addressValue;
        }

        private static void emitCompare(AArch64MacroAssembler masm, int memAccessSize, Register result, Register expected) {
            switch (memAccessSize) {
                case 8: {
                    masm.cmp(32, result, expected, AArch64Assembler.ExtendType.UXTB, 0);
                    break;
                }
                case 16: {
                    masm.cmp(32, result, expected, AArch64Assembler.ExtendType.UXTH, 0);
                    break;
                }
                case 32: 
                case 64: {
                    masm.cmp(memAccessSize, result, expected);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            boolean release;
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register newVal = ValueUtil.asRegister((Value)this.newValue);
            Register expected = ValueUtil.asRegister((Value)this.expectedValue);
            boolean acquire = (this.memoryOrder.postWriteBarriers & 0xC) != 0 || (this.memoryOrder.postReadBarriers & 3) != 0;
            boolean bl = release = (this.memoryOrder.preWriteBarriers & 0xA) != 0 || (this.memoryOrder.preReadBarriers & 5) != 0;
            if (AArch64LIRFlags.useLSE(masm.target.arch)) {
                masm.mov(Math.max(memAccessSize, 32), result, expected);
                masm.cas(memAccessSize, result, newVal, address, acquire, release);
                if (this.setConditionFlags) {
                    CompareAndSwapOp.emitCompare(masm, memAccessSize, result, expected);
                }
            } else {
                if (release) {
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
                    Register scratch = scratchRegister.getRegister();
                    Label retry = new Label();
                    Label fail = new Label();
                    masm.bind(retry);
                    masm.loadExclusive(memAccessSize, result, address, acquire);
                    CompareAndSwapOp.emitCompare(masm, memAccessSize, result, expected);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, fail);
                    masm.storeExclusive(memAccessSize, scratch, newVal, address, release);
                    masm.cbnz(32, scratch, retry);
                    masm.bind(fail);
                }
            }
        }
    }
}

