/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public enum AArch64PermuteOp {
    TBL,
    ZIPLOW,
    ZIPHIGH,
    ZIPEVEN,
    ZIPODD,
    UNZIPEVEN,
    UNZIPODD;


    public static class ASIMDBinaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDBinaryOp> TYPE = LIRInstructionClass.create(ASIMDBinaryOp.class);
        @Opcode
        private final AArch64PermuteOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        public ASIMDBinaryOp(AArch64PermuteOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register resultReg = ValueUtil.asRegister((Value)this.result);
            Register aReg = ValueUtil.asRegister((Value)this.a);
            Register bReg = ValueUtil.asRegister((Value)this.b);
            switch (this.op) {
                case TBL: {
                    masm.neon.tblVVV(size, resultReg, aReg, bReg);
                    break;
                }
                case ZIPLOW: {
                    masm.neon.zip1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case ZIPHIGH: {
                    masm.neon.zip2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case ZIPEVEN: {
                    masm.neon.trn1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case ZIPODD: {
                    masm.neon.trn2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case UNZIPEVEN: {
                    masm.neon.uzp1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case UNZIPODD: {
                    masm.neon.uzp2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }
}

