/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.Iterator;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.alloc.lsra.Range;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;

public final class LinearScanOptimizeSpillPositionPhase
extends LinearScanAllocationPhase {
    private static final CounterKey betterSpillPos = DebugContext.counter("BetterSpillPosition");
    private static final CounterKey betterSpillPosWithLowerProbability = DebugContext.counter("BetterSpillPositionWithLowerProbability");
    private final LinearScan allocator;
    private DebugContext debug;

    LinearScanOptimizeSpillPositionPhase(LinearScan allocator) {
        this.allocator = allocator;
        this.debug = allocator.getDebug();
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.optimizeSpillPosition(lirGenRes);
        this.allocator.printIntervals("After optimize spill position");
    }

    private void optimizeSpillPosition(LIRGenerationResult res) {
        try (Indent indent0 = this.debug.logAndIndent("OptimizeSpillPositions");){
            LIRInsertionBuffer[] insertionBuffers = new LIRInsertionBuffer[this.allocator.getLIR().linearScanOrder().length];
            for (Interval interval : this.allocator.intervals()) {
                this.optimizeInterval(insertionBuffers, interval, res);
            }
            for (LIRInsertionBuffer insertionBuffer : insertionBuffers) {
                if (insertionBuffer == null) continue;
                assert (insertionBuffer.initialized()) : "Insertion buffer is nonnull but not initialized!";
                insertionBuffer.finish();
            }
        }
    }

    private void optimizeInterval(LIRInsertionBuffer[] insertionBuffers, Interval interval, LIRGenerationResult res) {
        if (interval == null || !interval.isSplitParent() || interval.spillState() != Interval.SpillState.SpillInDominator) {
            return;
        }
        AbstractBlockBase<?> defBlock = this.allocator.blockForId(interval.spillDefinitionPos());
        AbstractBlockBase<?> spillBlock = null;
        Interval firstSpillChild = null;
        try (Indent indent = this.debug.logAndIndent("interval %s (%s)", (Object)interval, defBlock);){
            for (Interval splitChild : interval.getSplitChildren()) {
                if (!LIRValueUtil.isStackSlotValue((Value)splitChild.location())) continue;
                if (firstSpillChild == null || splitChild.from() < firstSpillChild.from()) {
                    firstSpillChild = splitChild;
                } else assert (firstSpillChild.from() < splitChild.from());
                for (AbstractBlockBase<?> splitBlock : this.blocksForInterval(splitChild)) {
                    if (!AbstractControlFlowGraph.dominates(defBlock, splitBlock)) continue;
                    this.debug.log("Split interval %s, block %s", (Object)splitChild, splitBlock);
                    if (spillBlock == null) {
                        spillBlock = splitBlock;
                        continue;
                    }
                    spillBlock = AbstractControlFlowGraph.commonDominator(spillBlock, splitBlock);
                    assert (spillBlock != null);
                }
            }
            if (spillBlock == null) {
                this.debug.log("not spill interval found");
                interval.setSpillState(Interval.SpillState.StoreAtDefinition);
                return;
            }
            this.debug.log(3, "Spill block candidate (initial): %s", spillBlock);
            if (defBlock.getLoopDepth() < spillBlock.getLoopDepth()) {
                spillBlock = LinearScanOptimizeSpillPositionPhase.moveSpillOutOfLoop(defBlock, spillBlock);
            }
            this.debug.log(3, "Spill block candidate (after loop optimizaton): %s", spillBlock);
            assert (firstSpillChild != null);
            if (!defBlock.equals(spillBlock) && spillBlock.equals(this.allocator.blockForId(firstSpillChild.from()))) {
                Object dom = spillBlock.getDominator();
                if (this.debug.isLogEnabled()) {
                    this.debug.log("Spill block (%s) is the beginning of a spill child -> use dominator (%s)", spillBlock, dom);
                }
                spillBlock = dom;
            }
            if (defBlock.equals(spillBlock)) {
                this.debug.log(3, "Definition is the best choice: %s", defBlock);
                interval.setSpillState(Interval.SpillState.StoreAtDefinition);
                return;
            }
            assert (AbstractControlFlowGraph.dominates(defBlock, spillBlock));
            betterSpillPos.increment(this.debug);
            if (this.debug.isLogEnabled()) {
                this.debug.log("Better spill position found (Block %s)", spillBlock);
            }
            if (defBlock.getRelativeFrequency() <= spillBlock.getRelativeFrequency()) {
                this.debug.log(3, "Definition has lower frequency %s (%f) is lower than spill block %s (%f)", defBlock, (Object)defBlock.getRelativeFrequency(), spillBlock, (Object)spillBlock.getRelativeFrequency());
                interval.setSpillState(Interval.SpillState.StoreAtDefinition);
                return;
            }
            LIRInsertionBuffer insertionBuffer = insertionBuffers[spillBlock.getId()];
            if (insertionBuffer == null) {
                insertionBuffers[spillBlock.getId()] = insertionBuffer = new LIRInsertionBuffer();
                insertionBuffer.init(this.allocator.getLIR().getLIRforBlock(spillBlock));
            }
            int spillOpId = this.allocator.getFirstLirInstructionId(spillBlock);
            AllocatableValue fromLocation = interval.getSplitChildAtOpId(spillOpId, LIRInstruction.OperandMode.DEF, this.allocator).location();
            AllocatableValue toLocation = LinearScan.canonicalSpillOpr(interval);
            LIRInstruction move = this.allocator.getSpillMoveFactory().createMove(toLocation, (Value)fromLocation);
            move.setComment(res, "LSRAOptimizeSpillPos: optimize spill pos");
            this.debug.log(3, "Insert spill move %s", (Object)move);
            move.setId(-2);
            insertionBuffer.append(1, move);
            betterSpillPosWithLowerProbability.increment(this.debug);
            interval.setSpillDefinitionPos(spillOpId);
        }
    }

    private Iterable<AbstractBlockBase<?>> blocksForInterval(final Interval interval) {
        return new Iterable<AbstractBlockBase<?>>(){

            @Override
            public Iterator<AbstractBlockBase<?>> iterator() {
                return new IntervalBlockIterator(interval);
            }
        };
    }

    private static AbstractBlockBase<?> moveSpillOutOfLoop(AbstractBlockBase<?> defBlock, AbstractBlockBase<?> spillBlock) {
        int defLoopDepth = defBlock.getLoopDepth();
        Object block = spillBlock.getDominator();
        while (!defBlock.equals(block)) {
            assert (block != null) : "spill block not dominated by definition block?";
            if (((AbstractBlockBase)block).getLoopDepth() <= defLoopDepth) {
                assert (((AbstractBlockBase)block).getLoopDepth() == defLoopDepth) : "Cannot spill an interval outside of the loop where it is defined!";
                return block;
            }
            block = ((AbstractBlockBase)block).getDominator();
        }
        return defBlock;
    }

    private class IntervalBlockIterator
    implements Iterator<AbstractBlockBase<?>> {
        Range range;
        AbstractBlockBase<?> block;

        IntervalBlockIterator(Interval interval) {
            this.range = interval.first();
            this.block = LinearScanOptimizeSpillPositionPhase.this.allocator.blockForId(this.range.from);
        }

        @Override
        public AbstractBlockBase<?> next() {
            AbstractBlockBase<?> currentBlock = this.block;
            int nextBlockIndex = this.block.getLinearScanNumber() + 1;
            if (nextBlockIndex < LinearScanOptimizeSpillPositionPhase.this.allocator.sortedBlocks().length) {
                this.block = LinearScanOptimizeSpillPositionPhase.this.allocator.sortedBlocks()[nextBlockIndex];
                if (this.range.to <= LinearScanOptimizeSpillPositionPhase.this.allocator.getFirstLirInstructionId(this.block)) {
                    this.range = this.range.next;
                    this.block = this.range.isEndMarker() ? null : LinearScanOptimizeSpillPositionPhase.this.allocator.blockForId(this.range.from);
                }
            } else {
                this.block = null;
            }
            return currentBlock;
        }

        @Override
        public boolean hasNext() {
            return this.block != null;
        }
    }
}

