/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AMD64MathCopySignOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64MathCopySignOp> TYPE = LIRInstructionClass.create(AMD64MathCopySignOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected Value result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value magnitude;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value sign;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value scratchGP;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value scratchXMM;

    public AMD64MathCopySignOp(LIRGeneratorTool tool, Value result, AllocatableValue magnitude, AllocatableValue sign) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.magnitude = magnitude;
        this.sign = sign;
        this.scratchGP = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
        this.scratchXMM = tool.newVariable(LIRKind.value(sign.getPlatformKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        PlatformKind kind = this.result.getPlatformKind();
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        Register signReg = ValueUtil.asRegister((Value)this.sign);
        Register scratchGPReg = ValueUtil.asRegister((Value)this.scratchGP);
        Register scratchXMMReg = ValueUtil.asRegister((Value)this.scratchXMM);
        AMD64Move.move(crb, masm, this.result, this.magnitude);
        if (kind == AMD64Kind.SINGLE) {
            masm.movl(scratchGPReg, Integer.MAX_VALUE);
            masm.movdl(scratchXMMReg, scratchGPReg);
            AMD64Assembler.VexRVMIOp.VPTERNLOGD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, resultReg, signReg, scratchXMMReg, 228);
        } else if (kind == AMD64Kind.DOUBLE) {
            masm.movq(scratchGPReg, Long.MAX_VALUE);
            masm.movdq(scratchXMMReg, scratchGPReg);
            AMD64Assembler.VexRVMIOp.VPTERNLOGQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, resultReg, signReg, scratchXMMReg, 228);
        } else {
            throw GraalError.shouldNotReachHere("unsupported kind for Math.copySign");
        }
    }
}

