/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorMove;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="SAVE_REGISTER")
public class AMD64SaveRegistersOp
extends StandardOp.SaveRegistersOp {
    public static final LIRInstructionClass<AMD64SaveRegistersOp> TYPE = LIRInstructionClass.create(AMD64SaveRegistersOp.class);

    public AMD64SaveRegistersOp(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        super(TYPE, savedRegisters, savedRegisterLocations);
    }

    protected AMD64SaveRegistersOp(LIRInstructionClass<AMD64VectorMove.SaveRegistersOp> type, Register[] savedRegisters, AllocatableValue[] slots) {
        super(type, savedRegisters, slots);
    }

    protected void saveRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, StackSlot result, Register input) {
        AMD64Move.reg2stack((AMD64Kind)result.getPlatformKind(), crb, masm, (Value)result, input);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
        for (int i = 0; i < this.savedRegisters.length; ++i) {
            if (this.savedRegisters[i] == null) continue;
            assert (ValueUtil.isStackSlot((Value)this.slots[i])) : "not a StackSlot: " + this.slots[i];
            this.saveRegister(crb, masm, ValueUtil.asStackSlot((Value)this.slots[i]), this.savedRegisters[i]);
        }
    }
}

