/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="CDQ")
public class AMD64SignExtendOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SignExtendOp> TYPE = LIRInstructionClass.create(AMD64SignExtendOp.class);
    private final AMD64BaseAssembler.OperandSize size;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue highResult;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lowResult;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;

    public AMD64SignExtendOp(AMD64BaseAssembler.OperandSize size, LIRKind resultKind, AllocatableValue input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.size = size;
        this.highResult = AMD64.rdx.asValue((ValueKind)resultKind);
        this.lowResult = AMD64.rax.asValue((ValueKind)resultKind);
        this.input = input;
    }

    public AllocatableValue getHighResult() {
        return this.highResult;
    }

    public AllocatableValue getLowResult() {
        return this.lowResult;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (this.size == AMD64BaseAssembler.OperandSize.DWORD) {
            masm.cdql();
        } else {
            assert (this.size == AMD64BaseAssembler.OperandSize.QWORD);
            masm.cdqq();
        }
    }

    @Override
    public void verify() {
        assert (ValueUtil.asRegister((Value)this.highResult).equals((Object)AMD64.rdx));
        assert (ValueUtil.asRegister((Value)this.lowResult).equals((Object)AMD64.rax));
        assert (ValueUtil.asRegister((Value)this.input).equals((Object)AMD64.rax));
    }
}

