/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64Unary {

    public static class MemoryOp
    extends AMD64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryOp> TYPE = LIRInstructionClass.create(MemoryOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue input;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemoryOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AMD64AddressValue input, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.input = input;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.input.toAddress());
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.input.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class MROp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<MROp> TYPE = LIRInstructionClass.create(MROp.class);
        @Opcode
        private final AMD64Assembler.AMD64MROp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue value;

        public MROp(AMD64Assembler.AMD64MROp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.value));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                this.opcode.emit((AMD64Assembler)masm, this.size, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.value));
            }
        }
    }

    public static class RMOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<RMOp> TYPE = LIRInstructionClass.create(RMOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue value;

        public RMOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.value)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.value));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.value));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.value));
            }
        }
    }

    public static class MOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<MOp> TYPE = LIRInstructionClass.create(MOp.class);
        @Opcode
        private final AMD64Assembler.AMD64MOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue value;

        public MOp(AMD64Assembler.AMD64MOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(crb, masm, (Value)this.result, (Value)this.value);
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result));
        }
    }
}

