/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.util;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.util.ValueMap;

public class VariableVirtualStackValueMap<K extends Value, T>
extends ValueMap<K, T> {
    private final Object[] variables;
    private final Object[] slots;

    public VariableVirtualStackValueMap(int initialVariableCapacity, int initialStackSlotCapacity) {
        this.variables = new Object[initialVariableCapacity];
        this.slots = new Object[initialStackSlotCapacity];
    }

    @Override
    public T get(K value) {
        if (LIRValueUtil.isVariable(value)) {
            return VariableVirtualStackValueMap.get(this.variables, LIRValueUtil.asVariable(value).index);
        }
        if (LIRValueUtil.isVirtualStackSlot(value)) {
            return VariableVirtualStackValueMap.get(this.slots, LIRValueUtil.asVirtualStackSlot(value).getId());
        }
        throw GraalError.shouldNotReachHere("Unsupported Value: " + value);
    }

    @Override
    public void remove(K value) {
        if (LIRValueUtil.isVariable(value)) {
            VariableVirtualStackValueMap.remove(this.variables, LIRValueUtil.asVariable(value).index);
        } else if (LIRValueUtil.isVirtualStackSlot(value)) {
            VariableVirtualStackValueMap.remove(this.slots, LIRValueUtil.asVirtualStackSlot(value).getId());
        } else {
            throw GraalError.shouldNotReachHere("Unsupported Value: " + value);
        }
    }

    @Override
    public void put(K value, T object) {
        if (LIRValueUtil.isVariable(value)) {
            VariableVirtualStackValueMap.put(this.variables, LIRValueUtil.asVariable(value).index, object);
        } else if (LIRValueUtil.isVirtualStackSlot(value)) {
            VariableVirtualStackValueMap.put(this.slots, LIRValueUtil.asVirtualStackSlot(value).getId(), object);
        } else {
            throw GraalError.shouldNotReachHere("Unsupported Value: " + value);
        }
    }

    private static <T> T get(Object[] array, int index) {
        if (index >= array.length) {
            return null;
        }
        return (T)array[index];
    }

    private static void remove(Object[] array, int index) {
        if (index >= array.length) {
            return;
        }
        array[index] = null;
    }

    private static <T> Object[] put(Object[] array, int index, T object) {
        if (index >= array.length) {
            Object[] newArray = new Object[index + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[index] = object;
            return newArray;
        }
        array[index] = object;
        return null;
    }
}

