/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.GuardedValueNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ShortCircuitOrNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.MultiGuardNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public class SpeculativeGuardMovementPhase
extends BasePhase<MidTierContext> {
    private static final SpeculationReasonGroup GUARD_MOVEMENT_LOOP_SPECULATIONS = new SpeculationReasonGroup("GuardMovement", ResolvedJavaMethod.class, Integer.TYPE, DeoptimizationReason.class);

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        try {
            if (!graph.getGuardsStage().allowsFloatingGuards()) {
                return;
            }
            LoopsData loops = context.getLoopsDataProvider().getLoopsData(graph);
            loops.detectedCountedLoops();
            SpeculativeGuardMovementPhase.performSpeculativeGuardMovement(context, graph, loops);
        }
        finally {
            graph.setAfterStage(StructuredGraph.StageFlag.GUARD_MOVEMENT);
        }
    }

    protected static void performSpeculativeGuardMovement(MidTierContext context, StructuredGraph graph, LoopsData loops) {
        new SpeculativeGuardMovement(loops, graph.createNodeMap(), graph, context.getProfilingInfo(), graph.getSpeculationLog()).run();
    }

    private static SpeculationLog.SpeculationReason createSpeculation(DeoptimizationReason reason, LoopBeginNode loopBeginNode) {
        FrameState loopState = loopBeginNode.stateAfter();
        ResolvedJavaMethod method = null;
        int bci = 0;
        if (loopState != null) {
            method = loopState.getMethod();
            bci = loopState.bci;
        }
        return GUARD_MOVEMENT_LOOP_SPECULATIONS.createSpeculationReason(method, bci, reason);
    }

    private static boolean isInverted(LoopEx loop) {
        return loop.isCounted() && loop.counted().isInverted();
    }

    private static class SpeculativeGuardMovement
    implements Runnable {
        private final LoopsData loops;
        private final NodeMap<Block> earliestCache;
        private final StructuredGraph graph;
        private final ProfilingInfo profilingInfo;
        private final SpeculationLog speculationLog;

        SpeculativeGuardMovement(LoopsData loops, NodeMap<Block> earliestCache, StructuredGraph graph, ProfilingInfo profilingInfo, SpeculationLog speculationLog) {
            this.loops = loops;
            this.earliestCache = earliestCache;
            this.graph = graph;
            this.profilingInfo = profilingInfo;
            this.speculationLog = speculationLog;
        }

        @Override
        public void run() {
            for (GuardNode guard : this.graph.getNodes(GuardNode.TYPE)) {
                this.earliestBlock(guard);
                this.graph.getDebug().dump(5, (Object)this.graph, "After processing guard %s", guard);
            }
        }

        private Block earliestBlock(Node node) {
            ControlFlowGraph cfg = this.loops.getCFG();
            Block earliest = this.earliestCache.getAndGrow(node);
            if (earliest != null) {
                return earliest;
            }
            Block block = earliest = cfg.getNodeToBlock().isNew(node) ? null : cfg.getNodeToBlock().get(node);
            if (earliest == null) {
                if (node instanceof IntegerDivRemNode) {
                    earliest = this.earliestBlock(node.predecessor());
                } else if (node instanceof PhiNode) {
                    PhiNode phi = (PhiNode)node;
                    earliest = this.earliestBlock(phi.merge());
                }
            }
            if (earliest != null) {
                this.earliestCache.setAndGrow(node, earliest);
                return earliest;
            }
            if (node instanceof GuardNode) {
                GuardNode guard = (GuardNode)node;
                LogicNode condition = guard.getCondition();
                Loop<Block> forcedHoisting = null;
                if (condition instanceof IntegerLessThanNode || condition instanceof IntegerBelowNode) {
                    forcedHoisting = this.tryOptimizeCompare(guard, (CompareNode)condition);
                } else if (condition instanceof InstanceOfNode) {
                    forcedHoisting = this.tryOptimizeInstanceOf(guard, (InstanceOfNode)condition);
                }
                earliest = this.earliestBlockForGuard(guard, forcedHoisting);
            } else {
                earliest = this.computeEarliestBlock(node);
            }
            this.earliestCache.setAndGrow(node, earliest);
            return earliest;
        }

        private Block computeEarliestBlock(Node node) {
            ControlFlowGraph cfg = this.loops.getCFG();
            assert (node.predecessor() == null);
            Block earliest = null;
            for (Node input : node.inputs().snapshot()) {
                if (input == null) continue;
                assert (input instanceof ValueNode);
                Block inputEarliest = input instanceof WithExceptionNode ? cfg.getNodeToBlock().get(((WithExceptionNode)input).next()) : this.earliestBlock(input);
                earliest = earliest == null || AbstractControlFlowGraph.strictlyDominates(earliest, inputEarliest) ? inputEarliest : earliest;
            }
            if (earliest == null) {
                earliest = cfg.getStartBlock();
            }
            return earliest;
        }

        private Loop<Block> tryOptimizeCompare(GuardNode guard, CompareNode compare) {
            boolean mirrored;
            ValueNode bound;
            InductionVariable otherIV;
            InductionVariable iv;
            assert (compare instanceof IntegerLessThanNode || compare instanceof IntegerBelowNode);
            assert (!compare.usages().filter(GuardNode.class).isEmpty());
            InductionVariable ivX = this.loops.getInductionVariable(compare.getX());
            InductionVariable ivY = this.loops.getInductionVariable(compare.getY());
            if (ivX == null && ivY == null) {
                return null;
            }
            if (ivX == null || ivY != null && ivY.getLoop().loop().getDepth() > ivX.getLoop().loop().getDepth()) {
                iv = ivY;
                otherIV = ivX;
                bound = compare.getX();
                mirrored = true;
            } else {
                iv = ivX;
                otherIV = ivY;
                bound = compare.getY();
                mirrored = false;
            }
            if (this.tryOptimizeCompare(compare, iv, bound, mirrored, guard)) {
                return iv.getLoop().loop();
            }
            if (otherIV != null && this.tryOptimizeCompare(compare, otherIV, iv.valueNode(), !mirrored, guard)) {
                return otherIV.getLoop().loop();
            }
            return null;
        }

        private boolean tryOptimizeCompare(CompareNode compare, InductionVariable iv, ValueNode bound, boolean mirrored, GuardNode guard) {
            if (this.shouldOptimizeCompare(iv, bound, guard)) {
                this.optimizeCompare(compare, iv, bound, mirrored, guard);
                return true;
            }
            return false;
        }

        private void optimizeCompare(CompareNode compare, InductionVariable iv, ValueNode bound, boolean mirrored, GuardNode guard) {
            LogicNode test2;
            LogicNode test1;
            bound.getDebug().log("optimizeCompare(%s, %s, %s, %b) in %s", compare, (Object)iv, (Object)bound, (Object)mirrored, (Object)this.graph.method());
            CountedLoopInfo countedLoop = iv.getLoop().counted();
            GuardingNode overflowGuard = countedLoop.getOverFlowGuard();
            ValueNode longBound = IntegerConvertNode.convert(bound, StampFactory.forKind(JavaKind.Long), this.graph, NodeView.DEFAULT);
            ValueNode extremum = iv.extremumNode(true, StampFactory.forKind(JavaKind.Long));
            GuardedValueNode guardedExtremum = this.graph.unique(new GuardedValueNode(extremum, overflowGuard));
            ValueNode y1 = longBound;
            ValueNode y2 = bound;
            ValueNode x1 = guardedExtremum;
            ValueNode x2 = iv.initNode();
            if (mirrored) {
                x1 = longBound;
                y1 = guardedExtremum;
                x2 = bound;
                y2 = iv.initNode();
            }
            if (compare instanceof IntegerBelowNode) {
                test1 = this.graph.unique(new IntegerBelowNode(x1, y1));
                test2 = this.graph.unique(new IntegerBelowNode(x2, y2));
            } else {
                assert (compare instanceof IntegerLessThanNode);
                test1 = this.graph.unique(new IntegerLessThanNode(x1, y1));
                test2 = this.graph.unique(new IntegerLessThanNode(x2, y2));
            }
            LogicNode newCompare = ShortCircuitOrNode.and(test1, guard.isNegated(), test2, guard.isNegated(), ProfileData.BranchProbabilityData.unknown());
            if (guard.isNegated()) {
                guard.negate();
            }
            boolean createLoopEnteredCheck = true;
            if (SpeculativeGuardMovementPhase.isInverted(iv.getLoop())) {
                createLoopEnteredCheck = false;
            }
            if (createLoopEnteredCheck) {
                newCompare = this.createLoopEnterCheck(countedLoop, newCompare);
            }
            guard.replaceFirstInput(compare, newCompare);
            GuardingNode loopBodyGuard = MultiGuardNode.combine(guard, countedLoop.getBody());
            for (ValueNode usage : guard.usages().filter(ValueNode.class).snapshot()) {
                if (usage == loopBodyGuard) continue;
                usage.replaceFirstInput(guard, loopBodyGuard.asNode());
            }
        }

        private LogicNode createLoopEnterCheck(CountedLoopInfo countedLoop, LogicNode newCompare) {
            ValueNode y;
            ValueNode x;
            ValueNode limit = countedLoop.getLimit();
            ValueNode start = countedLoop.getBodyIVStart();
            InductionVariable.Direction direction = countedLoop.getDirection();
            boolean limitIncluded = countedLoop.isLimitIncluded();
            if (limitIncluded) {
                if (direction == InductionVariable.Direction.Up) {
                    x = limit;
                    y = start;
                } else {
                    assert (direction == InductionVariable.Direction.Down);
                    x = start;
                    y = limit;
                }
            } else if (direction == InductionVariable.Direction.Up) {
                x = start;
                y = limit;
            } else {
                assert (direction == InductionVariable.Direction.Down);
                x = limit;
                y = start;
            }
            LogicNode compare = countedLoop.getCounterIntegerHelper().createCompareNode(x, y, NodeView.DEFAULT);
            return this.graph.addOrUniqueWithInputs(new ShortCircuitOrNode(compare, !limitIncluded, newCompare, false, ProfileData.BranchProbabilityData.unknown()));
        }

        private static boolean shouldHoistBasedOnFrequency(Block anchorBlock, Block proposedNewAnchor) {
            return proposedNewAnchor.getRelativeFrequency() <= anchorBlock.getRelativeFrequency();
        }

        private boolean shouldOptimizeCompare(InductionVariable iv, ValueNode bound, GuardNode guard) {
            DebugContext debug = guard.getDebug();
            if (!iv.getLoop().isCounted()) {
                debug.log("shouldOptimizeCompare(%s):not a counted loop", guard);
                return false;
            }
            LoopEx loopEx = iv.getLoop();
            Loop<Block> ivLoop = loopEx.loop();
            Block guardAnchorBlock = this.earliestBlock(guard.getAnchor().asNode());
            if (SpeculativeGuardMovementPhase.isInverted(iv.getLoop())) {
                if (!AbstractControlFlowGraph.dominates(this.earliestBlock(iv.getLoop().counted().getBody()), guardAnchorBlock) && !iv.getLoop().whole().contains(guard.getCondition())) {
                    return false;
                }
            } else if (!AbstractControlFlowGraph.dominates(this.earliestBlock(iv.getLoop().counted().getBody()), guardAnchorBlock)) {
                debug.log("shouldOptimizeCompare(%s):guard is not inside loop", guard);
                return false;
            }
            if (!ivLoop.getBlocks().contains(this.earliestBlock(iv.valueNode()))) {
                debug.log("shouldOptimizeCompare(%s):iv is not inside loop", guard);
                return false;
            }
            if (this.earliestBlock(bound).getId() >= ivLoop.getHeader().getId()) {
                debug.log("shouldOptimizeCompare(%s):bound is not schedulable above the IV loop", guard);
                return false;
            }
            CountedLoopInfo countedLoop = loopEx.counted();
            if (this.profilingInfo != null && !(this.profilingInfo instanceof DefaultProfilingInfo)) {
                double loopFreqThreshold = 1.0;
                if (!(iv.initNode() instanceof ConstantNode) || !(bound instanceof ConstantNode)) {
                    loopFreqThreshold += 2.0;
                }
                if (!(SpeculativeGuardMovementPhase.isInverted(loopEx) || countedLoop.getBodyIVStart() instanceof ConstantNode && countedLoop.getLimit() instanceof ConstantNode)) {
                    loopFreqThreshold += 1.0;
                }
                if (ProfileData.ProfileSource.isTrusted(loopEx.localFrequencySource()) && loopEx.localLoopFrequency() < loopFreqThreshold) {
                    debug.log("shouldOptimizeCompare(%s):loop frequency too low.", guard);
                    return false;
                }
            }
            Loop<Block> l = guardAnchorBlock.getLoop();
            if (SpeculativeGuardMovementPhase.isInverted(loopEx)) {
                l = iv.getLoop().loop();
            }
            if (l == null) {
                return false;
            }
            assert (l != null) : "Loop for guard anchor block must not be null:" + guardAnchorBlock.getBeginNode() + " loop " + iv.getLoop() + " inverted?" + SpeculativeGuardMovementPhase.access$000(iv.getLoop());
            do {
                if (this.allowsSpeculativeGuardMovement(guard.getReason(), (LoopBeginNode)l.getHeader().getBeginNode(), true)) continue;
                debug.log("shouldOptimizeCompare(%s):The guard would not hoist", guard);
                return false;
            } while ((l = l.getParent()) != ivLoop.getParent() && l != null);
            if (!(SpeculativeGuardMovementPhase.isInverted(iv.getLoop()) || AbstractControlFlowGraph.dominates(guardAnchorBlock, iv.getLoop().loop().getHeader()) || SpeculativeGuardMovement.shouldHoistBasedOnFrequency(guardAnchorBlock, (Block)ivLoop.getHeader().getDominator()))) {
                debug.log("hoisting is not beneficial based on fequency", guard);
                return false;
            }
            Stamp boundStamp = bound.stamp(NodeView.DEFAULT);
            Stamp ivStamp = iv.valueNode().stamp(NodeView.DEFAULT);
            if (boundStamp instanceof IntegerStamp && ivStamp instanceof IntegerStamp) {
                IntegerStamp integerBoundStamp = (IntegerStamp)boundStamp;
                IntegerStamp integerIvStamp = (IntegerStamp)ivStamp;
                if (SpeculativeGuardMovement.fitsIn32Bit(integerBoundStamp) && SpeculativeGuardMovement.fitsIn32Bit(integerIvStamp)) {
                    return true;
                }
            }
            debug.log("shouldOptimizeCompare(%s): bound or iv does not fit in int", guard);
            return false;
        }

        private static boolean fitsIn32Bit(IntegerStamp stamp) {
            return NumUtil.isUInt(stamp.upMask());
        }

        private Loop<Block> tryOptimizeInstanceOf(GuardNode guard, InstanceOfNode compare) {
            AnchoringNode anchor = compare.getAnchor();
            if (anchor == null) {
                return null;
            }
            Block anchorBlock = this.earliestBlock(anchor.asNode());
            if (anchorBlock.getLoop() == null) {
                return null;
            }
            Block valueBlock = this.earliestBlock(compare.getValue());
            Loop<Block> hoistAbove = this.findInstanceOfLoopHoisting(guard, anchorBlock, valueBlock);
            if (hoistAbove != null) {
                compare.setProfile(compare.profile(), ((Block)hoistAbove.getHeader().getDominator()).getBeginNode());
                return hoistAbove;
            }
            return null;
        }

        private Loop<Block> findInstanceOfLoopHoisting(GuardNode guard, Block anchorBlock, Block valueBlock) {
            assert (anchorBlock.getLoop() != null);
            DebugContext debug = guard.getDebug();
            if (valueBlock.getLoop() == anchorBlock.getLoop()) {
                debug.log("shouldOptimizeInstanceOf(%s): anchor and condition in the same loop", guard);
                return null;
            }
            if (!valueBlock.isInSameOrOuterLoopOf(anchorBlock)) {
                debug.log("shouldOptimizeInstanceOf(%s): condition loop is not a parent of anchor loop", guard);
                return null;
            }
            if (!AbstractControlFlowGraph.dominates(valueBlock, anchorBlock)) {
                debug.log("shouldOptimizeInstanceOf(%s): value block does not dominate loop header", guard);
                return null;
            }
            if (!this.allowsSpeculativeGuardMovement(guard.getReason(), (LoopBeginNode)anchorBlock.getLoop().getHeader().getBeginNode(), true)) {
                debug.log("shouldOptimizeInstanceOf(%s): The guard would not hoist", guard);
                return null;
            }
            Loop<Block> result = anchorBlock.getLoop();
            while (result.getParent() != valueBlock.getLoop()) {
                result = result.getParent();
            }
            return result;
        }

        private Block earliestBlockForGuard(GuardNode guard, Loop<Block> forcedHoisting) {
            DebugContext debug = guard.getDebug();
            ValueNode anchor = guard.getAnchor().asNode();
            assert (guard.inputs().count() == 2);
            Block conditionEarliest = this.earliestBlock(guard.getCondition());
            Block anchorEarliest = this.earliestBlock(anchor);
            Block newAnchorEarliest = null;
            LoopBeginNode outerMostExitedLoop = null;
            Block b = anchorEarliest;
            if (forcedHoisting != null) {
                newAnchorEarliest = (Block)forcedHoisting.getHeader().getDominator();
                outerMostExitedLoop = (LoopBeginNode)forcedHoisting.getHeader().getBeginNode();
                b = newAnchorEarliest;
            }
            debug.log("earliestBlockForGuard(%s) inital anchor : %s, condition : %s condition's earliest %s", guard, (Object)anchor, (Object)guard.getCondition(), (Object)conditionEarliest.getBeginNode());
            double minFrequency = anchorEarliest.getRelativeFrequency();
            while (AbstractControlFlowGraph.strictlyDominates(conditionEarliest, b)) {
                Block candidateAnchor = (Block)b.getDominatorSkipLoops();
                assert (candidateAnchor.getLoopDepth() <= anchorEarliest.getLoopDepth()) : " candidate anchor block at begin node " + candidateAnchor.getBeginNode() + " earliest anchor block " + anchorEarliest.getBeginNode() + " loop depth is not smaller equal for guard " + guard;
                if (b.isLoopHeader() && (newAnchorEarliest == null || candidateAnchor.getLoopDepth() < newAnchorEarliest.getLoopDepth())) {
                    LoopBeginNode loopBegin = (LoopBeginNode)b.getBeginNode();
                    if (!this.allowsSpeculativeGuardMovement(guard.getReason(), loopBegin, true)) break;
                    double relativeFrequency = candidateAnchor.getRelativeFrequency();
                    if (relativeFrequency <= minFrequency) {
                        debug.log("earliestBlockForGuard(%s) hoisting above %s", (Object)guard, (Object)loopBegin);
                        outerMostExitedLoop = loopBegin;
                        newAnchorEarliest = candidateAnchor;
                        minFrequency = relativeFrequency;
                    } else {
                        debug.log("earliestBlockForGuard(%s) %s not worth it, old relative frequency %f, new relative frequency %f", guard, (Object)loopBegin, (Object)minFrequency, (Object)relativeFrequency);
                    }
                }
                b = candidateAnchor;
            }
            if (newAnchorEarliest != null && this.allowsSpeculativeGuardMovement(guard.getReason(), outerMostExitedLoop, false)) {
                AbstractBeginNode newAnchor = newAnchorEarliest.getBeginNode();
                guard.setAnchor(newAnchor);
                debug.log("New earliest : %s, anchor is %s, update guard", (Object)newAnchorEarliest.getBeginNode(), (Object)anchor);
                Block earliest = newAnchorEarliest;
                if (guard.getAction() == DeoptimizationAction.None) {
                    guard.setAction(DeoptimizationAction.InvalidateRecompile);
                }
                guard.setSpeculation(this.registerSpeculativeGuardMovement(guard.getReason(), outerMostExitedLoop));
                debug.log("Exited %d loops for %s %s in %s", anchorEarliest.getLoopDepth() - earliest.getLoopDepth(), (Object)guard, (Object)guard.getCondition(), (Object)this.graph.method());
                return earliest;
            }
            debug.log("Keep normal anchor edge");
            return AbstractControlFlowGraph.strictlyDominates(conditionEarliest, anchorEarliest) ? anchorEarliest : conditionEarliest;
        }

        private boolean allowsSpeculativeGuardMovement(DeoptimizationReason reason, LoopBeginNode loopBeginNode, boolean checkDeoptimizationCount) {
            DebugContext debug = loopBeginNode.getDebug();
            if (this.speculationLog != null) {
                SpeculationLog.SpeculationReason speculation = SpeculativeGuardMovementPhase.createSpeculation(reason, loopBeginNode);
                if (this.speculationLog.maySpeculate(speculation)) {
                    return true;
                }
                debug.log("Preventing Speculative Guard Motion because of speculation log: %s", speculation);
                return false;
            }
            if (this.profilingInfo == null) {
                return false;
            }
            if (checkDeoptimizationCount) {
                if (this.profilingInfo.getDeoptimizationCount(DeoptimizationReason.LoopLimitCheck) > 1) {
                    debug.log("Preventing Speculative Guard Motion because of failed LoopLimitCheck");
                    return false;
                }
                if (this.profilingInfo.getDeoptimizationCount(reason) > 2) {
                    debug.log("Preventing Speculative Guard Motion because of deopt count for reason: %s", reason);
                    return false;
                }
            }
            debug.log("Allowing Speculative Guard Motion but we can not speculate: %s", loopBeginNode);
            return true;
        }

        private SpeculationLog.Speculation registerSpeculativeGuardMovement(DeoptimizationReason reason, LoopBeginNode loopBeginNode) {
            assert (this.allowsSpeculativeGuardMovement(reason, loopBeginNode, false));
            if (this.speculationLog != null) {
                return this.speculationLog.speculate(SpeculativeGuardMovementPhase.createSpeculation(reason, loopBeginNode));
            }
            loopBeginNode.getDebug().log("No log or state :(");
            return SpeculationLog.NO_SPECULATION;
        }
    }
}

