/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodeinfo;

public final class NodeCycles
extends Enum<NodeCycles> {
    public static final /* enum */ NodeCycles CYCLES_UNSET = new NodeCycles(0);
    public static final /* enum */ NodeCycles CYCLES_UNKNOWN = new NodeCycles(0);
    public static final /* enum */ NodeCycles CYCLES_IGNORED = new NodeCycles(0);
    public static final /* enum */ NodeCycles CYCLES_0 = new NodeCycles(0);
    public static final /* enum */ NodeCycles CYCLES_1 = new NodeCycles(1);
    public static final /* enum */ NodeCycles CYCLES_2 = new NodeCycles(2);
    public static final /* enum */ NodeCycles CYCLES_4 = new NodeCycles(4);
    public static final /* enum */ NodeCycles CYCLES_8 = new NodeCycles(8);
    public static final /* enum */ NodeCycles CYCLES_16 = new NodeCycles(16);
    public static final /* enum */ NodeCycles CYCLES_32 = new NodeCycles(32);
    public static final /* enum */ NodeCycles CYCLES_64 = new NodeCycles(64);
    public static final /* enum */ NodeCycles CYCLES_128 = new NodeCycles(128);
    public static final /* enum */ NodeCycles CYCLES_256 = new NodeCycles(256);
    public static final /* enum */ NodeCycles CYCLES_512 = new NodeCycles(512);
    public static final /* enum */ NodeCycles CYCLES_1024 = new NodeCycles(1024);
    private static final NodeCycles[] VALUES;
    public final int value;
    public static final int IGNORE_CYCLES_CONTRACT_FACTOR = 65535;
    private static final /* synthetic */ NodeCycles[] $VALUES;

    public static NodeCycles[] values() {
        return (NodeCycles[])$VALUES.clone();
    }

    public static NodeCycles valueOf(String name) {
        return Enum.valueOf(NodeCycles.class, name);
    }

    private NodeCycles(int value) {
        this.value = value;
    }

    public boolean isValueKnown() {
        return this != CYCLES_UNKNOWN && this != CYCLES_UNSET;
    }

    public static NodeCycles compute(NodeCycles base, int opCount) {
        assert (opCount >= 0);
        if (opCount == 0) {
            return CYCLES_0;
        }
        assert (base.ordinal() > CYCLES_0.ordinal());
        int log2 = NodeCycles.log2(base.value * opCount);
        for (int i = base.ordinal(); i < VALUES.length; ++i) {
            if (NodeCycles.log2(NodeCycles.VALUES[i].value) != log2) continue;
            return VALUES[i];
        }
        return CYCLES_1024;
    }

    public static NodeCycles compute(int rawValue) {
        assert (rawValue >= 0);
        if (rawValue == 0) {
            return CYCLES_0;
        }
        for (int i = CYCLES_0.ordinal(); i < VALUES.length - 1; ++i) {
            if (NodeCycles.VALUES[i].value < rawValue || rawValue > NodeCycles.VALUES[i + 1].value) continue;
            int r1 = NodeCycles.VALUES[i].value;
            int r2 = NodeCycles.VALUES[i + 1].value;
            int diff = r2 - r1;
            return rawValue - r1 > diff / 2 ? VALUES[i + 1] : VALUES[i];
        }
        return CYCLES_1024;
    }

    private static int log2(int val) {
        return 31 - Integer.numberOfLeadingZeros(val);
    }

    static {
        $VALUES = new NodeCycles[]{CYCLES_UNSET, CYCLES_UNKNOWN, CYCLES_IGNORED, CYCLES_0, CYCLES_1, CYCLES_2, CYCLES_4, CYCLES_8, CYCLES_16, CYCLES_32, CYCLES_64, CYCLES_128, CYCLES_256, CYCLES_512, CYCLES_1024};
        VALUES = NodeCycles.values();
    }
}

