/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodes.StructuredGraph;

public class EncodedGraph {
    private final byte[] encoding;
    private final int startOffset;
    protected final Object[] objects;
    private final NodeClass<?>[] types;
    private final Assumptions assumptions;
    private final List<ResolvedJavaMethod> inlinedMethods;
    private final boolean trackNodeSourcePosition;
    private final boolean hasUnsafeAccess;
    protected int[] nodeStartOffsets;

    public EncodedGraph(byte[] encoding, int startOffset, Object[] objects, NodeClass<?>[] types, StructuredGraph sourceGraph) {
        this(encoding, startOffset, objects, types, sourceGraph.getAssumptions(), sourceGraph.getMethods(), sourceGraph.hasUnsafeAccess(), sourceGraph.trackNodeSourcePosition());
    }

    public EncodedGraph(byte[] encoding, int startOffset, Object[] objects, NodeClass<?>[] types, Assumptions assumptions, List<ResolvedJavaMethod> inlinedMethods, boolean hasUnsafeAccess, boolean trackNodeSourcePosition) {
        this.encoding = encoding;
        this.startOffset = startOffset;
        this.objects = objects;
        this.types = types;
        this.assumptions = assumptions;
        this.inlinedMethods = inlinedMethods;
        this.trackNodeSourcePosition = trackNodeSourcePosition;
        this.hasUnsafeAccess = hasUnsafeAccess;
    }

    public byte[] getEncoding() {
        return this.encoding;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public int getNumObjects() {
        return this.objects.length;
    }

    public Object getObject(int i) {
        return this.objects[i];
    }

    public NodeClass<?>[] getNodeClasses() {
        return this.types;
    }

    public Assumptions getAssumptions() {
        return this.assumptions;
    }

    public List<ResolvedJavaMethod> getInlinedMethods() {
        return this.inlinedMethods;
    }

    public boolean trackNodeSourcePosition() {
        return this.trackNodeSourcePosition;
    }

    public boolean hasUnsafeAccess() {
        return this.hasUnsafeAccess;
    }

    public boolean isCallToOriginal(ResolvedJavaMethod callTarget) {
        return false;
    }
}

