/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractFixedGuardNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ShortCircuitOrNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.spi.SwitchFoldable;

@NodeInfo(nameTemplate="FixedGuard(!={p#negated}) {p#reason/s}", allowedUsageTypes={InputType.Guard}, size=NodeSize.SIZE_2, cycles=NodeCycles.CYCLES_2)
public final class FixedGuardNode
extends AbstractFixedGuardNode
implements Lowerable,
IterableNodeType,
SwitchFoldable {
    public static final NodeClass<FixedGuardNode> TYPE = NodeClass.create(FixedGuardNode.class);

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, false);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, boolean negated) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, negated);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
        this(condition, deoptReason, action, SpeculationLog.NO_SPECULATION, negated, noDeoptSuccessorPosition);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated) {
        super(TYPE, condition, deoptReason, action, speculation, negated);
    }

    public FixedGuardNode(LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
        super(TYPE, condition, deoptReason, action, speculation, negated, noDeoptSuccessorPosition);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        super.simplify(tool);
        if (this.getCondition() instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)this.getCondition();
            if (c.getValue() == this.isNegated()) {
                FixedNode currentNext = this.next();
                if (currentNext != null) {
                    tool.deleteBranch(currentNext);
                }
                DeoptimizeNode deopt = this.graph().add(new DeoptimizeNode(this.getAction(), this.getReason(), this.getSpeculation()));
                deopt.setStateBefore(this.stateBefore());
                this.setNext(deopt);
            }
            this.replaceAtUsages(null);
            this.graph().removeFixed(this);
        } else if (this.getCondition() instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOr = (ShortCircuitOrNode)this.getCondition();
            if (this.isNegated() && this.hasNoUsages()) {
                this.graph().addAfterFixed(this, this.graph().add(new FixedGuardNode(shortCircuitOr.getY(), this.getReason(), this.getAction(), this.getSpeculation(), !shortCircuitOr.isYNegated(), this.getNoDeoptSuccessorPosition())));
                this.graph().replaceFixedWithFixed(this, this.graph().add(new FixedGuardNode(shortCircuitOr.getX(), this.getReason(), this.getAction(), this.getSpeculation(), !shortCircuitOr.isXNegated(), this.getNoDeoptSuccessorPosition())));
            }
        }
    }

    @Override
    public void lower(LoweringTool tool) {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            if (this.graph().getGuardsStage().allowsFloatingGuards()) {
                if (this.getAction() != DeoptimizationAction.None) {
                    ValueNode guard = tool.createGuard(this, this.getCondition(), this.getReason(), this.getAction(), this.getSpeculation(), this.isNegated(), this.getNoDeoptSuccessorPosition()).asNode();
                    this.replaceAtUsages(guard);
                    this.graph().removeFixed(this);
                }
            } else {
                this.lowerToIf().lower(tool);
            }
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public Node getNextSwitchFoldableBranch() {
        return this.next();
    }

    @Override
    public boolean isInSwitch(ValueNode switchValue) {
        return this.hasNoUsages() && this.isNegated() && SwitchFoldable.maybeIsInSwitch(this.condition()) && SwitchFoldable.sameSwitchValue(this.condition(), switchValue);
    }

    @Override
    public void cutOffCascadeNode() {
    }

    @Override
    public void cutOffLowestCascadeNode() {
        this.setNext(null);
    }

    @Override
    public boolean isDefaultSuccessor(AbstractBeginNode beginNode) {
        return beginNode.next() == this.next();
    }

    @Override
    public AbstractBeginNode getDefault() {
        FixedNode defaultNode = this.next();
        this.setNext(null);
        return BeginNode.begin(defaultNode);
    }

    @Override
    public ValueNode switchValue() {
        if (SwitchFoldable.maybeIsInSwitch(this.condition())) {
            return ((IntegerEqualsNode)this.condition()).getX();
        }
        return null;
    }

    @Override
    public boolean isNonInitializedProfile() {
        return true;
    }

    @Override
    public ProfileData.ProfileSource profileSource() {
        return ProfileData.ProfileSource.INJECTED;
    }

    @Override
    public int intKeyAt(int i) {
        assert (i == 0);
        return ((IntegerEqualsNode)this.condition()).getY().asJavaConstant().asInt();
    }

    @Override
    public double keyProbability(int i) {
        return 0.0;
    }

    @Override
    public AbstractBeginNode keySuccessor(int i) {
        DeoptimizeNode deopt = new DeoptimizeNode(this.getAction(), this.getReason(), this.getSpeculation());
        deopt.setNodeSourcePosition(this.getNodeSourcePosition());
        BeginNode begin = new BeginNode();
        begin.next = deopt;
        return begin;
    }

    @Override
    public double defaultProbability() {
        return 1.0;
    }
}

