/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.DeoptimizingGuard;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FloatingAnchoredNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(nameTemplate="Guard(!={p#negated}) {p#reason/s}", allowedUsageTypes={InputType.Guard}, size=NodeSize.SIZE_2, cycles=NodeCycles.CYCLES_2)
public class GuardNode
extends FloatingAnchoredNode
implements Canonicalizable,
GuardingNode,
DeoptimizingGuard,
IterableNodeType {
    public static final NodeClass<GuardNode> TYPE = NodeClass.create(GuardNode.class);
    @Node.Input(value=InputType.Condition)
    protected LogicNode condition;
    protected DeoptimizationReason reason;
    protected DeoptimizationAction action;
    protected SpeculationLog.Speculation speculation;
    protected boolean negated;
    protected NodeSourcePosition noDeoptSuccessorPosition;

    public GuardNode(LogicNode condition, AnchoringNode anchor, DeoptimizationReason reason, DeoptimizationAction action, boolean negated, SpeculationLog.Speculation speculation, NodeSourcePosition noDeoptSuccessorPosition) {
        this(TYPE, condition, anchor, reason, action, negated, speculation, noDeoptSuccessorPosition);
    }

    protected GuardNode(NodeClass<? extends GuardNode> c, LogicNode condition, AnchoringNode anchor, DeoptimizationReason reason, DeoptimizationAction action, boolean negated, SpeculationLog.Speculation speculation, NodeSourcePosition noDeoptSuccessorPosition) {
        super(c, StampFactory.forVoid(), anchor);
        this.condition = condition;
        this.reason = reason;
        this.action = action;
        this.negated = negated;
        this.speculation = speculation;
        this.noDeoptSuccessorPosition = noDeoptSuccessorPosition;
    }

    @Override
    public LogicNode getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(LogicNode x, boolean negated) {
        this.updateUsages(this.condition, x);
        this.condition = x;
        this.negated = negated;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public DeoptimizationReason getReason() {
        return this.reason;
    }

    @Override
    public DeoptimizationAction getAction() {
        return this.action;
    }

    @Override
    public SpeculationLog.Speculation getSpeculation() {
        return this.speculation;
    }

    public void setSpeculation(SpeculationLog.Speculation speculation) {
        this.speculation = speculation;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name && this.negated) {
            return "!" + super.toString(verbosity);
        }
        return super.toString(verbosity);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        LogicConstantNode c;
        if (this.getCondition() instanceof LogicNegationNode) {
            LogicNegationNode negation = (LogicNegationNode)this.getCondition();
            return new GuardNode(negation.getValue(), this.getAnchor(), this.reason, this.action, !this.negated, this.speculation, this.noDeoptSuccessorPosition);
        }
        if (this.getCondition() instanceof LogicConstantNode && (c = (LogicConstantNode)this.getCondition()).getValue() != this.negated) {
            return null;
        }
        return this;
    }

    public FixedWithNextNode lowerGuard() {
        return null;
    }

    public void negate() {
        this.negated = !this.negated;
    }

    @Override
    public void setAction(DeoptimizationAction invalidaterecompile) {
        this.action = invalidaterecompile;
    }

    @Override
    public void setReason(DeoptimizationReason reason) {
        this.reason = reason;
    }

    @Override
    public NodeSourcePosition getNoDeoptSuccessorPosition() {
        return this.noDeoptSuccessorPosition;
    }

    @Override
    public void setNoDeoptSuccessorPosition(NodeSourcePosition noDeoptSuccessorPosition) {
        this.noDeoptSuccessorPosition = noDeoptSuccessorPosition;
    }
}

