/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FloatingGuardedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class GuardedValueNode
extends FloatingGuardedNode
implements LIRLowerable,
Virtualizable,
Canonicalizable,
ValueProxy {
    public static final NodeClass<GuardedValueNode> TYPE = NodeClass.create(GuardedValueNode.class);
    @Node.Input
    ValueNode object;

    public GuardedValueNode(ValueNode object, GuardingNode guard) {
        super(TYPE, object.stamp(NodeView.DEFAULT), guard);
        this.object = object;
    }

    public static ValueNode create(ValueNode object, GuardingNode guard) {
        if (guard == null) {
            return object;
        }
        return new GuardedValueNode(object, guard);
    }

    public ValueNode object() {
        return this.object;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (this.object.getStackKind() != JavaKind.Void && this.object.getStackKind() != JavaKind.Illegal) {
            generator.setResult(this, generator.operand(this.object));
        }
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.object().stamp(NodeView.DEFAULT));
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            tool.replaceWithVirtual((VirtualObjectNode)alias);
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.guard == null) {
            if (this.stamp(NodeView.DEFAULT).equals(this.object().stamp(NodeView.DEFAULT))) {
                return this.object();
            }
            return PiNode.create(this.object(), this.stamp(NodeView.DEFAULT));
        }
        return this;
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.object;
    }
}

