/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;

public class InliningLog {
    private static final String TREE_NODE = "\u251c\u2500\u2500";
    private static final String LAST_TREE_NODE = "\u2514\u2500\u2500";
    private final Callsite root;
    private final EconomicMap<Invokable, Callsite> leaves;
    private final boolean enabled;
    private final DebugContext debug;
    private UpdateScope noUpdates = new UpdateScope((oldNode, newNode) -> {});
    private UpdateScope currentUpdateScope = null;
    private RootScope currentRootScope = null;

    public InliningLog(ResolvedJavaMethod rootMethod, boolean enabled, DebugContext debug) {
        this.root = new Callsite(null, null);
        this.root.target = rootMethod;
        this.leaves = EconomicMap.create();
        this.enabled = enabled;
        this.debug = debug;
    }

    public void addDecision(Invokable invoke, boolean positive, String phase, EconomicMap<Node, Node> replacements, InliningLog calleeLog, String reason, Object ... args) {
        if (this.debug.hasCompilationListener()) {
            String message = String.format(reason, args);
            this.debug.notifyInlining(invoke.getContextMethod(), invoke.getTargetMethod(), positive, message, invoke.bci());
        }
        if (!this.enabled) {
            return;
        }
        assert (this.leaves.containsKey((Object)invoke)) : invoke;
        assert (!positive && replacements == null && calleeLog == null || positive && replacements != null && calleeLog != null || positive && replacements == null && calleeLog == null);
        Callsite callsite = (Callsite)this.leaves.get((Object)invoke);
        callsite.target = callsite.invoke.getTargetMethod();
        Decision decision = new Decision(positive, String.format(reason, args), phase, invoke.getTargetMethod());
        callsite.decisions.add(decision);
        if (positive) {
            this.leaves.removeKey((Object)invoke);
            if (calleeLog == null) {
                return;
            }
            EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            for (Callsite calleeChild : calleeLog.root.children) {
                Callsite child = callsite.addChild(calleeChild.invoke);
                this.copyTree(child, calleeChild, (UnmodifiableEconomicMap<Node, Node>)replacements, (EconomicMap<Callsite, Callsite>)mapping);
            }
            MapCursor entries = calleeLog.leaves.getEntries();
            while (entries.advance()) {
                FixedNode invokeFromCallee = ((Invokable)entries.getKey()).asFixedNodeOrNull();
                Callsite callsiteFromCallee = (Callsite)entries.getValue();
                if (invokeFromCallee == null || invokeFromCallee.isDeleted()) continue;
                Invokable inlinedInvokeFromCallee = (Invokable)replacements.get((Object)invokeFromCallee);
                Callsite descendant = (Callsite)mapping.get((Object)callsiteFromCallee);
                this.leaves.put((Object)inlinedInvokeFromCallee, (Object)descendant);
            }
        }
    }

    public void addLog(UnmodifiableEconomicMap<Node, Node> replacements, InliningLog replacementLog) {
        EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (Callsite calleeChild : replacementLog.root.children) {
            Callsite child = this.root.addChild(calleeChild.invoke);
            this.copyTree(child, calleeChild, replacements, (EconomicMap<Callsite, Callsite>)mapping);
        }
        MapCursor entries = replacementLog.leaves.getEntries();
        while (entries.advance()) {
            FixedNode replacementInvoke = ((Invokable)entries.getKey()).asFixedNodeOrNull();
            Callsite replacementCallsite = (Callsite)entries.getValue();
            if (replacementInvoke == null || replacementInvoke.isDeleted()) continue;
            Invokable invoke = (Invokable)replacements.get((Object)replacementInvoke);
            Callsite callsite = (Callsite)mapping.get((Object)replacementCallsite);
            this.leaves.put((Object)invoke, (Object)callsite);
        }
    }

    public void replaceLog(UnmodifiableEconomicMap<Node, Node> replacements, InliningLog replacementLog) {
        assert (this.root.decisions.isEmpty());
        assert (this.root.children.isEmpty());
        assert (this.leaves.isEmpty());
        EconomicMap mapping = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        this.copyTree(this.root, replacementLog.root, replacements, (EconomicMap<Callsite, Callsite>)mapping);
        MapCursor replacementEntries = replacementLog.leaves.getEntries();
        while (replacementEntries.advance()) {
            FixedNode replacementInvoke = ((Invokable)replacementEntries.getKey()).asFixedNodeOrNull();
            Callsite replacementSite = (Callsite)replacementEntries.getValue();
            if (replacementInvoke == null || !replacementInvoke.isAlive()) continue;
            Invokable invoke = (Invokable)replacements.get((Object)replacementInvoke);
            Callsite site = (Callsite)mapping.get((Object)replacementSite);
            this.leaves.put((Object)invoke, (Object)site);
        }
    }

    private void copyTree(Callsite site, Callsite replacementSite, UnmodifiableEconomicMap<Node, Node> replacements, EconomicMap<Callsite, Callsite> mapping) {
        mapping.put((Object)replacementSite, (Object)site);
        site.target = replacementSite.target;
        site.decisions.addAll(replacementSite.decisions);
        FixedNode replacementSiteInvoke = replacementSite.invoke != null ? replacementSite.invoke.asFixedNodeOrNull() : null;
        site.invoke = replacementSiteInvoke != null && replacementSiteInvoke.isAlive() ? (Invokable)replacements.get((Object)replacementSiteInvoke) : null;
        for (Callsite replacementChild : replacementSite.children) {
            Callsite child = new Callsite(site, null);
            site.children.add(child);
            this.copyTree(child, replacementChild, replacements, mapping);
        }
    }

    public void checkInvariants(StructuredGraph graph) {
        for (Invoke invoke : graph.getInvokes()) {
            assert (this.leaves.containsKey((Object)invoke)) : "Invoke " + invoke + " not contained in the leaves.";
        }
        assert (this.root.parent == null);
        this.checkTreeInvariants(this.root);
    }

    private void checkTreeInvariants(Callsite site) {
        for (Callsite child : site.children) {
            assert (site == child.parent) : "Callsite " + site + " with child " + child + " has an invalid parent pointer " + site;
            this.checkTreeInvariants(child);
        }
    }

    public BiConsumer<Invokable, Invokable> getUpdateScope() {
        if (this.currentUpdateScope == null) {
            return null;
        }
        return this.currentUpdateScope.getUpdater();
    }

    public UpdateScope openUpdateScope(BiConsumer<Invokable, Invokable> updater) {
        if (this.enabled) {
            UpdateScope scope = new UpdateScope(updater);
            scope.activate();
            return scope;
        }
        return null;
    }

    public UpdateScope openDefaultUpdateScope() {
        if (this.enabled) {
            this.noUpdates.activate();
            return this.noUpdates;
        }
        return null;
    }

    public RootScope openRootScope(ResolvedJavaMethod callerMethod, ResolvedJavaMethod target, int bci) {
        return this.openRootScope(new PlaceholderInvokable(callerMethod, target, bci));
    }

    public RootScope openRootScope(Invokable invoke) {
        if (this.enabled) {
            if (!this.leaves.containsKey((Object)invoke)) {
                this.trackNewCallsite(invoke);
            }
            RootScope scope = new RootScope(this.currentRootScope, (Callsite)this.leaves.get((Object)invoke));
            ((RootScope)scope).replacementRoot.target = invoke.getTargetMethod();
            scope.activate();
            return scope;
        }
        return null;
    }

    public boolean containsLeafCallsite(Invokable invokable) {
        return this.leaves.containsKey((Object)invokable);
    }

    public Callsite removeLeafCallsite(Invokable invokable) {
        return (Callsite)this.leaves.removeKey((Object)invokable);
    }

    public void addLeafCallsite(Invokable invokable, Callsite callsite) {
        this.leaves.put((Object)invokable, (Object)callsite);
    }

    public void trackNewCallsite(Invokable invoke) {
        assert (!this.leaves.containsKey((Object)invoke));
        Callsite currentRoot = this.findCurrentRoot();
        Callsite callsite = new Callsite(currentRoot, invoke);
        currentRoot.children.add(callsite);
        this.leaves.put((Object)invoke, (Object)callsite);
    }

    private Callsite findCurrentRoot() {
        return this.currentRootScope != null ? this.currentRootScope.replacementRoot : this.root;
    }

    public void trackDuplicatedCallsite(Invokable sibling, Invokable newInvoke) {
        Callsite siblingCallsite = (Callsite)this.leaves.get((Object)sibling);
        Callsite parentCallsite = siblingCallsite.parent;
        Callsite callsite = parentCallsite.addChild(newInvoke);
        this.leaves.put((Object)newInvoke, (Object)callsite);
    }

    public void updateExistingCallsite(Invokable previousInvoke, Invokable newInvoke) {
        Callsite callsite = (Callsite)this.leaves.get((Object)previousInvoke);
        this.leaves.removeKey((Object)previousInvoke);
        this.leaves.put((Object)newInvoke, (Object)callsite);
        callsite.invoke = newInvoke;
    }

    public String formatAsTree(boolean nullIfEmpty) {
        assert (this.root.decisions.isEmpty());
        assert (!this.root.children.isEmpty() || this.leaves.isEmpty());
        if (nullIfEmpty && this.root.children.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(512);
        this.formatAsTree(this.root, "", builder);
        return builder.toString();
    }

    private void formatAsTree(Callsite site, String indent, StringBuilder builder) {
        String position = site.positionString();
        builder.append(indent).append(position).append(": ");
        if (site.decisions.isEmpty()) {
            if (site.parent != null) {
                builder.append("(no decisions made about ").append(site.target != null ? site.target.format("%H.%n(%p)") : "").append(")");
            }
            builder.append(System.lineSeparator());
        } else if (site.decisions.size() == 1) {
            builder.append(site.decisions.get(0).toString());
            builder.append(System.lineSeparator());
        } else {
            builder.append(System.lineSeparator());
            for (Decision decision : site.decisions) {
                String node = decision == site.decisions.get(site.decisions.size() - 1) ? LAST_TREE_NODE : TREE_NODE;
                builder.append(indent + "   " + node).append(decision.toString());
                builder.append(System.lineSeparator());
            }
        }
        for (Callsite child : site.children) {
            this.formatAsTree(child, indent + "  ", builder);
        }
    }

    public static final class PlaceholderInvokable
    implements Invokable {
        private final int bci;
        private final ResolvedJavaMethod callerMethod;
        private final ResolvedJavaMethod method;

        public PlaceholderInvokable(ResolvedJavaMethod callerMethod, ResolvedJavaMethod method, int bci) {
            this.callerMethod = callerMethod;
            this.method = method;
            this.bci = bci;
        }

        @Override
        public ResolvedJavaMethod getTargetMethod() {
            return this.method;
        }

        @Override
        public int bci() {
            return this.bci;
        }

        @Override
        public void setBci(int bci) {
            GraalError.shouldNotReachHere();
        }

        @Override
        public FixedNode asFixedNodeOrNull() {
            return null;
        }

        @Override
        public ResolvedJavaMethod getContextMethod() {
            return this.callerMethod;
        }

        public int hashCode() {
            return Integer.hashCode(this.bci) ^ this.callerMethod.hashCode() ^ this.method.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlaceholderInvokable) {
                PlaceholderInvokable that = (PlaceholderInvokable)obj;
                return that.bci == this.bci && that.method.equals(this.method) && that.callerMethod.equals(this.callerMethod);
            }
            return false;
        }

        public String toString() {
            return String.format("Invokable(caller: %s, bci: %d, method: %s)", this.callerMethod.format("%H.%n"), this.bci, this.method.format("%H.%n"));
        }
    }

    public final class RootScope
    implements AutoCloseable {
        private final RootScope parent;
        private Callsite replacementRoot;

        public RootScope(RootScope parent, Callsite replacementRoot) {
            this.parent = parent;
            this.replacementRoot = replacementRoot;
        }

        void activate() {
            InliningLog.this.currentRootScope = this;
        }

        public Invokable getInvoke() {
            return this.replacementRoot.invoke;
        }

        @Override
        public void close() {
            if (InliningLog.this.enabled) {
                assert (InliningLog.this.currentRootScope != null);
                InliningLog.this.removeLeafCallsite(this.replacementRoot.invoke);
                InliningLog.this.currentRootScope = this.parent;
            }
        }
    }

    public final class UpdateScope
    implements AutoCloseable {
        private BiConsumer<Invokable, Invokable> updater;

        private UpdateScope(BiConsumer<Invokable, Invokable> updater) {
            this.updater = updater;
        }

        public void activate() {
            if (InliningLog.this.currentUpdateScope != null) {
                throw GraalError.shouldNotReachHere("InliningLog updating already set.");
            }
            InliningLog.this.currentUpdateScope = this;
        }

        @Override
        public void close() {
            if (InliningLog.this.enabled) {
                assert (InliningLog.this.currentUpdateScope != null);
                InliningLog.this.currentUpdateScope = null;
            }
        }

        public BiConsumer<Invokable, Invokable> getUpdater() {
            return this.updater;
        }
    }

    class Callsite {
        public final List<Decision> decisions;
        public final List<Callsite> children;
        public Callsite parent;
        public ResolvedJavaMethod target;
        public Invokable invoke;

        Callsite(Callsite parent, Invokable originalInvoke) {
            this.parent = parent;
            this.decisions = new ArrayList<Decision>();
            this.children = new ArrayList<Callsite>();
            this.invoke = originalInvoke;
        }

        public Callsite addChild(Invokable childInvoke) {
            Callsite child = new Callsite(this, childInvoke);
            this.children.add(child);
            return child;
        }

        public String positionString() {
            if (this.parent == null) {
                if (this.target != null) {
                    return "compilation of " + this.target.format("%H.%n(%p)");
                }
                if (this.invoke != null && this.invoke.getTargetMethod() != null) {
                    return "compilation of " + this.invoke.getTargetMethod().getName() + "(bci: " + this.getBci() + ")";
                }
                return "unknown method (bci: " + this.getBci() + ")";
            }
            String position = this.parent.target != null ? MetaUtil.appendLocation((StringBuilder)new StringBuilder(100), (ResolvedJavaMethod)this.parent.target, (int)this.getBci()).toString() : (this.invoke != null && this.invoke.getTargetMethod() != null ? this.invoke.getTargetMethod().getName() + "(bci: " + this.getBci() + ")" : "unknown method (bci: " + this.getBci() + ")");
            return "at " + position;
        }

        public int getBci() {
            return this.invoke != null ? this.invoke.bci() : -1;
        }
    }

    public static final class Decision {
        private final boolean positive;
        private final String reason;
        private final String phase;
        private final ResolvedJavaMethod target;

        private Decision(boolean positive, String reason, String phase, ResolvedJavaMethod target) {
            this.positive = positive;
            this.reason = reason;
            this.phase = phase;
            this.target = target;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public String getReason() {
            return this.reason;
        }

        public String getPhase() {
            return this.phase;
        }

        public ResolvedJavaMethod getTarget() {
            return this.target;
        }

        public String toString() {
            return String.format("<%s> %s: %s, %s", this.phase, this.target != null ? this.target.format("%H.%n(%p)") : "", this.positive ? "yes" : "no", this.reason);
        }
    }
}

