/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;

@NodeInfo
public final class MergeNode
extends AbstractMergeNode {
    public static final NodeClass<MergeNode> TYPE = NodeClass.create(MergeNode.class);

    public MergeNode() {
        super((NodeClass<? extends AbstractMergeNode>)TYPE);
    }

    public static void removeMergeIfDegenerated(MergeNode node) {
        if (node.forwardEndCount() == 1 && node.hasNoUsages()) {
            FixedNode currentNext = node.next();
            node.setNext(null);
            EndNode forwardEnd = node.forwardEndAt(0);
            forwardEnd.replaceAtPredecessor(currentNext);
            node.safeDelete();
            forwardEnd.safeDelete();
        }
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.forwardEndCount() > 1, "Must merge more than one end.", new Object[0]);
        return super.verify();
    }
}

