/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.MinMaxNode;

@NodeInfo(shortName="MAX")
public class MaxNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.Max> {
    public static final NodeClass<MaxNode> TYPE = NodeClass.create(MaxNode.class);

    protected MaxNode(ValueNode x, ValueNode y) {
        super(TYPE, MaxNode.getArithmeticOpTable(x).getMax(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> getOp(ArithmeticOpTable table) {
        return table.getMax();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMax();
        ConstantNode tryConstantFold = MaxNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new MaxNode(x, y).maybeCommuteInputs();
    }
}

