/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_4)
public final class ObjectIsArrayNode
extends UnaryOpLogicNode
implements Lowerable {
    public static final NodeClass<ObjectIsArrayNode> TYPE = NodeClass.create(ObjectIsArrayNode.class);

    protected ObjectIsArrayNode(ValueNode object) {
        super(TYPE, object);
    }

    public static LogicNode create(ValueNode forValue) {
        return ObjectIsArrayNode.canonicalized(null, forValue);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return ObjectIsArrayNode.canonicalized(this, forValue);
    }

    private static LogicNode canonicalized(ObjectIsArrayNode node, ValueNode forValue) {
        TriState triState = ObjectIsArrayNode.doTryFold(forValue.stamp(NodeView.DEFAULT));
        if (triState.isKnown()) {
            return LogicConstantNode.forBoolean(triState.toBoolean());
        }
        return node != null ? node : new ObjectIsArrayNode(forValue);
    }

    @Override
    public Stamp getSucceedingStampForValue(boolean negated) {
        if (negated) {
            return null;
        }
        AbstractObjectStamp pointerStamp = (AbstractObjectStamp)this.getValue().stamp(NodeView.DEFAULT).unrestricted();
        return pointerStamp.asAlwaysArray();
    }

    @Override
    public TriState tryFold(Stamp valueStamp) {
        return ObjectIsArrayNode.doTryFold(valueStamp);
    }

    private static TriState doTryFold(Stamp valueStamp) {
        if (valueStamp instanceof ObjectStamp) {
            ObjectStamp objectStamp = (ObjectStamp)valueStamp;
            if (objectStamp.isAlwaysArray()) {
                return TriState.TRUE;
            }
            ResolvedJavaType type = StampTool.typeOrNull(objectStamp);
            if (type != null && !type.isJavaLangObject() && !type.isInterface()) {
                assert (!type.isArray()) : "Positive case already covered by isAlwaysArray check above";
                return TriState.get((boolean)type.isArray());
            }
        }
        return TriState.UNKNOWN;
    }
}

