/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.PluginReplacementNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedFoldInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;

public abstract class GeneratedInvocationPlugin
implements InvocationPlugin {
    private ResolvedJavaMethod executeMethod;

    public abstract Class<? extends Annotation> getSource();

    @Override
    public boolean inlineOnly() {
        return true;
    }

    @Override
    public abstract boolean execute(GraphBuilderContext var1, ResolvedJavaMethod var2, InvocationPlugin.Receiver var3, ValueNode[] var4);

    @Override
    public String getSourceLocation() {
        Class<?> c = this.getClass();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("execute")) continue;
            return String.format("%s.%s()", m.getClass().getName(), m.getName());
        }
        throw new GraalError("could not find method named \"execute\" in " + c.getName());
    }

    protected boolean checkInjectedArgument(GraphBuilderContext b, ValueNode arg, ResolvedJavaMethod foldAnnotatedMethod) {
        if (arg.isNullConstant()) {
            return true;
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            return true;
        }
        if (b.getMethod().equals(foldAnnotatedMethod)) {
            return false;
        }
        if (Services.IS_BUILDING_NATIVE_IMAGE) {
            ResolvedJavaType foldNodeClass = b.getMetaAccess().lookupJavaType(PluginReplacementNode.ReplacementFunction.class);
            if (foldNodeClass.isAssignableFrom(b.getMethod().getDeclaringClass())) {
                return false;
            }
            ResolvedJavaType foldPluginClass = b.getMetaAccess().lookupJavaType(GeneratedFoldInvocationPlugin.class);
            if (foldPluginClass.isAssignableFrom(b.getMethod().getDeclaringClass())) {
                return false;
            }
        }
        ResolvedJavaMethod thisExecuteMethod = this.getExecutedMethod(b);
        if (b.getMethod().equals(thisExecuteMethod)) {
            return true;
        }
        throw new AssertionError((Object)("must pass null to injected argument of " + foldAnnotatedMethod.format("%H.%n(%p)") + ", not " + arg + " in " + b.getMethod().format("%H.%n(%p)")));
    }

    private ResolvedJavaMethod getExecutedMethod(GraphBuilderContext b) {
        if (this.executeMethod == null) {
            MetaAccessProvider metaAccess = b.getMetaAccess();
            ResolvedJavaMethod baseMethod = metaAccess.lookupJavaMethod((Executable)GeneratedInvocationPlugin.getExecuteMethod());
            ResolvedJavaType thisClass = metaAccess.lookupJavaType(this.getClass());
            this.executeMethod = thisClass.resolveConcreteMethod(baseMethod, thisClass);
        }
        return this.executeMethod;
    }

    private static Method getExecuteMethod() {
        try {
            return GeneratedInvocationPlugin.class.getMethod("execute", GraphBuilderContext.class, ResolvedJavaMethod.class, InvocationPlugin.Receiver.class, ValueNode[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new GraalError(e);
        }
    }

    public final boolean isGeneratedFromFoldOrNodeIntrinsic() {
        return this.getSource().equals(Fold.class) || this.getSource().equals(Node.NodeIntrinsic.class);
    }
}

