/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;

public interface InlineInvokePlugin
extends GraphBuilderPlugin {
    default public InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        return null;
    }

    default public void notifyBeforeInline(ResolvedJavaMethod methodToInline) {
    }

    default public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
    }

    default public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
    }

    public static final class InlineInfo {
        public static final InlineInfo DO_NOT_INLINE_WITH_EXCEPTION = new InlineInfo();
        public static final InlineInfo DO_NOT_INLINE_NO_EXCEPTION = new InlineInfo();
        public static final InlineInfo DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION = new InlineInfo();
        private final ResolvedJavaMethod methodToInline;
        private final MethodSubstitutionPlugin plugin;
        private final BytecodeProvider intrinsicBytecodeProvider;

        public static InlineInfo createStandardInlineInfo(ResolvedJavaMethod methodToInline) {
            return new InlineInfo(methodToInline, null, null);
        }

        public static InlineInfo createIntrinsicInlineInfo(ResolvedJavaMethod methodToInline, BytecodeProvider intrinsicBytecodeProvider) {
            return new InlineInfo(methodToInline, null, intrinsicBytecodeProvider);
        }

        public static InlineInfo createMethodSubstitutionInlineInfo(ResolvedJavaMethod methodToInline, MethodSubstitutionPlugin plugin) {
            return new InlineInfo(methodToInline, plugin, plugin.getBytecodeProvider());
        }

        private InlineInfo() {
            this(null, null, null);
        }

        private InlineInfo(ResolvedJavaMethod methodToInline, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider) {
            this.methodToInline = methodToInline;
            this.plugin = plugin;
            this.intrinsicBytecodeProvider = intrinsicBytecodeProvider;
        }

        public ResolvedJavaMethod getMethodToInline() {
            return this.methodToInline;
        }

        public boolean allowsInlining() {
            return this.methodToInline != null;
        }

        public BytecodeProvider getIntrinsicBytecodeProvider() {
            return this.intrinsicBytecodeProvider;
        }

        public boolean isSubstitution() {
            return this.plugin != null;
        }

        public MethodSubstitutionPlugin getPlugin() {
            return this.plugin;
        }
    }
}

