/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.reflect.Method;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;

public interface InvocationPlugin
extends GraphBuilderPlugin {
    default public boolean inlineOnly() {
        return false;
    }

    default public boolean isDecorator() {
        return false;
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver) {
        return this.defaultHandler(b, targetMethod, receiver, new ValueNode[0]);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg) {
        return this.defaultHandler(b, targetMethod, receiver, arg);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    default public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    default public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode[] argsIncludingReceiver) {
        if (receiver != null) {
            if (!1.$assertionsDisabled && targetMethod.isStatic()) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && argsIncludingReceiver.length <= 0) {
                throw new AssertionError();
            }
            if (argsIncludingReceiver.length == 1) {
                return this.apply(b, targetMethod, receiver);
            }
            if (argsIncludingReceiver.length == 2) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1]);
            }
            if (argsIncludingReceiver.length == 3) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1], argsIncludingReceiver[2]);
            }
            if (argsIncludingReceiver.length == 4) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3]);
            }
            if (argsIncludingReceiver.length == 5) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4]);
            }
            if (argsIncludingReceiver.length == 6) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4], argsIncludingReceiver[5]);
            }
            if (argsIncludingReceiver.length == 7) {
                return this.apply(b, targetMethod, receiver, argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4], argsIncludingReceiver[5], argsIncludingReceiver[6]);
            }
            return this.defaultHandler(b, targetMethod, receiver, argsIncludingReceiver);
        }
        if (!1.$assertionsDisabled && !targetMethod.isStatic()) {
            throw new AssertionError();
        }
        if (argsIncludingReceiver.length == 0) {
            return this.apply(b, targetMethod, null);
        }
        if (argsIncludingReceiver.length == 1) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0]);
        }
        if (argsIncludingReceiver.length == 2) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1]);
        }
        if (argsIncludingReceiver.length == 3) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1], argsIncludingReceiver[2]);
        }
        if (argsIncludingReceiver.length == 4) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3]);
        }
        if (argsIncludingReceiver.length == 5) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4]);
        }
        if (argsIncludingReceiver.length == 6) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4], argsIncludingReceiver[5]);
        }
        if (argsIncludingReceiver.length == 7) {
            return this.apply(b, targetMethod, null, argsIncludingReceiver[0], argsIncludingReceiver[1], argsIncludingReceiver[2], argsIncludingReceiver[3], argsIncludingReceiver[4], argsIncludingReceiver[5], argsIncludingReceiver[6]);
        }
        return this.defaultHandler(b, targetMethod, receiver, argsIncludingReceiver);
    }

    default public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode ... args) {
        throw new GraalError("Invocation plugin for %s does not handle invocations with %d arguments", targetMethod.format("%H.%n(%p)"), args.length);
    }

    default public String getSourceLocation() {
        Class<?> c = this.getClass();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("apply") && !m.getName().equals("defaultHandler")) continue;
            return String.format("%s.%s()", m.getClass().getName(), m.getName());
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            return String.format("%s.%s()", c.getName(), "apply");
        }
        throw new GraalError("could not find method named \"apply\" or \"defaultHandler\" in " + c.getName());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Receiver {
        default public ValueNode get() {
            return this.get(true);
        }

        public ValueNode get(boolean var1);

        default public boolean isConstant() {
            return false;
        }
    }
}

