/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ForeignCallDescriptors;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="We cannot estimate the time of a runtime call.", size=NodeSize.SIZE_8, sizeRationale="Rough estimation for register handling & calling")
public class RegisterFinalizerNode
extends AbstractStateSplit
implements Canonicalizable.Unary<ValueNode>,
LIRLowerable,
Lowerable,
Virtualizable,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<RegisterFinalizerNode> TYPE = NodeClass.create(RegisterFinalizerNode.class);
    @Node.Input
    ValueNode value;

    public RegisterFinalizerNode(ValueNode value) {
        this(TYPE, value);
    }

    protected RegisterFinalizerNode(NodeClass<? extends RegisterFinalizerNode> c, ValueNode value) {
        super((NodeClass<? extends AbstractStateSplit>)c, StampFactory.forVoid());
        this.value = value;
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(ForeignCallDescriptors.REGISTER_FINALIZER);
        gen.getLIRGeneratorTool().emitForeignCall(linkage, gen.state(this), gen.operand(this.getValue()));
    }

    public static boolean mayHaveFinalizer(ValueNode object, MetaAccessProvider metaAccess, Assumptions assumptions) {
        ObjectStamp objectStamp = (ObjectStamp)object.stamp(NodeView.DEFAULT);
        ResolvedJavaType objectType = StampTool.typeOrNull(objectStamp, metaAccess);
        if (objectStamp.isExactType()) {
            return objectType.hasFinalizer();
        }
        Assumptions.AssumptionResult result = objectType.hasFinalizableSubclass();
        if (result.canRecordTo(assumptions)) {
            result.recordTo(assumptions);
            return (Boolean)result.getResult();
        }
        return true;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        if (!(forValue.stamp(view) instanceof ObjectStamp)) {
            return this;
        }
        if (!RegisterFinalizerNode.mayHaveFinalizer(forValue, tool.getMetaAccess(), this.graph().getAssumptions())) {
            return null;
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getValue());
        if (alias instanceof VirtualObjectNode && !((VirtualObjectNode)alias).type().hasFinalizer()) {
            tool.delete();
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }
}

