/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.List;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.util.UnsignedLong;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class DefaultLoopPolicies
implements LoopPolicies {
    @Override
    public boolean shouldPeel(LoopEx loop, ControlFlowGraph cfg, CoreProviders providers) {
        StructuredGraph graph;
        OptionValues options;
        LoopBeginNode loopBegin = loop.loopBegin();
        double entryProbability = cfg.blockFor(loopBegin.forwardEnd()).getRelativeFrequency();
        if (entryProbability < (double)GraalOptions.MinimumPeelFrequency.getValue(options = (graph = cfg.graph).getOptions()).floatValue()) {
            return false;
        }
        if (loop.parent() != null && loop.size() > loop.parent().size() >> 1) {
            return false;
        }
        if (loop.loop().getChildren().size() > 0) {
            return false;
        }
        return loop.size() + graph.getNodeCount() <= GraalOptions.MaximumDesiredSize.getValue(options);
    }

    public FullUnrollability canFullUnroll(LoopEx loop) {
        if (!(loop.isCounted() && loop.counted().isConstantMaxTripCount() && loop.counted().counterNeverOverflows())) {
            return FullUnrollability.NOT_COUNTED;
        }
        if (!loop.canDuplicateLoop()) {
            return FullUnrollability.MUST_NOT_DUPLICATE;
        }
        OptionValues options = loop.entryPoint().getOptions();
        CountedLoopInfo counted = loop.counted();
        UnsignedLong maxTrips = counted.constantMaxTripCount();
        if (maxTrips.equals(0L)) {
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        if (maxTrips.isGreaterThan(Options.FullUnrollMaxIterations.getValue(options).intValue())) {
            return FullUnrollability.TOO_MANY_ITERATIONS;
        }
        int globalMax = GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount();
        if (globalMax <= 0) {
            return FullUnrollability.TOO_LARGE;
        }
        int maxNodes = counted.isExactTripCount() ? Options.ExactFullUnrollMaxNodes.getValue(options).intValue() : Options.FullUnrollMaxNodes.getValue(options).intValue();
        for (Node usage : counted.getLimitCheckedIV().valueNode().usages()) {
            CompareNode compare;
            if (!(usage instanceof CompareNode) || !(compare = (CompareNode)usage).getY().isConstant()) continue;
            maxNodes += Options.FullUnrollConstantCompareBoost.getValue(options).intValue();
        }
        maxNodes = Math.min(maxNodes, globalMax);
        int size = loop.inside().nodes().count();
        size -= 2;
        GraalError.guarantee((size -= loop.loopBegin().loopEnds().count()) >= 0, "Wrong size");
        if (maxTrips.minus(1L).times(size).isLessOrEqualTo(maxNodes)) {
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        return FullUnrollability.TOO_LARGE;
    }

    @Override
    public boolean shouldFullUnroll(LoopEx loop) {
        return this.canFullUnroll(loop) == FullUnrollability.SHOULD_FULL_UNROLL;
    }

    @Override
    public boolean shouldPartiallyUnroll(LoopEx loop, CoreProviders providers) {
        LoopBeginNode loopBegin = loop.loopBegin();
        if (!loop.isCounted()) {
            loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s isn't counted", (Object)loopBegin);
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        int maxNodes = Options.ExactPartialUnrollMaxNodes.getValue(options);
        maxNodes = Math.min(maxNodes, Math.max(0, GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount()));
        int size = Math.max(1, loop.size() - 1 - loop.loopBegin().phis().count());
        int unrollFactor = loopBegin.getUnrollFactor();
        if (unrollFactor == 1) {
            double loopFrequency = loop.localLoopFrequency();
            if (loopBegin.isSimpleLoop() && loopFrequency < 5.0) {
                loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s frequency too low %s ", (Object)loopBegin, (Object)loopFrequency);
                return false;
            }
            loopBegin.setLoopOrigFrequency(loopFrequency);
        }
        int maxUnroll = Options.UnrollMaxIterations.getValue(options);
        size += size;
        if (maxUnroll == 1 && loopBegin.isSimpleLoop() || size <= maxNodes && unrollFactor < maxUnroll) {
            if ((int)loopBegin.loopOrigFrequency() < unrollFactor * 2) {
                return false;
            }
            for (Node node : loop.inside().nodes()) {
                if (node instanceof ControlFlowAnchorNode) {
                    return false;
                }
                if (!(node instanceof Invoke) && !(node instanceof ForeignCall)) continue;
                return false;
            }
            return true;
        }
        loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s unrolled loop is too large %s ", (Object)loopBegin, size);
        return false;
    }

    @Override
    public boolean shouldTryUnswitch(LoopEx loop) {
        LoopBeginNode loopBegin = loop.loopBegin();
        double loopFrequency = loop.localLoopFrequency();
        if (loopFrequency <= 1.0) {
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        return loopBegin.unswitches() < GraalOptions.LoopMaxUnswitch.getValue(options);
    }

    @Override
    public LoopPolicies.UnswitchingDecision shouldUnswitch(LoopEx loop, List<ControlSplitNode> controlSplits) {
        if (loop.loopBegin().unswitches() >= GraalOptions.LoopMaxUnswitch.getValue(loop.loopBegin().graph().getOptions())) {
            return LoopPolicies.UnswitchingDecision.NO;
        }
        int phis = 0;
        StructuredGraph graph = loop.loopBegin().graph();
        DebugContext debug = graph.getDebug();
        NodeBitMap branchNodes = graph.createNodeBitMap();
        for (ControlSplitNode controlSplit : controlSplits) {
            for (Node successor : controlSplit.successors()) {
                AbstractBeginNode branch = (AbstractBeginNode)successor;
                loop.nodesInLoopBranch(branchNodes, branch);
            }
            Block postDomBlock = loop.loopsData().getCFG().blockFor(controlSplit).getPostdominator();
            if (postDomBlock == null) continue;
            IsolatedInitialization.UNSWITCH_SPLIT_WITH_PHIS.increment(debug);
            phis += ((MergeNode)postDomBlock.getBeginNode()).phis().count();
        }
        int inBranchTotal = branchNodes.count();
        CountingClosure stateNodesCount = new CountingClosure();
        double loopFrequency = loop.localLoopFrequency();
        OptionValues options = loop.loopBegin().getOptions();
        int maxDiff = Options.LoopUnswitchTrivial.getValue(options) + (int)(Options.LoopUnswitchFrequencyBoost.getValue(options) * (loopFrequency - 1.0 + (double)phis));
        maxDiff = Math.min(maxDiff, Options.LoopUnswitchMaxIncrease.getValue(options));
        int remainingGraphSpace = GraalOptions.MaximumDesiredSize.getValue(options) - graph.getNodeCount();
        maxDiff = Math.min(maxDiff, remainingGraphSpace);
        loop.loopBegin().stateAfter().applyToVirtual(stateNodesCount);
        int loopTotal = loop.size() - loop.loopBegin().phis().count() - stateNodesCount.count - 1;
        int actualDiff = loopTotal - inBranchTotal;
        ControlSplitNode firstSplit = controlSplits.get(0);
        int copies = firstSplit.successors().count() - 1;
        debug.log("shouldUnswitch(%s, %s) : delta=%d (%.2f%% inside of branches), max=%d, f=%.2f, phis=%d -> %b", loop, controlSplits, (Object)(actualDiff *= copies), (Object)((double)inBranchTotal / (double)loopTotal * 100.0), (Object)maxDiff, (Object)loopFrequency, (Object)phis, (Object)(actualDiff <= maxDiff ? 1 : 0));
        if (actualDiff <= maxDiff) {
            return loop.canDuplicateLoop() ? LoopPolicies.UnswitchingDecision.YES : LoopPolicies.UnswitchingDecision.NO;
        }
        return LoopPolicies.UnswitchingDecision.NO;
    }

    private static class IsolatedInitialization {
        static final CounterKey UNSWITCH_SPLIT_WITH_PHIS = DebugContext.counter("UnswitchSplitWithPhis");

        private IsolatedInitialization() {
        }
    }

    private static final class CountingClosure
    implements VirtualState.VirtualClosure {
        int count;

        private CountingClosure() {
        }

        @Override
        public void apply(VirtualState node) {
            ++this.count;
        }
    }

    public static enum FullUnrollability {
        SHOULD_FULL_UNROLL,
        NOT_COUNTED,
        MUST_NOT_DUPLICATE,
        TOO_MANY_ITERATIONS,
        TOO_LARGE;

    }

    public static class Options {
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> LoopUnswitchMaxIncrease = new OptionKey<Integer>(500);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> LoopUnswitchTrivial = new OptionKey<Integer>(10);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Double> LoopUnswitchFrequencyBoost = new OptionKey<Double>(10.0);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> FullUnrollMaxNodes = new OptionKey<Integer>(400);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> FullUnrollConstantCompareBoost = new OptionKey<Integer>(15);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> FullUnrollMaxIterations = new OptionKey<Integer>(600);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> ExactFullUnrollMaxNodes = new OptionKey<Integer>(800);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> ExactPartialUnrollMaxNodes = new OptionKey<Integer>(200);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> UnrollMaxIterations = new OptionKey<Integer>(16);
    }
}

