/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.LinkedList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.debug.NeverStripMineNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.loop.BasicInductionVariable;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.DerivedConvertedInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedOffsetInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedScaledInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopFragment;
import org.graalvm.compiler.nodes.loop.LoopFragmentInside;
import org.graalvm.compiler.nodes.loop.LoopFragmentInsideBefore;
import org.graalvm.compiler.nodes.loop.LoopFragmentInsideFrom;
import org.graalvm.compiler.nodes.loop.LoopFragmentWhole;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.util.GraphUtil;

public class LoopEx {
    protected final Loop<Block> loop;
    protected LoopFragmentInside inside;
    protected LoopFragmentWhole whole;
    protected CountedLoopInfo counted;
    protected LoopsData data;
    protected EconomicMap<Node, InductionVariable> ivs;
    protected boolean countedLoopChecked;
    protected int size = -1;

    protected LoopEx(Loop<Block> loop, LoopsData data) {
        this.loop = loop;
        this.data = data;
    }

    public double localLoopFrequency() {
        return this.data.getCFG().localLoopFrequency(this.loopBegin());
    }

    public ProfileData.ProfileSource localFrequencySource() {
        return this.data.getCFG().localLoopFrequencySource(this.loopBegin());
    }

    public Loop<Block> loop() {
        return this.loop;
    }

    public LoopFragmentInside inside() {
        if (this.inside == null) {
            this.inside = new LoopFragmentInside(this);
        }
        return this.inside;
    }

    public LoopFragmentWhole whole() {
        if (this.whole == null) {
            this.whole = new LoopFragmentWhole(this);
        }
        return this.whole;
    }

    public void invalidateFragments() {
        this.inside = null;
        this.whole = null;
    }

    public void invalidateFragmentsAndIVs() {
        this.inside = null;
        this.whole = null;
        this.ivs = null;
    }

    public LoopFragmentInsideFrom insideFrom(FixedNode point) {
        return null;
    }

    public LoopFragmentInsideBefore insideBefore(FixedNode point) {
        return null;
    }

    public boolean isOutsideLoop(Node n) {
        return !this.whole().contains(n);
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loop().getHeader().getBeginNode();
    }

    public FixedNode predecessor() {
        return (FixedNode)this.loopBegin().forwardEnd().predecessor();
    }

    public FixedNode entryPoint() {
        return this.loopBegin().forwardEnd();
    }

    public boolean isCounted() {
        assert (this.countedLoopChecked);
        return this.counted != null;
    }

    public CountedLoopInfo counted() {
        assert (this.countedLoopChecked);
        return this.counted;
    }

    public LoopEx parent() {
        if (this.loop.getParent() == null) {
            return null;
        }
        return this.data.loop(this.loop.getParent());
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.whole().nodes().count();
        }
        return this.size;
    }

    public void resetCounted() {
        assert (this.countedLoopChecked);
        this.ivs = null;
        this.counted = null;
        this.countedLoopChecked = false;
    }

    public String toString() {
        return (this.countedLoopChecked && this.isCounted() ? "CountedLoop [" + this.counted() + "] " : "Loop ") + "(depth=" + this.loop().getDepth() + ") " + this.loopBegin();
    }

    public boolean reassociateInvariants() {
        int count = 0;
        StructuredGraph graph = this.loopBegin().graph();
        InvariantPredicate invariant = new InvariantPredicate();
        NodeBitMap newLoopNodes = graph.createNodeBitMap();
        for (BinaryArithmeticNode binary : this.whole().nodes().filter(BinaryArithmeticNode.class)) {
            DebugContext debug;
            if (!binary.isAssociative()) continue;
            ValueNode result = BinaryArithmeticNode.reassociateMatchedValues(binary, invariant, binary.getX(), binary.getY(), NodeView.DEFAULT);
            if (result == binary) {
                result = BinaryArithmeticNode.reassociateUnmatchedValues(binary, invariant, NodeView.DEFAULT);
            }
            if (result == binary) continue;
            if (!result.isAlive()) {
                assert (!result.isDeleted());
                result = graph.addOrUniqueWithInputs(result);
                newLoopNodes.markAndGrow(result);
                for (Node input : result.inputs()) {
                    if (!this.whole().nodes().isNew(input) || invariant.apply(input)) continue;
                    newLoopNodes.markAndGrow(input);
                }
            }
            if ((debug = graph.getDebug()).isLogEnabled()) {
                debug.log("%s : Re-associated %s into %s", (Object)graph.method().format("%H::%n"), (Object)binary, (Object)result);
            }
            binary.replaceAtUsages(result);
            GraphUtil.killWithUnusedFloatingInputs(binary);
            ++count;
        }
        if (newLoopNodes.isNotEmpty()) {
            this.whole().nodes().union(newLoopNodes);
        }
        return count != 0;
    }

    public boolean detectCounted() {
        if (this.countedLoopChecked) {
            return this.isCounted();
        }
        this.countedLoopChecked = true;
        LoopBeginNode loopBegin = this.loopBegin();
        if (loopBegin.countedLoopDisabled()) {
            return false;
        }
        FixedNode next = loopBegin.next();
        while (next instanceof FixedGuardNode || next instanceof ValueAnchorNode || next instanceof FullInfopointNode) {
            next = ((FixedWithNextNode)next).next();
        }
        if (next instanceof IfNode) {
            LogicNode ifTest;
            IfNode ifNode = (IfNode)next;
            boolean negated = false;
            if (!this.isCfgLoopExit(ifNode.falseSuccessor())) {
                if (!this.isCfgLoopExit(ifNode.trueSuccessor())) {
                    return false;
                }
                negated = true;
            }
            if (!((ifTest = ifNode.condition()) instanceof CompareNode)) {
                return false;
            }
            CompareNode compare = (CompareNode)ifTest;
            Condition condition = null;
            InductionVariable iv = null;
            ValueNode limit = null;
            if (this.isOutsideLoop(compare.getX())) {
                iv = (InductionVariable)this.getInductionVariables().get((Object)compare.getY());
                if (iv != null) {
                    condition = compare.condition().asCondition().mirror();
                    limit = compare.getX();
                }
            } else if (this.isOutsideLoop(compare.getY()) && (iv = (InductionVariable)this.getInductionVariables().get((Object)compare.getX())) != null) {
                condition = compare.condition().asCondition();
                limit = compare.getY();
            }
            if (condition == null) {
                return false;
            }
            if (negated) {
                condition = condition.negate();
            }
            boolean isLimitIncluded = false;
            boolean unsigned = false;
            switch (condition) {
                case EQ: {
                    if (iv.initNode() == limit) {
                        isLimitIncluded = true;
                        break;
                    }
                    return false;
                }
                case NE: {
                    IntegerStamp initStamp = (IntegerStamp)iv.initNode().stamp(NodeView.DEFAULT);
                    IntegerStamp limitStamp = (IntegerStamp)limit.stamp(NodeView.DEFAULT);
                    IntegerStamp counterStamp = (IntegerStamp)iv.valueNode().stamp(NodeView.DEFAULT);
                    if (iv.direction() == InductionVariable.Direction.Up) {
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.upperBound()) break;
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.unsignedUpperBound()) {
                            unsigned = true;
                            break;
                        }
                        if (iv.isConstantStride() && Math.abs(iv.constantStride()) == 1L && initStamp.upperBound() <= limitStamp.lowerBound()) break;
                        return false;
                    }
                    if (iv.direction() == InductionVariable.Direction.Down) {
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.lowerBound()) break;
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.unsignedLowerBound()) {
                            unsigned = true;
                            break;
                        }
                        if (iv.isConstantStride() && Math.abs(iv.constantStride()) == 1L && initStamp.lowerBound() >= limitStamp.upperBound()) break;
                        return false;
                    }
                    return false;
                }
                case BE: {
                    unsigned = true;
                }
                case LE: {
                    isLimitIncluded = true;
                    if (iv.direction() == InductionVariable.Direction.Up) break;
                    return false;
                }
                case BT: {
                    unsigned = true;
                }
                case LT: {
                    if (iv.direction() == InductionVariable.Direction.Up) break;
                    return false;
                }
                case AE: {
                    unsigned = true;
                }
                case GE: {
                    isLimitIncluded = true;
                    if (iv.direction() == InductionVariable.Direction.Down) break;
                    return false;
                }
                case AT: {
                    unsigned = true;
                }
                case GT: {
                    if (iv.direction() == InductionVariable.Direction.Down) break;
                    return false;
                }
                default: {
                    throw GraalError.shouldNotReachHere(condition.toString());
                }
            }
            this.counted = new CountedLoopInfo(this, iv, ifNode, limit, isLimitIncluded, negated ? ifNode.falseSuccessor() : ifNode.trueSuccessor(), unsigned);
            return true;
        }
        return false;
    }

    public boolean isCfgLoopExit(AbstractBeginNode begin) {
        Block block = this.data.getCFG().blockFor(begin);
        return this.loop.getDepth() > block.getLoopDepth() || this.loop.isNaturalExit(block);
    }

    public LoopsData loopsData() {
        return this.data;
    }

    public void nodesInLoopBranch(NodeBitMap branchNodes, AbstractBeginNode branch) {
        EconomicSet blocks = EconomicSet.create();
        LinkedList<AbstractBeginNode> exits = new LinkedList<AbstractBeginNode>();
        LinkedList<Block> work = new LinkedList<Block>();
        ControlFlowGraph cfg = this.loopsData().getCFG();
        work.add(cfg.blockFor(branch));
        while (!work.isEmpty()) {
            Block b = (Block)work.remove();
            if (this.loop().isLoopExit(b)) {
                assert (!exits.contains(b.getBeginNode()));
                exits.add(b.getBeginNode());
                continue;
            }
            if (!blocks.add((Object)b.getBeginNode())) continue;
            for (Block d = (Block)b.getDominatedSibling(); d != null; d = (Block)d.getDominatedSibling()) {
                if (!this.loop.getBlocks().contains(d)) continue;
                work.add(d);
            }
        }
        LoopFragment.computeNodes(branchNodes, branch.graph(), this, (Iterable<AbstractBeginNode>)blocks, exits);
    }

    public EconomicMap<Node, InductionVariable> getInductionVariables() {
        if (this.ivs == null) {
            this.ivs = this.findInductionVariables();
        }
        return this.ivs;
    }

    private EconomicMap<Node, InductionVariable> findInductionVariables() {
        EconomicMap currentIvs = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        LinkedList<InductionVariable> scanQueue = new LinkedList<InductionVariable>();
        LoopBeginNode loopBegin = this.loopBegin();
        AbstractEndNode forwardEnd = loopBegin.forwardEnd();
        for (PhiNode phiNode : loopBegin.valuePhis()) {
            ValueNode stride;
            ValueNode backValue = phiNode.singleBackValueOrThis();
            if (backValue == phiNode || (stride = LoopEx.addSub(this, backValue, phiNode)) == null) continue;
            BasicInductionVariable biv = new BasicInductionVariable(this, (ValuePhiNode)phiNode, phiNode.valueAt(forwardEnd), stride, (BinaryArithmeticNode)backValue);
            currentIvs.put((Object)phiNode, (Object)biv);
            scanQueue.add(biv);
        }
        while (!scanQueue.isEmpty()) {
            InductionVariable baseIv = (InductionVariable)scanQueue.remove();
            ValueNode valueNode = baseIv.valueNode();
            for (ValueNode op : valueNode.usages().filter(ValueNode.class)) {
                if (this.isOutsideLoop(op) || op.hasExactlyOneUsage() && op.usages().first() == valueNode) continue;
                DerivedInductionVariable iv = null;
                ValueNode offset = LoopEx.addSub(this, op, valueNode);
                if (offset != null) {
                    iv = new DerivedOffsetInductionVariable(this, baseIv, offset, (BinaryArithmeticNode)op);
                } else if (op instanceof NegateNode) {
                    iv = new DerivedScaledInductionVariable(this, baseIv, (NegateNode)op);
                } else {
                    ValueNode scale = LoopEx.mul(this, op, valueNode);
                    if (scale != null) {
                        iv = new DerivedScaledInductionVariable(this, baseIv, scale, op);
                    } else {
                        boolean isValidConvert;
                        boolean bl = isValidConvert = op instanceof PiNode || op instanceof SignExtendNode;
                        if (!isValidConvert && op instanceof ZeroExtendNode) {
                            ZeroExtendNode zeroExtendNode = (ZeroExtendNode)op;
                            boolean bl2 = isValidConvert = zeroExtendNode.isInputAlwaysPositive() || ((IntegerStamp)zeroExtendNode.stamp(NodeView.DEFAULT)).isPositive();
                        }
                        if (!isValidConvert && op instanceof NarrowNode) {
                            NarrowNode narrow = (NarrowNode)op;
                            isValidConvert = narrow.isLossless();
                        }
                        if (isValidConvert) {
                            iv = new DerivedConvertedInductionVariable(this, baseIv, op.stamp(NodeView.DEFAULT), op);
                        }
                    }
                }
                if (iv == null) continue;
                currentIvs.put((Object)op, (Object)iv);
                scanQueue.offer(iv);
            }
        }
        return currentIvs;
    }

    private static ValueNode addSub(LoopEx loop, ValueNode op, ValueNode base) {
        if (op.stamp(NodeView.DEFAULT) instanceof IntegerStamp && (op instanceof AddNode || op instanceof SubNode)) {
            BinaryArithmeticNode aritOp = (BinaryArithmeticNode)op;
            if (aritOp.getX() == base && loop.isOutsideLoop(aritOp.getY())) {
                return aritOp.getY();
            }
            if (aritOp.getY() == base && loop.isOutsideLoop(aritOp.getX())) {
                return aritOp.getX();
            }
        }
        return null;
    }

    private static ValueNode mul(LoopEx loop, ValueNode op, ValueNode base) {
        LeftShiftNode shift;
        if (op instanceof MulNode) {
            MulNode mul = (MulNode)op;
            if (mul.getX() == base && loop.isOutsideLoop(mul.getY())) {
                return mul.getY();
            }
            if (mul.getY() == base && loop.isOutsideLoop(mul.getX())) {
                return mul.getX();
            }
        }
        if (op instanceof LeftShiftNode && (shift = (LeftShiftNode)op).getX() == base && shift.getY().isConstant()) {
            return ConstantNode.forIntegerStamp(base.stamp(NodeView.DEFAULT), 1 << shift.getY().asJavaConstant().asInt(), base.graph());
        }
        return null;
    }

    public void deleteUnusedNodes() {
        if (this.ivs != null) {
            for (InductionVariable iv : this.ivs.getValues()) {
                iv.deleteUnusedNodes();
            }
        }
    }

    public boolean canDuplicateLoop() {
        for (Node node : this.inside().nodes()) {
            FrameState frameState;
            if (node instanceof ControlFlowAnchored) {
                return false;
            }
            if (!(node instanceof FrameState) || !(frameState = (FrameState)node).isExceptionHandlingBCI()) continue;
            return false;
        }
        return true;
    }

    public boolean canStripMine() {
        for (Node node : this.inside().nodes()) {
            if (!(node instanceof NeverStripMineNode)) continue;
            return false;
        }
        return true;
    }

    public boolean canBecomeLimitTestAfterFloatingReads(IfNode ifNode) {
        return false;
    }

    private class InvariantPredicate
    implements NodePredicate {
        private final Graph.Mark mark;

        InvariantPredicate() {
            this.mark = LoopEx.this.loopBegin().graph().getMark();
        }

        @Override
        public boolean apply(Node n) {
            if (LoopEx.this.loopBegin().graph().isNew(this.mark, n)) {
                for (Node input : n.inputs()) {
                    if (this.apply(input)) continue;
                    return false;
                }
                return true;
            }
            return LoopEx.this.isOutsideLoop(n);
        }
    }
}

