/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.util;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.options.OptionValues;

public class ConstantFoldUtil {
    public static ConstantNode tryConstantFold(ConstantFieldProvider fieldProvider, final ConstantReflectionProvider constantReflection, final MetaAccessProvider metaAccess, final ResolvedJavaField field, final JavaConstant receiver, final OptionValues options) {
        if (!field.isStatic() && (receiver == null || receiver.isNull())) {
            return null;
        }
        return fieldProvider.readConstantField(field, new ConstantFieldProvider.ConstantFieldTool<ConstantNode>(){

            @Override
            public JavaConstant readValue() {
                return constantReflection.readFieldValue(field, receiver);
            }

            @Override
            public JavaConstant getReceiver() {
                return receiver;
            }

            @Override
            public ConstantNode foldConstant(JavaConstant ret) {
                if (ret != null) {
                    return ConstantNode.forConstant(ret, metaAccess);
                }
                return null;
            }

            @Override
            public ConstantNode foldStableArray(JavaConstant ret, int stableDimensions, boolean isDefaultStable) {
                if (ret != null) {
                    return ConstantNode.forConstant(ret, stableDimensions, isDefaultStable, metaAccess);
                }
                return null;
            }

            @Override
            public OptionValues getOptions() {
                return options;
            }
        });
    }
}

