/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.graalvm.compiler.core.common.util.PhasePlan;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;

public class PhaseSuite<C>
extends BasePhase<C>
implements PhasePlan<BasePhase<? super C>> {
    private List<BasePhase<? super C>> phases = new ArrayList<BasePhase<? super C>>();
    private boolean immutable;

    @Override
    public boolean checkContract() {
        return false;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void setImmutable() {
        if (!this.immutable) {
            this.phases = Collections.unmodifiableList(this.phases);
            this.immutable = true;
        }
    }

    public final void prependPhase(BasePhase<? super C> phase) {
        this.phases.add(0, phase);
    }

    public final void appendPhase(BasePhase<? super C> phase) {
        this.phases.add(phase);
    }

    public final void addBeforeLast(BasePhase<? super C> phase) {
        ListIterator<BasePhase<C>> last = this.findLastPhase();
        if (last.hasPrevious()) {
            last.previous();
        }
        last.add(phase);
    }

    public ListIterator<BasePhase<? super C>> findLastPhase() {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            it.next();
        }
        return it;
    }

    @Override
    public List<BasePhase<? super C>> getPhases() {
        return Collections.unmodifiableList(this.phases);
    }

    @Override
    public String getPhaseName(BasePhase<? super C> phase) {
        return phase.contractorName();
    }

    public String toString() {
        return String.format("%s:%n%s", this.getClass().getSimpleName(), new PhasePlan.Printer().toString(this));
    }

    public final ListIterator<BasePhase<? super C>> findPhase(Class<? extends BasePhase<? super C>> phaseClass) {
        return this.findPhase(phaseClass, false);
    }

    public final ListIterator<BasePhase<? super C>> findPhase(Class<? extends BasePhase<? super C>> phaseClass, boolean recursive) {
        ListIterator<BasePhase<? super C>> it = this.phases.listIterator();
        if (PhaseSuite.findNextPhase(it, phaseClass, recursive)) {
            return it;
        }
        return null;
    }

    public static <C> boolean findNextPhase(ListIterator<BasePhase<? super C>> it, Class<? extends BasePhase<? super C>> phaseClass) {
        return PhaseSuite.findNextPhase(it, phaseClass, false);
    }

    public static <C> boolean findNextPhase(ListIterator<BasePhase<? super C>> it, Class<? extends BasePhase<? super C>> phaseClass, boolean recursive) {
        while (it.hasNext()) {
            PhaseSuite suite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                return true;
            }
            if (!recursive || !(phase instanceof PhaseSuite) || (suite = (PhaseSuite)phase).findPhase(phaseClass, true) == null) continue;
            return true;
        }
        return false;
    }

    public boolean removePhase(Class<? extends BasePhase<? super C>> phaseClass) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                it.remove();
                return true;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).removePhase(phaseClass)) continue;
            if (innerSuite.phases.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    public boolean replacePhase(Class<? extends BasePhase<? super C>> phaseClass, BasePhase<? super C> newPhase) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                it.set(newPhase);
                return true;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).replacePhase(phaseClass, newPhase)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, C context) {
        for (BasePhase<C> phase : this.phases) {
            phase.apply(graph, context);
        }
    }

    public PhaseSuite<C> copy() {
        PhaseSuite<C> suite = new PhaseSuite<C>();
        suite.phases.addAll(this.phases);
        return suite;
    }
}

