/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PrefetchAllocateNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;

public class AddressLoweringByUsePhase
extends BasePhase<CoreProviders> {
    private final AddressLoweringByUse lowering;

    public AddressLoweringByUsePhase(AddressLoweringByUse lowering) {
        this.lowering = lowering;
        assert (lowering != null);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        for (Node node : graph.getNodes()) {
            AddressNode lowered;
            AddressNode address;
            Stamp stamp;
            if (node instanceof ReadNode) {
                ReadNode readNode = (ReadNode)node;
                stamp = readNode.getAccessStamp(NodeView.DEFAULT);
                address = readNode.getAddress();
                lowered = this.lowering.lower(readNode, stamp, address);
            } else if (node instanceof JavaReadNode) {
                JavaReadNode javaReadNode = (JavaReadNode)node;
                stamp = javaReadNode.stamp(NodeView.DEFAULT);
                address = javaReadNode.getAddress();
                lowered = this.lowering.lower(javaReadNode, stamp, address);
            } else if (node instanceof FloatingReadNode) {
                FloatingReadNode floatingReadNode = (FloatingReadNode)node;
                stamp = floatingReadNode.getAccessStamp(NodeView.DEFAULT);
                address = floatingReadNode.getAddress();
                lowered = this.lowering.lower(floatingReadNode, stamp, address);
            } else if (node instanceof AbstractWriteNode) {
                AbstractWriteNode abstractWriteNode = (AbstractWriteNode)node;
                stamp = abstractWriteNode.value().stamp(NodeView.DEFAULT);
                address = abstractWriteNode.getAddress();
                lowered = this.lowering.lower(abstractWriteNode, stamp, address);
            } else {
                if (!(node instanceof PrefetchAllocateNode)) continue;
                PrefetchAllocateNode prefetchAllocateNode = (PrefetchAllocateNode)node;
                stamp = StampFactory.forKind(JavaKind.Object);
                address = (AddressNode)prefetchAllocateNode.inputs().first();
                lowered = this.lowering.lower(prefetchAllocateNode, stamp, address);
            }
            if (lowered == address) continue;
            node.replaceFirstInput(address, lowered);
            if (!address.hasNoUsages()) continue;
            GraphUtil.killWithUnusedFloatingInputs(address);
        }
        for (Node node : graph.getNodes()) {
            if (!(node instanceof OffsetAddressNode)) continue;
            AddressNode address = (AddressNode)node;
            AddressNode lowered = this.lowering.lower(address);
            node.replaceAtUsages(lowered);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    public static abstract class AddressLoweringByUse {
        public abstract AddressNode lower(ValueNode var1, Stamp var2, AddressNode var3);

        public abstract AddressNode lower(AddressNode var1);
    }
}

