/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class BoxNodeIdentityPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        assert (!graph.isAfterStage(StructuredGraph.StageFlag.PARTIAL_ESCAPE)) : this + " must be run before PEA";
        for (BoxNode box : graph.getNodes(BoxNode.TYPE)) {
            if (!box.isAlive() || box.hasIdentity() || box.getValue() instanceof BoxNode.TrustedBoxedValue) continue;
            for (Node usage : box.usages()) {
                if (!(usage instanceof ObjectEqualsNode)) continue;
                ObjectEqualsNode eq = (ObjectEqualsNode)usage;
                ValueNode other = eq.getX();
                if (other == box) {
                    other = eq.getY();
                }
                if (!(other instanceof BoxNode)) continue;
                BoxNode otherBox = (BoxNode)other;
                if (box.getValue() != otherBox.getValue()) continue;
                box.setHasIdentity();
                otherBox.setHasIdentity();
            }
        }
    }
}

