/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MemoryMapControlSinkNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.memory.AddressableMemoryAccess;
import org.graalvm.compiler.nodes.memory.FloatableAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryAnchorNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MemoryMap;
import org.graalvm.compiler.nodes.memory.MemoryMapNode;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.word.LocationIdentity;

public class FloatingReadPhase
extends Phase {
    private boolean createFloatingReads;
    private boolean createMemoryMapNodes;

    public FloatingReadPhase() {
        this(true, false);
    }

    public FloatingReadPhase(boolean createFloatingReads, boolean createMemoryMapNodes) {
        this.createFloatingReads = createFloatingReads;
        this.createMemoryMapNodes = createMemoryMapNodes;
    }

    @Override
    public float codeSizeIncrease() {
        return 1.5f;
    }

    private static EconomicSet<Node> removeExternallyUsedNodes(EconomicSet<Node> set) {
        boolean change;
        do {
            change = false;
            Iterator iter = set.iterator();
            block1: while (iter.hasNext()) {
                Node node = (Node)iter.next();
                for (Node usage : node.usages()) {
                    if (set.contains((Object)usage)) continue;
                    change = true;
                    iter.remove();
                    continue block1;
                }
            }
        } while (change);
        return set;
    }

    protected void processNode(FixedNode node, EconomicSet<LocationIdentity> currentState) {
        if (node instanceof SingleMemoryKill) {
            FloatingReadPhase.processIdentity(currentState, ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity());
        } else if (node instanceof MultiMemoryKill) {
            for (LocationIdentity identity : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                FloatingReadPhase.processIdentity(currentState, identity);
            }
        }
    }

    private static void processIdentity(EconomicSet<LocationIdentity> currentState, LocationIdentity identity) {
        if (identity.isMutable()) {
            currentState.add((Object)identity);
        }
    }

    protected void processBlock(Block b, EconomicSet<LocationIdentity> currentState) {
        for (FixedNode n : b.getNodes()) {
            this.processNode(n, currentState);
        }
    }

    private EconomicSet<LocationIdentity> processLoop(HIRLoop loop, EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops) {
        LoopBeginNode loopBegin = (LoopBeginNode)((Block)loop.getHeader()).getBeginNode();
        EconomicSet result = (EconomicSet)modifiedInLoops.get((Object)loopBegin);
        if (result != null) {
            return result;
        }
        result = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (Loop inner : loop.getChildren()) {
            result.addAll(this.processLoop((HIRLoop)inner, modifiedInLoops));
        }
        for (Block b : loop.getBlocks()) {
            if (b.getLoop() != loop) continue;
            this.processBlock(b, (EconomicSet<LocationIdentity>)result);
        }
        modifiedInLoops.put((Object)loopBegin, (Object)result);
        return result;
    }

    @Override
    protected void run(StructuredGraph graph) {
        Object l2;
        EconomicSet initMemory = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        EconomicMap modifiedInLoops = null;
        if (graph.hasLoops()) {
            modifiedInLoops = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, true, false, false);
            for (Object l2 : cfg.getLoops()) {
                HIRLoop loop = (HIRLoop)l2;
                this.processLoop(loop, (EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>>)modifiedInLoops);
            }
        }
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED, Graph.NodeEvent.ZERO_USAGES));
        Graph.NodeEventScope nes = graph.trackNodeEvents(listener);
        l2 = null;
        try {
            ReentrantNodeIterator.apply(new FloatingReadClosure((EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>>)modifiedInLoops, this.createFloatingReads, this.createMemoryMapNodes, (EconomicSet<ValueNode>)initMemory), graph.start(), new MemoryMapImpl(graph.start()));
        }
        catch (Throwable throwable) {
            l2 = throwable;
            throw throwable;
        }
        finally {
            if (nes != null) {
                if (l2 != null) {
                    try {
                        nes.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)l2).addSuppressed(throwable);
                    }
                } else {
                    nes.close();
                }
            }
        }
        for (Node n : FloatingReadPhase.removeExternallyUsedNodes(listener.getNodes())) {
            if (!n.isAlive() || !(n instanceof FloatingNode)) continue;
            n.replaceAtUsages(null);
            GraphUtil.killWithUnusedFloatingInputs(n);
        }
        if (this.createFloatingReads) {
            assert (graph.isBeforeStage(StructuredGraph.StageFlag.FLOATING_READS));
            graph.setAfterStage(StructuredGraph.StageFlag.FLOATING_READS);
        }
    }

    public static MemoryMapImpl mergeMemoryMaps(AbstractMergeNode merge, List<? extends MemoryMap> states) {
        MemoryMapImpl newState = new MemoryMapImpl();
        EconomicSet keys = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (MemoryMap memoryMap : states) {
            keys.addAll(memoryMap.getLocations());
        }
        assert (FloatingReadPhase.checkNoImmutableLocations((EconomicSet<LocationIdentity>)keys));
        for (LocationIdentity locationIdentity : keys) {
            int mergedStatesCount = 0;
            boolean isPhi = false;
            MemoryKill merged = null;
            for (MemoryMap memoryMap : states) {
                MemoryKill last = memoryMap.getLastLocationAccess(locationIdentity);
                if (isPhi) {
                    ((MemoryPhiNode)merged).addInput(ValueNodeUtil.asNode(last));
                } else if (merged != last) {
                    if (merged == null) {
                        merged = last;
                    } else {
                        MemoryPhiNode phi = merge.graph().addWithoutUnique(new MemoryPhiNode(merge, locationIdentity));
                        for (int j = 0; j < mergedStatesCount; ++j) {
                            phi.addInput(ValueNodeUtil.asNode(merged));
                        }
                        phi.addInput(ValueNodeUtil.asNode(last));
                        merged = phi;
                        isPhi = true;
                    }
                }
                ++mergedStatesCount;
            }
            newState.getMap().put((Object)locationIdentity, merged);
        }
        return newState;
    }

    public static boolean nodeOfMemoryType(Node node) {
        return !(node instanceof MemoryKill) || node instanceof SingleMemoryKill ^ node instanceof MultiMemoryKill;
    }

    private static boolean checkNoImmutableLocations(EconomicSet<LocationIdentity> keys) {
        keys.forEach(t -> {
            assert (t.isMutable());
        });
        return true;
    }

    public static class FloatingReadClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<MemoryMapImpl> {
        private final EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops;
        private boolean createFloatingReads;
        private boolean createMemoryMapNodes;
        private final EconomicSet<ValueNode> initMemory;

        public FloatingReadClosure(EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops, boolean createFloatingReads, boolean createMemoryMapNodes, EconomicSet<ValueNode> initMemory) {
            this.modifiedInLoops = modifiedInLoops;
            this.createFloatingReads = createFloatingReads;
            this.createMemoryMapNodes = createMemoryMapNodes;
            this.initMemory = initMemory;
        }

        @Override
        protected MemoryMapImpl processNode(FixedNode node, MemoryMapImpl state) {
            if (node instanceof LoopExitNode) {
                LoopExitNode loopExitNode = (LoopExitNode)node;
                EconomicSet modifiedInLoop = (EconomicSet)this.modifiedInLoops.get((Object)loopExitNode.loopBegin());
                boolean anyModified = modifiedInLoop.contains((Object)LocationIdentity.any());
                state.getMap().replaceAll((locationIdentity, memoryNode) -> anyModified || modifiedInLoop.contains(locationIdentity) ? ProxyNode.forMemory(memoryNode, loopExitNode, locationIdentity) : memoryNode);
            }
            if (node instanceof MemoryAnchorNode) {
                FloatingReadClosure.processAnchor((MemoryAnchorNode)node, state);
                return state;
            }
            if (node instanceof MemoryAccess) {
                FloatingReadClosure.processAccess((MemoryAccess)((Object)node), state);
            }
            if (this.createFloatingReads && node instanceof FloatableAccessNode) {
                this.processFloatable((FloatableAccessNode)node, state);
            }
            if (node instanceof SingleMemoryKill) {
                this.processCheckpoint((SingleMemoryKill)((Object)node), state);
            } else if (node instanceof MultiMemoryKill) {
                this.processCheckpoint((MultiMemoryKill)((Object)node), state);
            }
            assert (FloatingReadPhase.nodeOfMemoryType(node)) : node;
            if (this.createMemoryMapNodes && node instanceof MemoryMapControlSinkNode) {
                ((MemoryMapControlSinkNode)node).setMemoryMap(node.graph().unique(new MemoryMapNode(state.getMap())));
            }
            return state;
        }

        private static void processAnchor(MemoryAnchorNode anchor, MemoryMapImpl state) {
            for (Node node : anchor.usages().snapshot()) {
                MemoryAccess access;
                if (!(node instanceof MemoryAccess) || (access = (MemoryAccess)((Object)node)).getLastLocationAccess() != anchor) continue;
                MemoryKill lastLocationAccess = state.getLastLocationAccess(access.getLocationIdentity());
                assert (lastLocationAccess != null);
                access.setLastLocationAccess(lastLocationAccess);
            }
            if (anchor.hasNoUsages()) {
                anchor.graph().removeFixed(anchor);
            }
        }

        private static void processAccess(MemoryAccess access, MemoryMapImpl state) {
            LocationIdentity locationIdentity = access.getLocationIdentity();
            if (!locationIdentity.equals(LocationIdentity.any())) {
                MemoryKill lastLocationAccess = state.getLastLocationAccess(locationIdentity);
                access.setLastLocationAccess(lastLocationAccess);
            }
        }

        private void processCheckpoint(SingleMemoryKill checkpoint, MemoryMapImpl state) {
            this.processIdentity(checkpoint.getKilledLocationIdentity(), checkpoint, state);
        }

        private void processCheckpoint(MultiMemoryKill checkpoint, MemoryMapImpl state) {
            for (LocationIdentity identity : checkpoint.getKilledLocationIdentities()) {
                this.processIdentity(identity, checkpoint, state);
            }
        }

        private void processIdentity(LocationIdentity identity, MemoryKill checkpoint, MemoryMapImpl state) {
            if (identity.isAny()) {
                state.getMap().clear();
            }
            if (identity.isMutable()) {
                state.getMap().put((Object)identity, (Object)checkpoint);
            }
            if (checkpoint instanceof AddressableMemoryAccess) {
                AddressNode address = ((AddressableMemoryAccess)((Object)checkpoint)).getAddress();
                if (identity.equals(LocationIdentity.init())) {
                    this.initMemory.add((Object)address.getBase());
                }
            }
        }

        private void processFloatable(FloatableAccessNode accessNode, MemoryMapImpl state) {
            StructuredGraph graph = accessNode.graph();
            LocationIdentity locationIdentity = accessNode.getLocationIdentity();
            if (accessNode.canFloat()) {
                GraalError.guarantee(!this.initMemory.contains((Object)accessNode.getAddress().getBase()), "base used for init cannot be used for other accesses: %s", (Object)accessNode);
                assert (!accessNode.getUsedAsNullCheck());
                MemoryKill lastLocationAccess = state.getLastLocationAccess(locationIdentity);
                try (DebugCloseable position = accessNode.withNodeSourcePosition();){
                    FloatingAccessNode floatingNode = accessNode.asFloatingNode();
                    assert (floatingNode.getLastLocationAccess() == lastLocationAccess);
                    graph.replaceFixedWithFloating(accessNode, floatingNode);
                }
            }
        }

        @Override
        protected MemoryMapImpl merge(AbstractMergeNode merge, List<MemoryMapImpl> states) {
            return FloatingReadPhase.mergeMemoryMaps(merge, states);
        }

        @Override
        protected MemoryMapImpl afterSplit(AbstractBeginNode node, MemoryMapImpl oldState) {
            return new MemoryMapImpl(oldState);
        }

        @Override
        protected EconomicMap<LoopExitNode, MemoryMapImpl> processLoop(LoopBeginNode loop, MemoryMapImpl initialState) {
            EconomicSet modifiedLocations = (EconomicSet)this.modifiedInLoops.get((Object)loop);
            EconomicMap phis = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            if (modifiedLocations.contains((Object)LocationIdentity.any())) {
                modifiedLocations = EconomicSet.create((Equivalence)Equivalence.DEFAULT, (UnmodifiableEconomicSet)modifiedLocations);
                modifiedLocations.addAll(initialState.getMap().getKeys());
            }
            for (LocationIdentity location : modifiedLocations) {
                FloatingReadClosure.createMemoryPhi(loop, initialState, (EconomicMap<LocationIdentity, MemoryPhiNode>)phis, location);
            }
            initialState.getMap().putAll((UnmodifiableEconomicMap)phis);
            ReentrantNodeIterator.LoopInfo<MemoryMapImpl> loopInfo = ReentrantNodeIterator.processLoop(this, loop, initialState);
            MapCursor endStateCursor = loopInfo.endStates.getEntries();
            while (endStateCursor.advance()) {
                int endIndex = loop.phiPredecessorIndex((AbstractEndNode)endStateCursor.getKey());
                MapCursor phiCursor = phis.getEntries();
                while (phiCursor.advance()) {
                    LocationIdentity key = (LocationIdentity)phiCursor.getKey();
                    PhiNode phi = (PhiNode)phiCursor.getValue();
                    phi.initializeValueAt(endIndex, ValueNodeUtil.asNode(((MemoryMapImpl)endStateCursor.getValue()).getLastLocationAccess(key)));
                }
            }
            return loopInfo.exitStates;
        }

        private static void createMemoryPhi(LoopBeginNode loop, MemoryMapImpl initialState, EconomicMap<LocationIdentity, MemoryPhiNode> phis, LocationIdentity location) {
            MemoryPhiNode phi = loop.graph().addWithoutUnique(new MemoryPhiNode(loop, location));
            phi.addInput(ValueNodeUtil.asNode(initialState.getLastLocationAccess(location)));
            phis.put((Object)location, (Object)phi);
        }
    }

    public static class MemoryMapImpl
    implements MemoryMap {
        private final EconomicMap<LocationIdentity, MemoryKill> lastMemorySnapshot;

        public MemoryMapImpl(MemoryMapImpl memoryMap) {
            this.lastMemorySnapshot = EconomicMap.create((Equivalence)Equivalence.DEFAULT, memoryMap.lastMemorySnapshot);
        }

        public MemoryMapImpl(StartNode start) {
            this();
            this.lastMemorySnapshot.put((Object)LocationIdentity.any(), (Object)start);
        }

        public MemoryMapImpl() {
            this.lastMemorySnapshot = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity locationIdentity) {
            if (locationIdentity.isImmutable()) {
                return null;
            }
            MemoryKill lastLocationAccess = (MemoryKill)this.lastMemorySnapshot.get((Object)locationIdentity);
            if (lastLocationAccess == null) {
                lastLocationAccess = (MemoryKill)this.lastMemorySnapshot.get((Object)LocationIdentity.any());
                assert (lastLocationAccess != null);
            }
            return lastLocationAccess;
        }

        @Override
        public Iterable<LocationIdentity> getLocations() {
            return this.lastMemorySnapshot.getKeys();
        }

        public EconomicMap<LocationIdentity, MemoryKill> getMap() {
            return this.lastMemorySnapshot;
        }
    }
}

