/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.ScheduledNodeIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class GuardLoweringPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            for (Block block : schedule.getCFG().getBlocks()) {
                GuardLoweringPhase.processBlock(block, schedule);
            }
            graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
        }
        assert (GuardLoweringPhase.assertNoGuardsLeft(graph));
    }

    private static boolean assertNoGuardsLeft(StructuredGraph graph) {
        assert (graph.getNodes(GuardNode.TYPE).isEmpty());
        return true;
    }

    private static void processBlock(Block block, StructuredGraph.ScheduleResult schedule) {
        DebugContext debug = block.getBeginNode().getDebug();
        new LowerGuards(debug.isDumpEnabledForMethod() || debug.isLogEnabledForMethod()).processNodes(block, schedule);
    }

    private static class LowerGuards
    extends ScheduledNodeIterator {
        private boolean useGuardIdAsDebugId;

        LowerGuards(boolean useGuardIdAsDebugId) {
            this.useGuardIdAsDebugId = useGuardIdAsDebugId;
        }

        @Override
        protected void processNode(Node node) {
            if (node instanceof GuardNode) {
                GuardNode guard = (GuardNode)node;
                FixedWithNextNode lowered = guard.lowerGuard();
                if (lowered != null) {
                    this.replaceCurrent(lowered);
                } else {
                    this.lowerToIf(guard);
                }
            }
        }

        private void lowerToIf(GuardNode guard) {
            try (DebugCloseable position = guard.withNodeSourcePosition();){
                AbstractBeginNode falseSuccessor;
                AbstractBeginNode trueSuccessor;
                StructuredGraph graph = guard.graph();
                AbstractBeginNode fastPath = graph.add(new BeginNode());
                fastPath.setNodeSourcePosition(guard.getNoDeoptSuccessorPosition());
                int debugId = this.useGuardIdAsDebugId ? guard.getId() : 0;
                DeoptimizeNode deopt = graph.add(new DeoptimizeNode(guard.getAction(), guard.getReason(), debugId, guard.getSpeculation(), null));
                AbstractBeginNode deoptBranch = BeginNode.begin(deopt);
                if (guard.isNegated()) {
                    trueSuccessor = deoptBranch;
                    falseSuccessor = fastPath;
                } else {
                    trueSuccessor = fastPath;
                    falseSuccessor = deoptBranch;
                }
                IfNode ifNode = graph.add(new IfNode(guard.getCondition(), trueSuccessor, falseSuccessor, trueSuccessor == fastPath ? BranchProbabilityNode.ALWAYS_TAKEN_PROFILE : BranchProbabilityNode.NEVER_TAKEN_PROFILE));
                guard.replaceAndDelete(fastPath);
                this.insert(ifNode, fastPath);
            }
        }
    }
}

