/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.IncrementalCanonicalizerPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.word.LocationIdentity;

public class LoweringPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;
    private final LoweringTool.LoweringStage loweringStage;
    private final boolean lowerOptimizableMacroNodes;

    @Override
    public boolean checkContract() {
        return false;
    }

    public LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.LoweringStage loweringStage, boolean lowerOptimizableMacroNodes) {
        this.canonicalizer = canonicalizer;
        this.loweringStage = loweringStage;
        this.lowerOptimizableMacroNodes = lowerOptimizableMacroNodes;
    }

    public LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.LoweringStage loweringStage) {
        this(canonicalizer, loweringStage, false);
    }

    @Override
    protected boolean shouldDumpBeforeAtBasicLevel() {
        return this.loweringStage == LoweringTool.StandardLoweringStage.HIGH_TIER;
    }

    private boolean checkPostLowering(StructuredGraph graph, CoreProviders context) {
        Graph.Mark expectedMark = graph.getMark();
        this.lower(graph, context, LoweringMode.VERIFY_LOWERING);
        Graph.Mark mark = graph.getMark();
        assert (mark.equals(expectedMark)) : graph + ": a second round in the current lowering phase introduced these new nodes: " + graph.getNewNodes(expectedMark).snapshot();
        return true;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        this.lower(graph, context, LoweringMode.LOWERING);
        assert (this.checkPostLowering(graph, context));
        if (this.loweringStage instanceof LoweringTool.StandardLoweringStage) {
            switch ((LoweringTool.StandardLoweringStage)this.loweringStage) {
                case HIGH_TIER: {
                    graph.setAfterStage(StructuredGraph.StageFlag.HIGH_TIER_LOWERING);
                    break;
                }
                case MID_TIER: {
                    graph.setAfterStage(StructuredGraph.StageFlag.MID_TIER_LOWERING);
                    break;
                }
                case LOW_TIER: {
                    graph.setAfterStage(StructuredGraph.StageFlag.LOW_TIER_LOWERING);
                    break;
                }
                default: {
                    GraalError.shouldNotReachHere("unexpected lowering stage");
                }
            }
        }
    }

    private void lower(StructuredGraph graph, CoreProviders context, LoweringMode mode) {
        IncrementalCanonicalizerPhase<Object> incrementalCanonicalizer = new IncrementalCanonicalizerPhase<Object>(this.canonicalizer);
        incrementalCanonicalizer.appendPhase(new Round(context, mode, graph.getOptions()));
        incrementalCanonicalizer.apply(graph, context);
        assert (graph.verify());
    }

    private static boolean checkPostNodeLowering(Node node, LoweringToolImpl loweringTool, Graph.Mark preLoweringMark, Collection<Node> unscheduledUsages) {
        StructuredGraph graph = (StructuredGraph)node.graph();
        Graph.Mark postLoweringMark = graph.getMark();
        NodeIterable<Node> newNodesAfterLowering = graph.getNewNodes(preLoweringMark);
        if (node instanceof FloatingNode && !unscheduledUsages.isEmpty()) {
            for (Node n : newNodesAfterLowering) {
                assert (!(n instanceof FixedNode)) : node.graph() + ": cannot lower floatable node " + node + " as it introduces fixed node(s) but has the following unscheduled usages: " + unscheduledUsages;
            }
        }
        for (Node n : newNodesAfterLowering) {
            if (n instanceof Lowerable) {
                ((Lowerable)((Object)n)).lower(loweringTool);
                Graph.Mark mark = graph.getMark();
                assert (postLoweringMark.equals(mark)) : graph + ": lowering of " + node + " produced lowerable " + n + " that should have been recursively lowered as it introduces these new nodes: " + graph.getNewNodes(postLoweringMark).snapshot();
            }
            if (!graph.isAfterStage(StructuredGraph.StageFlag.FLOATING_READS) || !(n instanceof MemoryKill) || node instanceof MemoryKill || node instanceof ControlSinkNode) continue;
            boolean isAny = false;
            if (n instanceof SingleMemoryKill) {
                isAny = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity().isAny();
            } else if (n instanceof MultiMemoryKill) {
                for (LocationIdentity ident : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                    if (!ident.isAny()) continue;
                    isAny = true;
                }
            } else {
                throw GraalError.shouldNotReachHere("Unknown type of memory kill " + n);
            }
            if (isAny && n instanceof FixedWithNextNode) {
                for (FixedWithNextNode cur = (FixedWithNextNode)n; cur != null && graph.isNew(preLoweringMark, cur); cur = (FixedWithNextNode)cur.next()) {
                    if (cur.next() instanceof ControlSinkNode) {
                        isAny = false;
                        break;
                    }
                    if (!(cur.next() instanceof FixedWithNextNode)) break;
                }
            }
            assert (!isAny) : node + " " + n;
        }
        return true;
    }

    public static void processBlock(Frame<?> rootFrame) {
        ProcessBlockState state = ProcessBlockState.ST_PROCESS;
        Frame<Object> f = rootFrame;
        while (f != null) {
            ProcessBlockState nextState;
            if (state == ProcessBlockState.ST_PROCESS || state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED) {
                f.preprocess();
                nextState = state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED ? ProcessBlockState.ST_ENTER : ProcessBlockState.ST_ENTER_ALWAYS_REACHED;
            } else if (state == ProcessBlockState.ST_ENTER_ALWAYS_REACHED) {
                if (f.alwaysReachedBlock != null && f.alwaysReachedBlock.getDominator() == f.block) {
                    f = f.enterAlwaysReached(f.alwaysReachedBlock);
                    nextState = ProcessBlockState.ST_PROCESS;
                } else {
                    nextState = ProcessBlockState.ST_ENTER;
                }
            } else if (state == ProcessBlockState.ST_ENTER) {
                if (f.dominated != null) {
                    Block n = f.dominated;
                    f.dominated = (Block)n.getDominatedSibling();
                    if (n == f.alwaysReachedBlock) {
                        if (f.dominated != null) {
                            n = f.dominated;
                            f.dominated = (Block)n.getDominatedSibling();
                        } else {
                            n = null;
                        }
                    }
                    if (n == null) {
                        nextState = ProcessBlockState.ST_LEAVE;
                    } else {
                        f = f.enter(n);
                        assert (f.block.getDominator() == ((Frame)f.parent).block);
                        nextState = ProcessBlockState.ST_PROCESS;
                    }
                } else {
                    nextState = ProcessBlockState.ST_LEAVE;
                }
            } else if (state == ProcessBlockState.ST_LEAVE) {
                f.postprocess();
                f = f.parent;
                nextState = ProcessBlockState.ST_ENTER;
            } else {
                throw GraalError.shouldNotReachHere();
            }
            state = nextState;
        }
    }

    public static abstract class Frame<T extends Frame<?>> {
        protected final Block block;
        final T parent;
        Block dominated;
        final Block alwaysReachedBlock;

        public Frame(Block block, T parent) {
            this.block = block;
            this.alwaysReachedBlock = block.getPostdominator();
            this.dominated = (Block)block.getFirstDominated();
            this.parent = parent;
        }

        public Frame<?> enterAlwaysReached(Block b) {
            return this.enter(b);
        }

        public abstract Frame<?> enter(Block var1);

        public abstract void preprocess();

        public abstract void postprocess();
    }

    static enum ProcessBlockState {
        ST_ENTER,
        ST_PROCESS,
        ST_ENTER_ALWAYS_REACHED,
        ST_LEAVE,
        ST_PROCESS_ALWAYS_REACHED;

    }

    private final class Round
    extends Phase {
        private final CoreProviders context;
        private final LoweringMode mode;
        private StructuredGraph.ScheduleResult schedule;
        private final SchedulePhase schedulePhase;

        private Round(CoreProviders context, LoweringMode mode, OptionValues options) {
            this.context = context;
            this.mode = mode;
            boolean immutableSchedule = mode == LoweringMode.VERIFY_LOWERING;
            this.schedulePhase = new SchedulePhase(immutableSchedule, options);
        }

        @Override
        protected CharSequence getName() {
            switch (this.mode) {
                case LOWERING: {
                    return "LoweringRound";
                }
                case VERIFY_LOWERING: {
                    return "VerifyLoweringRound";
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public boolean checkContract() {
            return false;
        }

        @Override
        public void run(StructuredGraph graph) {
            this.schedulePhase.apply(graph, this.context, false);
            this.schedule = graph.getLastSchedule();
            this.schedule.getCFG().computePostdominators();
            Block startBlock = this.schedule.getCFG().getStartBlock();
            ProcessFrame rootFrame = new ProcessFrame(startBlock, graph.createNodeBitMap(), startBlock.getBeginNode(), null);
            LoweringPhase.processBlock(rootFrame);
        }

        private AnchoringNode process(Block b, NodeBitMap activeGuards, AnchoringNode startAnchor) {
            LoweringToolImpl loweringTool = new LoweringToolImpl(this.context, startAnchor, activeGuards, b.getBeginNode(), this.schedule.getNodeToBlockMap());
            List<Node> nodes = this.schedule.nodesFor(b);
            for (Node node : nodes) {
                if (node.isDeleted()) continue;
                FixedNode nextNode = null;
                nextNode = node instanceof FixedWithNextNode ? ((FixedWithNextNode)node).next() : loweringTool.lastFixedNode().next();
                if (node instanceof Lowerable) {
                    Collection<Node> unscheduledUsages = null;
                    assert ((unscheduledUsages = this.getUnscheduledUsages(node)) != null);
                    Graph.Mark preLoweringMark = node.graph().getMark();
                    try (DebugCloseable s = node.graph().withNodeSourcePosition(node);){
                        ((Lowerable)((Object)node)).lower(loweringTool);
                    }
                    if (loweringTool.guardAnchor.asNode().isDeleted()) {
                        assert (nextNode.isAlive());
                        loweringTool.guardAnchor = AbstractBeginNode.prevBegin(nextNode);
                    }
                    assert (LoweringPhase.checkPostNodeLowering(node, loweringTool, preLoweringMark, unscheduledUsages));
                }
                if (!nextNode.isAlive()) break;
                Node nextLastFixed = nextNode.predecessor();
                if (!(nextLastFixed instanceof FixedWithNextNode)) {
                    AbstractBeginNode begin = node.graph().add(new BeginNode());
                    nextLastFixed.replaceFirstSuccessor(nextNode, begin);
                    begin.setNext(nextNode);
                    nextLastFixed = begin;
                }
                loweringTool.setLastFixedNode((FixedWithNextNode)nextLastFixed);
            }
            return loweringTool.getCurrentGuardAnchor();
        }

        private Collection<Node> getUnscheduledUsages(Node node) {
            ArrayList<Node> unscheduledUsages = new ArrayList<Node>();
            if (node instanceof FloatingNode) {
                for (Node usage : node.usages()) {
                    if (!(usage instanceof ValueNode) || usage instanceof PhiNode || usage instanceof ProxyNode || !this.schedule.getCFG().getNodeToBlock().isNew(usage) && this.schedule.getCFG().blockFor(usage) != null) continue;
                    unscheduledUsages.add(usage);
                }
            }
            return unscheduledUsages;
        }

        private class ProcessFrame
        extends Frame<ProcessFrame> {
            private final NodeBitMap activeGuards;
            private AnchoringNode anchor;

            ProcessFrame(Block block, NodeBitMap activeGuards, AnchoringNode anchor, ProcessFrame parent) {
                super(block, parent);
                this.activeGuards = activeGuards;
                this.anchor = anchor;
            }

            @Override
            public void preprocess() {
                this.anchor = Round.this.process(this.block, this.activeGuards, this.anchor);
            }

            public ProcessFrame enter(Block b) {
                return new ProcessFrame(b, this.activeGuards, b.getBeginNode(), this);
            }

            @Override
            public Frame<?> enterAlwaysReached(Block b) {
                AnchoringNode newAnchor = this.anchor;
                if (this.parent != null && b.getLoop() != ((ProcessFrame)this.parent).block.getLoop() && !b.isLoopHeader()) {
                    newAnchor = b.getBeginNode();
                }
                return new ProcessFrame(b, this.activeGuards, newAnchor, this);
            }

            @Override
            public void postprocess() {
                if (this.anchor == this.block.getBeginNode() && GraalOptions.OptEliminateGuards.getValue(this.activeGuards.graph().getOptions()).booleanValue()) {
                    for (GuardNode guard : this.anchor.asNode().usages().filter(GuardNode.class)) {
                        if (!this.activeGuards.isMarkedAndGrow(guard)) continue;
                        this.activeGuards.clear(guard);
                    }
                }
            }
        }
    }

    private static enum LoweringMode {
        LOWERING,
        VERIFY_LOWERING;

    }

    final class LoweringToolImpl
    extends CoreProvidersDelegate
    implements LoweringTool {
        private final NodeBitMap activeGuards;
        private AnchoringNode guardAnchor;
        private FixedWithNextNode lastFixedNode;
        private NodeMap<Block> nodeMap;

        LoweringToolImpl(CoreProviders context, AnchoringNode guardAnchor, NodeBitMap activeGuards, FixedWithNextNode lastFixedNode, NodeMap<Block> nodeMap) {
            super(context);
            this.guardAnchor = guardAnchor;
            this.activeGuards = activeGuards;
            this.lastFixedNode = lastFixedNode;
            this.nodeMap = nodeMap;
        }

        @Override
        public LoweringTool.LoweringStage getLoweringStage() {
            return LoweringPhase.this.loweringStage;
        }

        @Override
        public AnchoringNode getCurrentGuardAnchor() {
            return this.guardAnchor;
        }

        @Override
        public boolean lowerOptimizableMacroNodes() {
            return LoweringPhase.this.lowerOptimizableMacroNodes;
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action) {
            return this.createGuard(before, condition, deoptReason, action, SpeculationLog.NO_SPECULATION, false, null);
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSucccessorPosition) {
            StructuredGraph graph = before.graph();
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                for (Node usage : condition.usages()) {
                    if (this.activeGuards.isNew(usage) || !this.activeGuards.isMarked(usage) || ((GuardNode)usage).isNegated() != negated || !before.graph().isAfterStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL) && !this.nodeMap.get(((GuardNode)usage).getAnchor().asNode()).isInSameOrOuterLoopOf(this.nodeMap.get(before))) continue;
                    return (GuardNode)usage;
                }
            }
            if (!condition.graph().getGuardsStage().allowsFloatingGuards()) {
                FixedGuardNode fixedGuard = graph.add(new FixedGuardNode(condition, deoptReason, action, speculation, negated, noDeoptSucccessorPosition));
                graph.addBeforeFixed(before, fixedGuard);
                DummyGuardHandle handle = graph.add(new DummyGuardHandle(fixedGuard));
                fixedGuard.lower(this);
                GuardingNode result = handle.getGuard();
                handle.safeDelete();
                return result;
            }
            GuardNode newGuard = graph.unique(new GuardNode(condition, this.guardAnchor, deoptReason, action, negated, speculation, noDeoptSucccessorPosition));
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                this.activeGuards.markAndGrow(newGuard);
            }
            return newGuard;
        }

        @Override
        public FixedWithNextNode lastFixedNode() {
            GraalError.guarantee(this.lastFixedNode.isAlive(), "The last fixed node %s was deleted by a previous lowering", (Object)this.lastFixedNode);
            return this.lastFixedNode;
        }

        private void setLastFixedNode(FixedWithNextNode n) {
            GraalError.guarantee(n.isAlive(), "Cannot add last fixed node %s because it is not alive", (Object)n);
            this.lastFixedNode = n;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class DummyGuardHandle
    extends ValueNode
    implements GuardedNode {
        public static final NodeClass<DummyGuardHandle> TYPE = NodeClass.create(DummyGuardHandle.class);
        @Node.Input(value=InputType.Guard)
        GuardingNode guard;

        protected DummyGuardHandle(GuardingNode guard) {
            super(TYPE, StampFactory.forVoid());
            this.guard = guard;
        }

        @Override
        public GuardingNode getGuard() {
            return this.guard;
        }

        @Override
        public void setGuard(GuardingNode guard) {
            this.updateUsagesInterface(this.guard, guard);
            this.guard = guard;
        }
    }
}

