/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining;

import java.util.LinkedList;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.phases.common.AbstractInliningPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import org.graalvm.compiler.phases.common.inlining.walker.InliningData;
import org.graalvm.compiler.phases.tiers.HighTierContext;

public class InliningPhase
extends AbstractInliningPhase {
    private final InliningPolicy inliningPolicy;
    private final CanonicalizerPhase canonicalizer;
    private LinkedList<Invoke> rootInvokes = null;
    private int maxMethodPerInlining = Integer.MAX_VALUE;

    public InliningPhase(InliningPolicy policy, CanonicalizerPhase canonicalizer) {
        this.inliningPolicy = policy;
        this.canonicalizer = canonicalizer;
    }

    public CanonicalizerPhase getCanonicalizer() {
        return this.canonicalizer;
    }

    @Override
    public float codeSizeIncrease() {
        return 10000.0f;
    }

    public void setMaxMethodsPerInlining(int max) {
        this.maxMethodPerInlining = max;
    }

    public void setRootInvokes(LinkedList<Invoke> rootInvokes) {
        this.rootInvokes = rootInvokes;
    }

    @Override
    protected void run(StructuredGraph graph, HighTierContext context) {
        InliningData data = new InliningData(graph, context, this.maxMethodPerInlining, this.canonicalizer, this.inliningPolicy, this.rootInvokes);
        int count = 0;
        assert (data.repOK());
        int limit = Options.MethodInlineBailoutLimit.getValue(graph.getOptions());
        while (data.hasUnprocessedGraphs()) {
            boolean wasInlined = data.moveForward();
            assert (data.repOK());
            if (wasInlined || limit <= 0 || ++count != limit) continue;
            break;
        }
        assert (data.inliningDepth() == 0 || count == limit);
        assert (data.graphCount() == 0 || count == limit);
    }

    public static class Options {
        @Option(help={"Unconditionally inline intrinsics"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> AlwaysInlineIntrinsics = new OptionKey<Boolean>(false);
        @Option(help={"Per-compilation method inlining exploration limit before giving up (use 0 to disable)"}, type=OptionType.Debug)
        public static final OptionKey<Integer> MethodInlineBailoutLimit = new OptionKey<Integer>(5000);
    }
}

