/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.contract;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.contract.PhaseSizeContract;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class NodeCostUtil {
    private static final CounterKey sizeComputationCount = DebugContext.counter("GraphCostComputationCount_Size");
    private static final CounterKey sizeVerificationCount = DebugContext.counter("GraphCostVerificationCount_Size");
    private static final double DELTA = 0.001;

    public static int computeNodesSize(Iterable<Node> nodes) {
        int size = 0;
        for (Node n : nodes) {
            size += n.estimatedNodeSize().value;
        }
        assert (size >= 0);
        return size;
    }

    public static int computeGraphSize(StructuredGraph graph) {
        sizeComputationCount.increment(graph.getDebug());
        int size = 0;
        for (Node n : graph.getNodes()) {
            size += n.estimatedNodeSize().value;
        }
        assert (size >= 0);
        return size;
    }

    public static double computeGraphCycles(StructuredGraph graph, boolean fullSchedule) {
        Function<Block, Iterable> blockToNodes;
        ControlFlowGraph cfg;
        if (fullSchedule) {
            SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true);
            cfg = graph.getLastSchedule().getCFG();
            blockToNodes = b -> graph.getLastSchedule().getBlockToNodesMap().get((AbstractBlockBase<?>)b);
        } else {
            cfg = ControlFlowGraph.compute(graph, true, true, false, false);
            BlockMap nodes = new BlockMap(cfg);
            for (Block b2 : cfg.getBlocks()) {
                ArrayList<FixedNode> curNodes = new ArrayList<FixedNode>();
                for (FixedNode node : b2.getNodes()) {
                    curNodes.add(node);
                }
                nodes.put(b2, curNodes);
            }
            blockToNodes = b -> (List)nodes.get((AbstractBlockBase<?>)b);
        }
        double weightedCycles = 0.0;
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("NodeCostSummary");){
            for (Block block : cfg.getBlocks()) {
                for (Node n : blockToNodes.apply(block)) {
                    double probWeighted = (double)n.estimatedNodeCycles().value * block.getRelativeFrequency();
                    assert (Double.isFinite(probWeighted));
                    weightedCycles += probWeighted;
                    if (!debug.isLogEnabled()) continue;
                    debug.log("Node %s contributes cycles:%f size:%d to graph %s [block freq:%f]", n, (Object)((double)n.estimatedNodeCycles().value * block.getRelativeFrequency()), (Object)n.estimatedNodeSize().value, (Object)graph, (Object)block.getRelativeFrequency());
                }
            }
        }
        assert (weightedCycles >= 0.0);
        assert (Double.isFinite(weightedCycles));
        return weightedCycles;
    }

    private static int deltaCompare(double a, double b, double delta) {
        if (Math.abs(a - b) <= delta) {
            return 0;
        }
        return Double.compare(a, b);
    }

    public static void phaseFulfillsSizeContract(StructuredGraph graph, int codeSizeBefore, int codeSizeAfter, PhaseSizeContract contract) {
        if (codeSizeBefore > BasePhase.PhaseOptions.MinimalGraphNodeSizeCheckSize.getValue(graph.getOptions())) {
            sizeVerificationCount.increment(graph.getDebug());
            double codeSizeIncrease = contract.codeSizeIncrease();
            double graphSizeDelta = (double)codeSizeBefore * 0.001;
            if (NodeCostUtil.deltaCompare(codeSizeAfter, (double)codeSizeBefore * codeSizeIncrease, graphSizeDelta) > 0) {
                ResolvedJavaMethod method = graph.method();
                double increase = (double)codeSizeBefore == 0.0 ? (double)codeSizeAfter : (double)codeSizeAfter / (double)codeSizeBefore;
                throw new GraalGraphError("Phase %s expects to increase code size by at most a factor of %.2f but an increase of %.2f was seen (code size before: %d, after: %d)%s", contract.contractorName(), codeSizeIncrease, increase, codeSizeBefore, codeSizeAfter, method != null ? " when compiling method " + method.format("%H.%n(%p)") + "." : ".");
            }
        }
    }
}

