/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;

public class InferStamps {
    public static void inferStamps(StructuredGraph graph) {
        boolean stampChanged;
        for (Node n : graph.getNodes()) {
            ValueNode node;
            if (!(n instanceof ValuePhiNode) || !((node = (ValueNode)n).stamp(NodeView.DEFAULT) instanceof ObjectStamp)) continue;
            assert (node.stamp(NodeView.DEFAULT).hasValues()) : "We assume all Phi and Proxy stamps are legal before the analysis";
            node.setStamp(node.stamp(NodeView.DEFAULT).empty());
        }
        int z = 0;
        do {
            stampChanged = false;
            for (Node n : graph.getNodes()) {
                ValueNode node;
                if (!(n instanceof ValueNode) || !((node = (ValueNode)n).stamp(NodeView.DEFAULT) instanceof ObjectStamp)) continue;
                stampChanged |= node.inferStamp();
            }
        } while (stampChanged && ++z < 10000);
        assert (InferStamps.checkNoEmptyStamp(graph));
    }

    private static boolean checkNoEmptyStamp(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            if (!(n instanceof ValuePhiNode)) continue;
            ValueNode node = (ValueNode)n;
            assert (node.stamp(NodeView.DEFAULT).hasValues()) : "Stamp is empty after analysis. This is not necessarily an error, but a condition that we want to investigate (and then maybe relax or remove the assertion).";
        }
        return true;
    }
}

