/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.schedule;

import java.util.ArrayDeque;
import java.util.List;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MemoryProxyNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.word.LocationIdentity;

public final class ScheduleVerification
extends ReentrantBlockIterator.BlockIteratorClosure<EconomicSet<FloatingReadNode>> {
    private final BlockMap<List<Node>> blockToNodesMap;
    private final NodeMap<Block> nodeMap;
    private final StructuredGraph graph;

    public static boolean check(Block startBlock, BlockMap<List<Node>> blockToNodesMap, NodeMap<Block> nodeMap) {
        ReentrantBlockIterator.apply(new ScheduleVerification(blockToNodesMap, nodeMap, startBlock.getBeginNode().graph()), startBlock);
        return true;
    }

    private ScheduleVerification(BlockMap<List<Node>> blockToNodesMap, NodeMap<Block> nodeMap, StructuredGraph graph) {
        this.blockToNodesMap = blockToNodesMap;
        this.nodeMap = nodeMap;
        this.graph = graph;
    }

    @Override
    protected EconomicSet<FloatingReadNode> getInitialState() {
        return EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    }

    @Override
    protected EconomicSet<FloatingReadNode> processBlock(Block block, EconomicSet<FloatingReadNode> currentState) {
        AbstractBeginNode beginNode = block.getBeginNode();
        if (beginNode instanceof AbstractMergeNode) {
            AbstractMergeNode abstractMergeNode = (AbstractMergeNode)beginNode;
            for (PhiNode phi : abstractMergeNode.phis()) {
                if (!(phi instanceof MemoryPhiNode)) continue;
                MemoryPhiNode memoryPhiNode = (MemoryPhiNode)phi;
                ScheduleVerification.addFloatingReadUsages(currentState, memoryPhiNode);
            }
        }
        if (beginNode instanceof LoopExitNode) {
            LoopExitNode loopExitNode = (LoopExitNode)beginNode;
            for (ProxyNode proxy : loopExitNode.proxies()) {
                if (!(proxy instanceof MemoryProxyNode)) continue;
                LocationIdentity[] memoryProxyNode = (LocationIdentity[])proxy;
                ScheduleVerification.addFloatingReadUsages(currentState, (Node)memoryProxyNode);
            }
        }
        for (Node n : this.blockToNodesMap.get(block)) {
            FloatingReadNode floatingReadNode;
            if (n instanceof MemoryKill) {
                if (n instanceof SingleMemoryKill) {
                    SingleMemoryKill single = (SingleMemoryKill)((Object)n);
                    this.processLocation(n, single.getKilledLocationIdentity(), currentState);
                } else if (n instanceof MultiMemoryKill) {
                    MultiMemoryKill multi = (MultiMemoryKill)((Object)n);
                    for (LocationIdentity location : multi.getKilledLocationIdentities()) {
                        this.processLocation(n, location, currentState);
                    }
                }
                ScheduleVerification.addFloatingReadUsages(currentState, n);
            } else if (n instanceof MemoryAccess) {
                ScheduleVerification.addFloatingReadUsages(currentState, n);
            } else if (n instanceof FloatingReadNode && (floatingReadNode = (FloatingReadNode)n).getLastLocationAccess() != null && floatingReadNode.getLocationIdentity().isMutable()) {
                if (currentState.contains((Object)floatingReadNode)) {
                    currentState.remove((Object)floatingReadNode);
                } else {
                    throw new RuntimeException("Floating read node " + n + " was not found in the state, i.e., it was killed by a memory check point before its place in the schedule. Block=" + block + ", block begin: " + block.getBeginNode() + " block loop: " + block.getLoop() + ", " + this.blockToNodesMap.get(block).get(0));
                }
            }
            assert (this.nodeMap.get(n) == block);
            if (!this.graph.isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL) || block.getLoop() == null || n instanceof VirtualState) continue;
            for (Node usage : n.usages()) {
                Block usageBlock;
                LoopExitNode loopExitNode;
                Node usageNode = usage;
                if (usageNode instanceof PhiNode) {
                    PhiNode phiNode = (PhiNode)usage;
                    usageNode = phiNode.merge();
                }
                if (usageNode instanceof LoopExitNode && ((loopExitNode = (LoopExitNode)usageNode).loopBegin() == n || loopExitNode.stateAfter() == n) || (usageBlock = this.nodeMap.get(usageNode)) == null && (usage instanceof FloatingNode || usage instanceof VirtualState || usage instanceof CallTargetNode) && !(usage instanceof GuardNode) && ScheduleVerification.nonFixedNodeTreeWithoutUsages(usage)) continue;
                assert (usageBlock != null || usage instanceof ProxyNode) : "Usage " + usageNode + " of node " + n + " has no block";
                Loop<Block> usageLoop = null;
                if (usageNode instanceof ProxyNode) {
                    ProxyNode proxyNode = (ProxyNode)usageNode;
                    usageLoop = this.nodeMap.get(proxyNode.proxyPoint().loopBegin()).getLoop();
                } else if (usageBlock.getBeginNode() instanceof LoopExitNode) {
                    LoopExitNode loopExitNode2 = (LoopExitNode)usageBlock.getBeginNode();
                    usageLoop = this.nodeMap.get(loopExitNode2.loopBegin()).getLoop();
                } else {
                    usageLoop = usageBlock.getLoop();
                }
                assert (usageLoop != null) : n + ", " + this.nodeMap.get(n) + " / " + usageNode + ", " + this.nodeMap.get(usageNode);
                while (usageLoop != block.getLoop() && usageLoop != null) {
                    usageLoop = usageLoop.getParent();
                }
                assert (usageLoop != null) : n + ", " + usageNode + ", " + usageBlock + ", " + usageBlock.getLoop() + ", " + block + ", " + block.getLoop();
            }
        }
        return currentState;
    }

    private static boolean nonFixedNodeTreeWithoutUsages(Node n) {
        if (!(n instanceof FloatingNode || n instanceof VirtualState || n instanceof CallTargetNode)) {
            return false;
        }
        NodeBitMap visited = n.graph().createNodeBitMap();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.push(n);
        while (!stack.isEmpty()) {
            Node cur = (Node)stack.pop();
            if (visited.isMarked(cur)) continue;
            if (!(cur instanceof FloatingNode || cur instanceof VirtualState || cur instanceof CallTargetNode)) {
                return false;
            }
            visited.mark(cur);
            for (Node usage : cur.usages()) {
                stack.push(usage);
            }
        }
        return true;
    }

    private static void addFloatingReadUsages(EconomicSet<FloatingReadNode> currentState, Node n) {
        for (FloatingReadNode read : n.usages().filter(FloatingReadNode.class)) {
            if (read.getLastLocationAccess() != n || !read.getLocationIdentity().isMutable()) continue;
            currentState.add((Object)read);
        }
    }

    private void processLocation(Node n, LocationIdentity location, EconomicSet<FloatingReadNode> currentState) {
        assert (n != null);
        if (location.isImmutable()) {
            return;
        }
        for (FloatingReadNode r : this.cloneState(currentState)) {
            if (!r.getLocationIdentity().overlaps(location)) continue;
            r.getDebug().log(3, "%s removing %s from state", (Object)n, (Object)r);
            currentState.remove((Object)r);
        }
    }

    @Override
    protected EconomicSet<FloatingReadNode> merge(Block merge, List<EconomicSet<FloatingReadNode>> states) {
        EconomicSet<FloatingReadNode> result = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            result.retainAll(states.get(i));
        }
        return result;
    }

    @Override
    protected EconomicSet<FloatingReadNode> cloneState(EconomicSet<FloatingReadNode> oldState) {
        EconomicSet result = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        if (oldState != null) {
            result.addAll(oldState);
        }
        return result;
    }

    @Override
    protected List<EconomicSet<FloatingReadNode>> processLoop(Loop<Block> loop, EconomicSet<FloatingReadNode> initialState) {
        HIRLoop l = (HIRLoop)loop;
        for (MemoryPhiNode memoryPhi : ((LoopBeginNode)((Block)l.getHeader()).getBeginNode()).memoryPhis()) {
            for (FloatingReadNode r : this.cloneState(initialState)) {
                if (!r.getLocationIdentity().overlaps(memoryPhi.getLocationIdentity())) continue;
                initialState.remove((Object)r);
            }
        }
        return ReentrantBlockIterator.processLoop(this, loop, initialState).exitStates;
    }
}

