/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.tiers;

import org.graalvm.compiler.lir.alloc.RegisterAllocationPhase;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.LowTierContext;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public final class Suites {
    private final PhaseSuite<HighTierContext> highTier;
    private final PhaseSuite<MidTierContext> midTier;
    private final PhaseSuite<LowTierContext> lowTier;
    private boolean immutable;

    public PhaseSuite<HighTierContext> getHighTier() {
        return this.highTier;
    }

    public PhaseSuite<MidTierContext> getMidTier() {
        return this.midTier;
    }

    public PhaseSuite<LowTierContext> getLowTier() {
        return this.lowTier;
    }

    public Suites(PhaseSuite<HighTierContext> highTier, PhaseSuite<MidTierContext> midTier, PhaseSuite<LowTierContext> lowTier) {
        this.highTier = highTier;
        this.midTier = midTier;
        this.lowTier = lowTier;
    }

    public static Suites createSuites(CompilerConfiguration config, OptionValues options) {
        return new Suites(config.createHighTier(options), config.createMidTier(options), config.createLowTier(options));
    }

    public static LIRSuites createLIRSuites(CompilerConfiguration config, OptionValues options) {
        LIRPhaseSuite<AllocationPhase.AllocationContext> allocationStage = config.createAllocationStage(options);
        assert (Suites.verifyAllocationStage(allocationStage));
        return new LIRSuites(config.createPreAllocationOptimizationStage(options), allocationStage, config.createPostAllocationOptimizationStage(options), config.createFinalCodeAnalysisStage(options));
    }

    private static boolean verifyAllocationStage(LIRPhaseSuite<AllocationPhase.AllocationContext> allocationStage) {
        boolean allocationPhase = false;
        for (LIRPhase<AllocationPhase.AllocationContext> phase : allocationStage.getPhases()) {
            if (!(phase instanceof RegisterAllocationPhase)) continue;
            if (allocationPhase) {
                assert (false) : "More than one register allocation phase";
                return false;
            }
            allocationPhase = true;
        }
        assert (allocationPhase) : "No register allocation phase";
        return allocationPhase;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void setImmutable() {
        if (!this.immutable) {
            this.highTier.setImmutable();
            this.midTier.setImmutable();
            this.lowTier.setImmutable();
            this.immutable = true;
        }
    }

    public Suites copy() {
        return new Suites(this.highTier.copy(), this.midTier.copy(), this.lowTier.copy());
    }
}

