/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.replacements.ArrayIndexOfDispatchNode;

public class ArrayIndexOf {
    public static final ForeignCallSignature STUB_INDEX_OF_1_BYTE = new ForeignCallSignature("indexOf1Byte", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Byte.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_1_CHAR_COMPACT = new ForeignCallSignature("indexOf1CharCompact", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES = new ForeignCallSignature("indexOfTwoConsecutiveBytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS = new ForeignCallSignature("indexOfTwoConsecutiveChars", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT = new ForeignCallSignature("indexOfTwoConsecutiveCharsCompact", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_2_BYTES = new ForeignCallSignature("indexOf2Bytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_3_BYTES = new ForeignCallSignature("indexOf3Bytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_4_BYTES = new ForeignCallSignature("indexOf4Bytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_1_CHAR = new ForeignCallSignature("indexOf1Char", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_2_CHARS = new ForeignCallSignature("indexOf2Chars", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_3_CHARS = new ForeignCallSignature("indexOf3Chars", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_4_CHARS = new ForeignCallSignature("indexOf4Chars", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE, Character.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_2_CHARS_COMPACT = new ForeignCallSignature("indexOf2CharsCompact", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_3_CHARS_COMPACT = new ForeignCallSignature("indexOf3CharsCompact", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE, Character.TYPE);
    public static final ForeignCallSignature STUB_INDEX_OF_4_CHARS_COMPACT = new ForeignCallSignature("indexOf4CharsCompact", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE, Character.TYPE, Character.TYPE, Character.TYPE);

    public static int indexOf1Byte(byte[] array, int arrayLength, int fromIndex, byte b) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_1_BYTE, array, arrayLength, fromIndex, b);
    }

    public static int indexOf1CharCompact(byte[] array, int arrayLength, int fromIndex, char c) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_1_CHAR_COMPACT, array, arrayLength, fromIndex, c);
    }

    public static int indexOfTwoConsecutiveBytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2) {
        int searchValue = Byte.toUnsignedInt(b2) << 8 | Byte.toUnsignedInt(b1);
        return ArrayIndexOfDispatchNode.indexOf2ConsecutiveBytes(STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, array, arrayLength, fromIndex, searchValue);
    }

    public static int indexOfTwoConsecutiveChars(char[] array, int arrayLength, int fromIndex, char c1, char c2) {
        int searchValue = c2 << 16 | c1;
        return ArrayIndexOfDispatchNode.indexOf2ConsecutiveChars(STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, array, arrayLength, fromIndex, searchValue);
    }

    public static int indexOfTwoConsecutiveChars(byte[] array, int arrayLength, int fromIndex, char c1, char c2) {
        int searchValue = c2 << 16 | c1;
        return ArrayIndexOfDispatchNode.indexOf2ConsecutiveChars(STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT, array, arrayLength, fromIndex, searchValue);
    }

    public static int indexOf2Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_2_BYTES, array, arrayLength, fromIndex, b1, b2);
    }

    public static int indexOf3Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2, byte b3) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_3_BYTES, array, arrayLength, fromIndex, b1, b2, b3);
    }

    public static int indexOf4Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2, byte b3, byte b4) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_4_BYTES, array, arrayLength, fromIndex, b1, b2, b3, b4);
    }

    public static int indexOf1Char(char[] array, int arrayLength, int fromIndex, char c) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_1_CHAR, array, arrayLength, fromIndex, c);
    }

    public static int indexOf2Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_2_CHARS, array, arrayLength, fromIndex, c1, c2);
    }

    public static int indexOf3Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2, char c3) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_3_CHARS, array, arrayLength, fromIndex, c1, c2, c3);
    }

    public static int indexOf4Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2, char c3, char c4) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_4_CHARS, array, arrayLength, fromIndex, c1, c2, c3, c4);
    }

    public static int indexOf2CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_2_CHARS_COMPACT, array, arrayLength, fromIndex, c1, c2);
    }

    public static int indexOf3CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2, char c3) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_3_CHARS_COMPACT, array, arrayLength, fromIndex, c1, c2, c3);
    }

    public static int indexOf4CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2, char c3, char c4) {
        return ArrayIndexOfDispatchNode.indexOf(STUB_INDEX_OF_4_CHARS_COMPACT, array, arrayLength, fromIndex, c1, c2, c3, c4);
    }
}

