/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginInjectionProvider;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.word.WordTypes;

public class NodeIntrinsificationProvider
implements GeneratedPluginInjectionProvider {
    public static final TargetDescription INJECTED_TARGET = null;
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;
    private final ForeignCallsProvider foreignCalls;
    private final WordTypes wordTypes;
    private final TargetDescription target;

    public NodeIntrinsificationProvider(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, ForeignCallsProvider foreignCalls, WordTypes wordTypes, TargetDescription target) {
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
        this.foreignCalls = foreignCalls;
        this.wordTypes = wordTypes;
        this.target = target;
    }

    @Override
    public Stamp getInjectedStamp(Class<?> type, boolean nonNull) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            ResolvedJavaType returnType = this.metaAccess.lookupJavaType(type);
            if (this.wordTypes.isWord((JavaType)returnType)) {
                return this.wordTypes.getWordStamp(returnType);
            }
            return StampFactory.object(TypeReference.createWithoutAssumptions(returnType), nonNull);
        }
        return StampFactory.forKind(kind);
    }

    @Override
    public <T> T getInjectedArgument(Class<T> type) {
        T injected = this.snippetReflection.getInjectedNodeIntrinsicParameter(type);
        if (injected != null) {
            return injected;
        }
        if (type.equals(ForeignCallsProvider.class) || type.equals(ArrayCopyForeignCalls.class)) {
            return type.cast(this.foreignCalls);
        }
        if (type.equals(SnippetReflectionProvider.class)) {
            return type.cast(this.snippetReflection);
        }
        if (type.equals(WordTypes.class)) {
            return type.cast(this.wordTypes);
        }
        if (type.equals(TargetDescription.class)) {
            return type.cast(this.target);
        }
        throw new GraalError("Cannot handle injected argument of type %s.", type.getName());
    }
}

