/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.replacements.SnippetCounter;

public final class SnippetIntegerHistogram {
    public static final SnippetIntegerHistogram DISABLED_COUNTER = new SnippetIntegerHistogram(null, 1, "Disabled", "Disabled");
    private final SnippetCounter.Group group;
    private final String name;
    private final SnippetCounter counter0;
    private final SnippetCounter counter1;
    private final SnippetCounter counter2;
    private final SnippetCounter counter3;
    private final SnippetCounter counter4;
    private final SnippetCounter counter5;
    private final SnippetCounter counter6;
    private final SnippetCounter counter7;
    private final SnippetCounter counter8;
    private final SnippetCounter counter9;
    private final SnippetCounter counter10;
    private final int counter0UpperBound;
    private final int counter1UpperBound;
    private final int counter2UpperBound;
    private final int counter3UpperBound;
    private final int counter4UpperBound;
    private final int counter5UpperBound;
    private final int counter6UpperBound;
    private final int counter7UpperBound;
    private final int counter8UpperBound;
    private final int counter9UpperBound;

    public SnippetIntegerHistogram(SnippetCounter.Group group, int log2StepLength, String name, String description) {
        assert (log2StepLength > 0);
        this.group = group;
        this.name = name;
        int lowerBound = 0;
        this.counter0UpperBound = 0;
        this.counter0 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter0UpperBound);
        lowerBound = this.counter0UpperBound + 1;
        this.counter1UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter1 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter1UpperBound);
        lowerBound = this.counter1UpperBound + 1;
        this.counter2UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter2 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter2UpperBound);
        lowerBound = this.counter2UpperBound + 1;
        this.counter3UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter3 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter3UpperBound);
        lowerBound = this.counter3UpperBound + 1;
        this.counter4UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter4 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter4UpperBound);
        lowerBound = this.counter4UpperBound + 1;
        this.counter5UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter5 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter5UpperBound);
        lowerBound = this.counter5UpperBound + 1;
        this.counter6UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter6 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter6UpperBound);
        lowerBound = this.counter6UpperBound + 1;
        this.counter7UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter7 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter7UpperBound);
        lowerBound = this.counter7UpperBound + 1;
        this.counter8UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter8 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter8UpperBound);
        lowerBound = this.counter8UpperBound + 1;
        this.counter9UpperBound = Math.max(1, lowerBound - 1) << log2StepLength;
        this.counter9 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, this.counter9UpperBound);
        lowerBound = this.counter9UpperBound + 1;
        this.counter10 = SnippetIntegerHistogram.createCounter(group, name, description, lowerBound, Long.MAX_VALUE);
    }

    private static SnippetCounter createCounter(SnippetCounter.Group group, String name, String description, long lowerBound, long upperBound) {
        if (group != null) {
            SnippetCounter snippetCounter = new SnippetCounter(group, name + "[" + lowerBound + ", " + upperBound + "]", description);
            return snippetCounter;
        }
        return null;
    }

    public void inc(long value) {
        if (this.group != null) {
            if (value <= (long)this.counter0UpperBound) {
                this.counter0.inc();
            } else if (value <= (long)this.counter1UpperBound) {
                this.counter1.inc();
            } else if (value <= (long)this.counter2UpperBound) {
                this.counter2.inc();
            } else if (value <= (long)this.counter3UpperBound) {
                this.counter3.inc();
            } else if (value <= (long)this.counter4UpperBound) {
                this.counter4.inc();
            } else if (value <= (long)this.counter5UpperBound) {
                this.counter5.inc();
            } else if (value <= (long)this.counter6UpperBound) {
                this.counter6.inc();
            } else if (value <= (long)this.counter7UpperBound) {
                this.counter7.inc();
            } else if (value <= (long)this.counter8UpperBound) {
                this.counter8.inc();
            } else if (value <= (long)this.counter9UpperBound) {
                this.counter9.inc();
            } else {
                this.counter10.inc();
            }
        }
    }

    public String toString() {
        if (this.group != null) {
            return "SnippetHistogram-" + this.group.name + ":" + this.name;
        }
        return super.toString();
    }
}

