/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.BiFunction;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AbsNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.RoundNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SignumNode;
import org.graalvm.compiler.nodes.calc.SqrtNode;
import org.graalvm.compiler.nodes.calc.UnsignedDivNode;
import org.graalvm.compiler.nodes.calc.UnsignedRemNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.debug.BindToRegisterNode;
import org.graalvm.compiler.nodes.debug.BlackholeNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.debug.NeverStripMineNode;
import org.graalvm.compiler.nodes.debug.SideEffectNode;
import org.graalvm.compiler.nodes.debug.SpillRegistersNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.CacheWritebackNode;
import org.graalvm.compiler.nodes.extended.CacheWritebackSyncNode;
import org.graalvm.compiler.nodes.extended.ClassIsArrayNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.extended.OpaqueNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.extended.RawVolatileLoadNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryLoadNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryStoreNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.RegisterFinalizerNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.EnsureVirtualizedNode;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfDispatchNode;
import org.graalvm.compiler.replacements.BoxingSnippets;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.JDK9StringSubstitutions;
import org.graalvm.compiler.replacements.StringSubstitutions;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ProfileBooleanNode;
import org.graalvm.compiler.replacements.nodes.ReverseBytesNode;
import org.graalvm.compiler.replacements.nodes.VirtualizableInvokeMacroNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactSplitNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public class StandardGraphBuilderPlugins {
    public static final Field STRING_VALUE_FIELD;
    private static final Field STRING_CODER_FIELD;
    private static final SpeculationReasonGroup DIRECTIVE_SPECULATIONS;

    public static void registerInvocationPlugins(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, Replacements replacements, boolean allowDeoptimization, boolean explicitUnsafeNullChecks, boolean arrayEqualsSubstitution, LoweringProvider lowerer) {
        StandardGraphBuilderPlugins.registerObjectPlugins(plugins);
        StandardGraphBuilderPlugins.registerClassPlugins(plugins);
        StandardGraphBuilderPlugins.registerMathPlugins(plugins, allowDeoptimization, replacements, lowerer);
        StandardGraphBuilderPlugins.registerStrictMathPlugins(plugins);
        StandardGraphBuilderPlugins.registerUnsignedMathPlugins(plugins);
        StandardGraphBuilderPlugins.registerStringPlugins(plugins, replacements, snippetReflection, arrayEqualsSubstitution);
        StandardGraphBuilderPlugins.registerCharacterPlugins(plugins);
        StandardGraphBuilderPlugins.registerShortPlugins(plugins);
        StandardGraphBuilderPlugins.registerIntegerLongPlugins(plugins, JavaKind.Int);
        StandardGraphBuilderPlugins.registerIntegerLongPlugins(plugins, JavaKind.Long);
        StandardGraphBuilderPlugins.registerFloatPlugins(plugins);
        StandardGraphBuilderPlugins.registerDoublePlugins(plugins);
        if (arrayEqualsSubstitution) {
            StandardGraphBuilderPlugins.registerArraysPlugins(plugins, replacements);
        }
        StandardGraphBuilderPlugins.registerArrayPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerUnsafePlugins(plugins, replacements, explicitUnsafeNullChecks);
        StandardGraphBuilderPlugins.registerPlatformSpecificUnsafePlugins(plugins, replacements, explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Object});
        StandardGraphBuilderPlugins.registerEdgesPlugins(metaAccess, plugins);
        StandardGraphBuilderPlugins.registerGraalDirectivesPlugins(plugins);
        StandardGraphBuilderPlugins.registerBoxingPlugins(plugins);
        StandardGraphBuilderPlugins.registerJMHBlackholePlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerJFRThrowablePlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerMethodHandleImplPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerPreconditionsPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerJcovCollectPlugins(plugins, replacements);
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final SnippetReflectionProvider snippetReflection, boolean arrayEqualsSubstitution) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)String.class), replacements);
        r.register1("hashCode", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                String s;
                if (receiver.isConstant() && (s = snippetReflection.asObject(String.class, (JavaConstant)receiver.get().asConstant())) != null) {
                    b.addPush(JavaKind.Int, b.add(ConstantNode.forInt(s.hashCode())));
                    return true;
                }
                return false;
            }
        });
        r.register1("intern", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                String s;
                if (receiver.isConstant() && (s = snippetReflection.asObject(String.class, (JavaConstant)receiver.get().asConstant())) != null) {
                    JavaConstant interned = snippetReflection.forObject(s.intern());
                    b.addPush(JavaKind.Object, b.add(ConstantNode.forConstant(interned, b.getMetaAccess(), b.getGraph())));
                    return true;
                }
                return false;
            }
        });
        if (arrayEqualsSubstitution) {
            r.register2("equals", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new StringEqualsInvocationPlugin());
        }
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            InvocationPlugins.Registration sr = new InvocationPlugins.Registration(plugins, (Type)((Object)StringSubstitutions.class));
            sr.register1("getValue", (Type)((Object)String.class), new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    ResolvedJavaField field = b.getMetaAccess().lookupJavaField(STRING_VALUE_FIELD);
                    ValueNode object = b.nullCheckedValue(value);
                    b.addPush(JavaKind.Object, LoadFieldNode.create(b.getConstantFieldProvider(), b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), b.getAssumptions(), object, field, false, false));
                    return true;
                }
            });
        } else {
            InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
            utf16r.setAllowOverwrite(true);
            utf16r.register2("getChar", (Type)((Object)byte[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                    b.addPush(JavaKind.Char, new JavaReadNode(JavaKind.Char, (AddressNode)new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), OnHeapMemoryAccess.BarrierType.NONE, false));
                    return true;
                }
            });
            utf16r.register3("putChar", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
                    b.add(new JavaWriteNode(JavaKind.Char, new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), arg3, OnHeapMemoryAccess.BarrierType.NONE, false));
                    return true;
                }
            });
            InvocationPlugins.Registration sr = new InvocationPlugins.Registration(plugins, (Type)((Object)JDK9StringSubstitutions.class));
            sr.register1("getValue", (Type)((Object)String.class), new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    ResolvedJavaField field = b.getMetaAccess().lookupJavaField(STRING_VALUE_FIELD);
                    ValueNode object = b.nullCheckedValue(value);
                    b.addPush(JavaKind.Object, LoadFieldNode.create(b.getConstantFieldProvider(), b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), b.getAssumptions(), object, field, false, false));
                    return true;
                }
            });
            sr.register1("getCoder", (Type)((Object)String.class), new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    ResolvedJavaField field = b.getMetaAccess().lookupJavaField(STRING_CODER_FIELD);
                    b.addPush(JavaKind.Int, LoadFieldNode.create(b.getConstantFieldProvider(), b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), b.getAssumptions(), value, field, false, false));
                    return true;
                }
            });
            sr.register2("getByte", (Type)((Object)byte[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                    b.addPush(JavaKind.Byte, new JavaReadNode(JavaKind.Byte, (AddressNode)new IndexAddressNode(arg1, arg2, JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), OnHeapMemoryAccess.BarrierType.NONE, false));
                    return true;
                }
            });
        }
    }

    private static void registerArraysPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Arrays.class), replacements);
        r.register2("equals", (Type)((Object)boolean[].class), (Type)((Object)boolean[].class), new ArrayEqualsInvocationPlugin(JavaKind.Boolean));
        r.register2("equals", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayEqualsInvocationPlugin(JavaKind.Byte));
        r.register2("equals", (Type)((Object)short[].class), (Type)((Object)short[].class), new ArrayEqualsInvocationPlugin(JavaKind.Short));
        r.register2("equals", (Type)((Object)char[].class), (Type)((Object)char[].class), new ArrayEqualsInvocationPlugin(JavaKind.Char));
        r.register2("equals", (Type)((Object)int[].class), (Type)((Object)int[].class), new ArrayEqualsInvocationPlugin(JavaKind.Int));
        r.register2("equals", (Type)((Object)long[].class), (Type)((Object)long[].class), new ArrayEqualsInvocationPlugin(JavaKind.Long));
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.register2("newInstance", (Type)((Object)Class.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode componentType, ValueNode length) {
                ValueNode componentTypeNonNull = b.nullCheckedValue(componentType);
                ValueNode lengthPositive = b.maybeEmitExplicitNegativeArraySizeCheck(length);
                b.addPush(JavaKind.Object, new DynamicNewArrayNode(componentTypeNonNull, lengthPositive, true));
                return true;
            }
        });
        r.register1("getLength", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode object) {
                ValueNode array;
                ValueNode objectNonNull = b.nullCheckedValue(object);
                LogicNode isArray = b.add(ObjectIsArrayNode.create(objectNonNull));
                GuardingNode isArrayGuard = b.needsExplicitException() ? b.emitBytecodeExceptionCheck(isArray, true, BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, new ValueNode[0]) : (GuardingNode)b.add(new FixedGuardNode(isArray, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateRecompile, false));
                if (isArrayGuard != null) {
                    AbstractObjectStamp alwaysArrayStamp = ((AbstractObjectStamp)objectNonNull.stamp(NodeView.DEFAULT)).asAlwaysArray();
                    array = b.add(new PiNode(objectNonNull, (Stamp)alwaysArrayStamp, isArrayGuard.asNode()));
                } else {
                    array = objectNonNull;
                }
                b.addPush(JavaKind.Int, new ArrayLengthNode(array));
                return true;
            }
        });
    }

    private static Class<?> getJavaClass(JavaKind kind) {
        return kind == JavaKind.Object ? Object.class : kind.toJavaClass();
    }

    private static String getKindName(boolean isSunMiscUnsafe, JavaKind kind) {
        return kind == JavaKind.Object && !isSunMiscUnsafe && JavaVersionUtil.JAVA_SPEC > 11 ? "Reference" : kind.name();
    }

    public static void registerPlatformSpecificUnsafePlugins(InvocationPlugins plugins, Replacements replacements, boolean explicitUnsafeNullChecks, JavaKind[] supportedJavaKinds) {
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class)), true, explicitUnsafeNullChecks, "compareAndSwap", new String[]{""}, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object});
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
            StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(r, false, explicitUnsafeNullChecks, "compareAndSet", new String[]{""}, supportedJavaKinds);
            StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(r, false, explicitUnsafeNullChecks, "compareAndExchange", new String[]{""}, supportedJavaKinds);
        }
    }

    private static void registerUnsafeAtomicsPlugins(InvocationPlugins.Registration r, boolean isSunMiscUnsafe, boolean explicitUnsafeNullChecks, String casPrefix, String[] memoryOrders, JavaKind[] supportedJavaKinds) {
        for (JavaKind kind : supportedJavaKinds) {
            Class<?> javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
            String kindName = StandardGraphBuilderPlugins.getKindName(isSunMiscUnsafe, kind);
            boolean isLogic = true;
            JavaKind returnKind = JavaKind.Boolean.getStackKind();
            if (casPrefix.startsWith("compareAndExchange")) {
                isLogic = false;
                returnKind = kind.isNumericInteger() ? kind.getStackKind() : kind;
            }
            for (String memoryOrderString : memoryOrders) {
                MemoryOrderMode memoryOrder = memoryOrderString.equals("") ? MemoryOrderMode.VOLATILE : MemoryOrderMode.valueOf(memoryOrderString.toUpperCase());
                r.register5(casPrefix + kindName + memoryOrderString, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, javaClass, new UnsafeCompareAndSwapPlugin(returnKind, kind, memoryOrder, isLogic, explicitUnsafeNullChecks));
            }
        }
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, Replacements replacements, boolean explicitUnsafeNullChecks) {
        StandardGraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class)), true, explicitUnsafeNullChecks);
        StandardGraphBuilderPlugins.registerUnsafeGetAndOpPlugins(new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class)), explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object}, "Object");
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
            JavaKind[] supportedJavaKinds = new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Object};
            StandardGraphBuilderPlugins.registerUnsafePlugins(r, false, explicitUnsafeNullChecks);
            StandardGraphBuilderPlugins.registerUnsafeUnalignedPlugins(r, explicitUnsafeNullChecks);
            StandardGraphBuilderPlugins.registerUnsafeGetAndOpPlugins(r, explicitUnsafeNullChecks, supportedJavaKinds, JavaVersionUtil.JAVA_SPEC > 11 ? "Reference" : "Object");
            StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(r, false, explicitUnsafeNullChecks, "weakCompareAndSet", new String[]{"", "Acquire", "Release", "Plain"}, supportedJavaKinds);
            StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(r, false, explicitUnsafeNullChecks, "compareAndExchange", new String[]{"Acquire", "Release"}, supportedJavaKinds);
        }
    }

    private static void registerUnsafeUnalignedPlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks) {
        for (JavaKind kind : new JavaKind[]{JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long}) {
            Class javaClass = kind.toJavaClass();
            r.registerOptional3("get" + kind.name() + "Unaligned", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new UnsafeGetPlugin(kind, explicitUnsafeNullChecks));
            r.registerOptional4("put" + kind.name() + "Unaligned", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, explicitUnsafeNullChecks));
        }
    }

    private static void registerUnsafeGetAndOpPlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks, JavaKind[] unsafeJavaKinds, String objectKindName) {
        for (final JavaKind kind : unsafeJavaKinds) {
            Class javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            String kindName = kind == JavaKind.Object ? objectKindName : kind.name();
            r.register4("getAndSet" + kindName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndWriteNode(obj, offset, value, kind, loc));
                    return true;
                }
            });
            if (kind == JavaKind.Boolean || !kind.isNumericInteger()) continue;
            r.register4("getAndAdd" + kindName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode delta) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndAddNode(obj, offset, delta, kind, loc));
                    return true;
                }
            });
        }
    }

    private static void registerUnsafePlugins(InvocationPlugins.Registration r, boolean sunMiscUnsafe, boolean explicitUnsafeNullChecks) {
        for (JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            Class javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            String kindName = StandardGraphBuilderPlugins.getKindName(sunMiscUnsafe, kind);
            String getName = "get" + kindName;
            String putName = "put" + kindName;
            r.register3(getName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new UnsafeGetPlugin(kind, explicitUnsafeNullChecks));
            r.register4(putName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, explicitUnsafeNullChecks));
            r.register3(getName + "Volatile", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new UnsafeGetPlugin(kind, MemoryOrderMode.VOLATILE, explicitUnsafeNullChecks));
            r.register4(putName + "Volatile", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, MemoryOrderMode.VOLATILE, explicitUnsafeNullChecks));
            if (sunMiscUnsafe) {
                if (kind == JavaKind.Int || kind == JavaKind.Long || kind == JavaKind.Object) {
                    r.register4("putOrdered" + kindName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, MemoryOrderMode.RELEASE_ACQUIRE, explicitUnsafeNullChecks));
                }
            } else {
                r.register4("put" + kindName + "Release", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, MemoryOrderMode.RELEASE, explicitUnsafeNullChecks));
                r.register3("get" + kindName + "Acquire", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new UnsafeGetPlugin(kind, MemoryOrderMode.ACQUIRE, explicitUnsafeNullChecks));
                r.register4("put" + kindName + "Opaque", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new UnsafePutPlugin(kind, MemoryOrderMode.OPAQUE, explicitUnsafeNullChecks));
                r.register3("get" + kindName + "Opaque", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new UnsafeGetPlugin(kind, MemoryOrderMode.OPAQUE, explicitUnsafeNullChecks));
            }
            if (kind == JavaKind.Boolean || kind == JavaKind.Object) continue;
            r.register2(getName, (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, new UnsafeGetPlugin(kind, explicitUnsafeNullChecks));
            r.register3(putName, (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, kind.toJavaClass(), new UnsafePutPlugin(kind, explicitUnsafeNullChecks));
        }
        r.register2("getAddress", (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, new UnsafeGetPlugin(JavaKind.Long, explicitUnsafeNullChecks));
        r.register3("putAddress", (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, Long.TYPE, new UnsafePutPlugin(JavaKind.Long, explicitUnsafeNullChecks));
        r.register1("loadFence", (Type)((Object)InvocationPlugin.Receiver.class), new UnsafeFencePlugin(3));
        r.register1("storeFence", (Type)((Object)InvocationPlugin.Receiver.class), new UnsafeFencePlugin(10));
        r.register1("fullFence", (Type)((Object)InvocationPlugin.Receiver.class), new UnsafeFencePlugin(15));
        if (!sunMiscUnsafe) {
            r.register2("getUncompressedObject", (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, new UnsafeGetPlugin(JavaKind.Object, explicitUnsafeNullChecks));
            if (JavaVersionUtil.JAVA_SPEC >= 14) {
                r.register2("writeback0", (Type)((Object)InvocationPlugin.Receiver.class), Long.TYPE, new CacheWritebackPlugin(false));
                r.register1("writebackPreSync0", (Type)((Object)InvocationPlugin.Receiver.class), new CacheWritebackPlugin(true));
                r.register1("writebackPostSync0", (Type)((Object)InvocationPlugin.Receiver.class), new CacheWritebackPlugin(false));
            }
        }
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, final JavaKind kind) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass);
        r.register1("reverseBytes", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, b.append((ValueNode)new ReverseBytesNode(value).canonical(null)));
                return true;
            }
        });
        r.register2("divideUnsigned", type, type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                GuardingNode zeroCheck = b.maybeEmitExplicitDivisionByZeroCheck(divisor);
                b.push(kind, b.append(UnsignedDivNode.create(dividend, divisor, zeroCheck, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register2("remainderUnsigned", type, type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                GuardingNode zeroCheck = b.maybeEmitExplicitDivisionByZeroCheck(divisor);
                b.push(kind, b.append(UnsignedRemNode.create(dividend, divisor, zeroCheck, NodeView.DEFAULT)));
                return true;
            }
        });
    }

    private static void registerCharacterPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Character.class));
        r.register1("reverseBytes", Character.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ReverseBytesNode reverse = b.add(new ReverseBytesNode(value));
                RightShiftNode rightShift = b.add(new RightShiftNode(reverse, b.add(ConstantNode.forInt(16))));
                ZeroExtendNode charCast = b.add(new ZeroExtendNode(b.add(new NarrowNode(rightShift, 16)), 32));
                b.push(JavaKind.Char, b.append((ValueNode)charCast.canonical(null)));
                return true;
            }
        });
    }

    private static void registerShortPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Short.class));
        r.register1("reverseBytes", Short.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ReverseBytesNode reverse = b.add(new ReverseBytesNode(value));
                RightShiftNode rightShift = b.add(new RightShiftNode(reverse, b.add(ConstantNode.forInt(16))));
                SignExtendNode charCast = b.add(new SignExtendNode(b.add(new NarrowNode(rightShift, 16)), 32));
                b.push(JavaKind.Short, b.append((ValueNode)charCast.canonical(null)));
                return true;
            }
        });
    }

    private static void registerFloatPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Float.class));
        r.register1("floatToRawIntBits", Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append(ReinterpretNode.create(JavaKind.Int, value, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register1("floatToIntBits", Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                LogicNode notNan = b.append(FloatEqualsNode.create(value, value, NodeView.DEFAULT));
                ValueNode raw = b.append(ReinterpretNode.create(JavaKind.Int, value, NodeView.DEFAULT));
                ValueNode result = b.append(ConditionalNode.create(notNan, raw, ConstantNode.forInt(2143289344), NodeView.DEFAULT));
                b.push(JavaKind.Int, result);
                return true;
            }
        });
        r.register1("intBitsToFloat", Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Float, b.append(ReinterpretNode.create(JavaKind.Float, value, NodeView.DEFAULT)));
                return true;
            }
        });
    }

    private static void registerDoublePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Double.class));
        r.register1("doubleToRawLongBits", Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Long, b.append(ReinterpretNode.create(JavaKind.Long, value, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register1("doubleToLongBits", Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                LogicNode notNan = b.append(FloatEqualsNode.create(value, value, NodeView.DEFAULT));
                ValueNode raw = b.append(ReinterpretNode.create(JavaKind.Long, value, NodeView.DEFAULT));
                ValueNode result = b.append(ConditionalNode.create(notNan, raw, ConstantNode.forLong(9221120237041090560L), NodeView.DEFAULT));
                b.push(JavaKind.Long, result);
                return true;
            }
        });
        r.register1("longBitsToDouble", Long.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(ReinterpretNode.create(JavaKind.Double, value, NodeView.DEFAULT)));
                return true;
            }
        });
    }

    private static GuardingNode createIntegerExactArithmeticGuardNode(GraphBuilderContext b, ValueNode x, ValueNode y, IntegerExactOp op) {
        IntegerExactOverflowNode overflowCheck;
        switch (op) {
            case INTEGER_ADD_EXACT: 
            case INTEGER_INCREMENT_EXACT: {
                overflowCheck = new IntegerAddExactOverflowNode(x, y);
                break;
            }
            case INTEGER_SUBTRACT_EXACT: 
            case INTEGER_DECREMENT_EXACT: {
                overflowCheck = new IntegerSubExactOverflowNode(x, y);
                break;
            }
            case INTEGER_MULTIPLY_EXACT: {
                overflowCheck = new IntegerMulExactOverflowNode(x, y);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
            }
        }
        return b.add(new FixedGuardNode(overflowCheck, DeoptimizationReason.ArithmeticException, DeoptimizationAction.InvalidateRecompile, true));
    }

    private static ValueNode createIntegerExactArithmeticNode(GraphBuilderContext b, ValueNode x, ValueNode y, IntegerExactOp op) {
        switch (op) {
            case INTEGER_ADD_EXACT: 
            case INTEGER_INCREMENT_EXACT: {
                return new IntegerAddExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
            case INTEGER_SUBTRACT_EXACT: 
            case INTEGER_DECREMENT_EXACT: {
                return new IntegerSubExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
            case INTEGER_MULTIPLY_EXACT: {
                return new IntegerMulExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
        }
        throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
    }

    private static IntegerExactArithmeticSplitNode createIntegerExactSplit(ValueNode x, ValueNode y, AbstractBeginNode exceptionEdge, IntegerExactOp op) {
        switch (op) {
            case INTEGER_ADD_EXACT: 
            case INTEGER_INCREMENT_EXACT: {
                return new IntegerAddExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
            case INTEGER_SUBTRACT_EXACT: 
            case INTEGER_DECREMENT_EXACT: {
                return new IntegerSubExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
            case INTEGER_MULTIPLY_EXACT: {
                return new IntegerMulExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
        }
        throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
    }

    private static void createIntegerExactOperation(GraphBuilderContext b, JavaKind kind, ValueNode x, ValueNode y, IntegerExactOp op) {
        if (b.needsExplicitException()) {
            BytecodeExceptionNode.BytecodeExceptionKind exceptionKind = kind == JavaKind.Int ? BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW : BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW;
            AbstractBeginNode exceptionEdge = b.genExplicitExceptionEdge(exceptionKind, new ValueNode[0]);
            IntegerExactArithmeticSplitNode split = b.addPush(kind, StandardGraphBuilderPlugins.createIntegerExactSplit(x, y, exceptionEdge, op));
            split.setNext(b.add(new BeginNode()));
        } else {
            b.addPush(kind, StandardGraphBuilderPlugins.createIntegerExactArithmeticNode(b, x, y, op));
        }
    }

    private static void registerMathPlugins(InvocationPlugins plugins, boolean allowDeoptimization, Replacements replacements, LoweringProvider lowerer) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class), replacements);
        if (allowDeoptimization) {
            for (final JavaKind kind : new JavaKind[]{JavaKind.Int, JavaKind.Long}) {
                Class type = kind.toJavaClass();
                r.register1("decrementExact", type, new InvocationPlugin(){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                        ConstantNode y = b.add(ConstantNode.forIntegerKind(kind, 1L));
                        StandardGraphBuilderPlugins.createIntegerExactOperation(b, kind, x, y, IntegerExactOp.INTEGER_DECREMENT_EXACT);
                        return true;
                    }
                });
                r.register1("incrementExact", type, new InvocationPlugin(){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                        ConstantNode y = b.add(ConstantNode.forIntegerKind(kind, 1L));
                        StandardGraphBuilderPlugins.createIntegerExactOperation(b, kind, x, y, IntegerExactOp.INTEGER_INCREMENT_EXACT);
                        return true;
                    }
                });
                r.register2("addExact", type, type, new InvocationPlugin(){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactOperation(b, kind, x, y, IntegerExactOp.INTEGER_ADD_EXACT);
                        return true;
                    }
                });
                r.register2("subtractExact", type, type, new InvocationPlugin(){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactOperation(b, kind, x, y, IntegerExactOp.INTEGER_SUBTRACT_EXACT);
                        return true;
                    }
                });
                r.register2("multiplyExact", type, type, new InvocationPlugin(){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactOperation(b, kind, x, y, IntegerExactOp.INTEGER_MULTIPLY_EXACT);
                        return true;
                    }
                });
            }
        }
        r.register1("abs", Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Float, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register1("abs", Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register1("sqrt", Double.TYPE, new MathSqrtPlugin());
        boolean supportsRound = lowerer.supportsRounding();
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "rint", ArithmeticLIRGeneratorTool.RoundingMode.NEAREST);
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "ceil", ArithmeticLIRGeneratorTool.RoundingMode.UP);
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "floor", ArithmeticLIRGeneratorTool.RoundingMode.DOWN);
        r.register1("signum", Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode f) {
                b.addPush(JavaKind.Float, new SignumNode(f));
                return true;
            }
        });
        r.register1("signum", Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode d) {
                b.addPush(JavaKind.Double, new SignumNode(d));
                return true;
            }
        });
    }

    private static void registerRound(boolean supportsRound, InvocationPlugins.Registration r, String name, final ArithmeticLIRGeneratorTool.RoundingMode mode) {
        r.registerConditional1(supportsRound, name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, b.append(new RoundNode(arg, mode)));
                return true;
            }
        });
    }

    private static void registerStrictMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)StrictMath.class));
        r.register1("sqrt", Double.TYPE, new MathSqrtPlugin());
    }

    private static void registerUnsignedMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)UnsignedMath.class));
        r.register2("aboveThan", Integer.TYPE, Integer.TYPE, new UnsignedMathPlugin(Condition.AT));
        r.register2("aboveThan", Long.TYPE, Long.TYPE, new UnsignedMathPlugin(Condition.AT));
        r.register2("belowThan", Integer.TYPE, Integer.TYPE, new UnsignedMathPlugin(Condition.BT));
        r.register2("belowThan", Long.TYPE, Long.TYPE, new UnsignedMathPlugin(Condition.BT));
        r.register2("aboveOrEqual", Integer.TYPE, Integer.TYPE, new UnsignedMathPlugin(Condition.AE));
        r.register2("aboveOrEqual", Long.TYPE, Long.TYPE, new UnsignedMathPlugin(Condition.AE));
        r.register2("belowOrEqual", Integer.TYPE, Integer.TYPE, new UnsignedMathPlugin(Condition.BE));
        r.register2("belowOrEqual", Long.TYPE, Long.TYPE, new UnsignedMathPlugin(Condition.BE));
    }

    protected static void registerBoxingPlugins(InvocationPlugins plugins) {
        for (JavaKind kind : JavaKind.values()) {
            if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
            new BoxPlugin(kind).register(plugins);
            new UnboxPlugin(kind).register(plugins);
        }
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class));
        r.register1("<init>", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (targetMethod.canBeInlined() && targetMethod.getCodeSize() == 1) {
                    ValueNode object = receiver.get();
                    if (RegisterFinalizerNode.mayHaveFinalizer(object, b.getMetaAccess(), b.getAssumptions())) {
                        RegisterFinalizerNode regFin = new RegisterFinalizerNode(object);
                        b.add(regFin);
                        assert (regFin.stateAfter() != null);
                    }
                    return true;
                }
                return false;
            }
        });
        r.register1("getClass", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                ValueNode folded = GetClassNode.tryFold(b.getMetaAccess(), b.getConstantReflection(), NodeView.DEFAULT, GraphUtil.originalValue(object, true));
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    ObjectStamp stamp = StampFactory.objectNonNull(TypeReference.createTrusted(b.getAssumptions(), b.getMetaAccess().lookupJavaType(Class.class)));
                    b.addPush(JavaKind.Object, new GetClassNode(stamp, object));
                }
                return true;
            }
        });
    }

    private static void registerClassPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Class.class));
        r.register2("isInstance", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode object) {
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), type.get(), object, false));
                b.push(JavaKind.Boolean, b.append(new ConditionalNode(condition).canonical(null)));
                return true;
            }
        });
        r.register2("isAssignableFrom", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode otherType) {
                ClassIsAssignableFromNode condition = b.append(new ClassIsAssignableFromNode(type.get(), b.nullCheckedValue(otherType)));
                b.push(JavaKind.Boolean, b.append(new ConditionalNode(condition).canonical(null)));
                return true;
            }
        });
        r.register1("isArray", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                LogicNode isArray = b.add(ClassIsArrayNode.create(b.getConstantReflection(), receiver.get()));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(isArray, NodeView.DEFAULT));
                return true;
            }
        });
        r.register2("cast", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.genCheckcastDynamic(object, receiver.get());
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
    }

    private static void registerEdgesPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Edges.class));
        for (final Class c : new Class[]{Node.class, NodeList.class}) {
            r.register2("get" + c.getSimpleName() + "Unsafe", (Type)((Object)Node.class), Long.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset) {
                    ObjectStamp stamp = StampFactory.object(TypeReference.createTrusted(b.getAssumptions(), metaAccess.lookupJavaType(c)));
                    RawLoadNode value = b.add(new RawLoadNode(stamp, node, offset, LocationIdentity.any(), JavaKind.Object));
                    b.addPush(JavaKind.Object, value);
                    return true;
                }
            });
            r.register3("put" + c.getSimpleName() + "Unsafe", (Type)((Object)Node.class), Long.TYPE, c, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset, ValueNode value) {
                    b.add(new RawStoreNode(node, offset, value, JavaKind.Object, LocationIdentity.any()));
                    return true;
                }
            });
        }
    }

    private static void registerGraalDirectivesPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)GraalDirectives.class));
        r.register0("deoptimize", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register0("deoptimizeAndInvalidate", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register0("deoptimizeAndInvalidateWithSpeculation", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                GraalError.guarantee(b.getGraph().getSpeculationLog() != null, "A speculation log is needed to use `deoptimizeAndInvalidateWithSpeculation`");
                BytecodePosition pos = new BytecodePosition(null, b.getMethod(), b.bci());
                SpeculationLog.SpeculationReason reason = DIRECTIVE_SPECULATIONS.createSpeculationReason(pos);
                SpeculationLog.Speculation speculation = b.getGraph().getSpeculationLog().maySpeculate(reason) ? b.getGraph().getSpeculationLog().speculate(reason) : SpeculationLog.NO_SPECULATION;
                b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter, speculation));
                return true;
            }
        });
        r.register0("inCompiledCode", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                return true;
            }
        });
        r.register0("inIntrinsic", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(b.parsingIntrinsic()));
                return true;
            }
        });
        r.register0("controlFlowAnchor", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new ControlFlowAnchorNode());
                return true;
            }
        });
        r.register0("neverStripMine", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new NeverStripMineNode());
                return true;
            }
        });
        r.register0("sideEffect", new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new SideEffectNode());
                return true;
            }
        });
        r.register1("sideEffect", Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a) {
                b.addPush(JavaKind.Int, new SideEffectNode(a));
                return true;
            }
        });
        r.register1("trustedBox", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a) {
                b.addPush(JavaKind.Object, new BoxNode.TrustedBoxedValue(a));
                return true;
            }
        });
        r.register2("assumeStableDimension", (Type)((Object)Object.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode dimension) {
                if (array instanceof ConstantNode && b.getMetaAccess().lookupJavaType(array.asJavaConstant()).isArray() && dimension instanceof ConstantNode && dimension.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                    int stableDim = dimension.asJavaConstant().asInt();
                    ConstantNode c = ConstantNode.forConstant(array.asJavaConstant(), stableDim, false, b.getMetaAccess());
                    b.addPush(JavaKind.Object, c);
                    return true;
                }
                throw GraalError.shouldNotReachHere("Illegal usage of stable array intrinsic assumeStableDimension(array, dimension): This compiler intrinsic can only be used iff array is a constant node (i.e., constant field) and iff dimension is a constant int. It will replace the constant array with a new constant that additionally sets the stabledimensions to the int parameter supplied.");
            }
        });
        r.register2("injectBranchProbability", Double.TYPE, Boolean.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode probability, ValueNode condition) {
                b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probability, condition));
                return true;
            }
        });
        r.register2("injectIterationCount", Double.TYPE, Boolean.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode iterations, ValueNode condition) {
                if (iterations.isJavaConstant()) {
                    double iterationsConstant;
                    if (iterations.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                        iterationsConstant = iterations.asJavaConstant().asLong();
                    } else if (iterations.stamp(NodeView.DEFAULT) instanceof FloatStamp) {
                        iterationsConstant = iterations.asJavaConstant().asDouble();
                    } else {
                        return false;
                    }
                    double probability = 1.0 - 1.0 / iterationsConstant;
                    ConstantNode probabilityNode = b.add(ConstantNode.forDouble(probability));
                    b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probabilityNode, condition));
                    return true;
                }
                return false;
            }
        });
        InvocationPlugin blackholePlugin = new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.add(new BlackholeNode(value));
                return true;
            }
        };
        InvocationPlugin bindToRegisterPlugin = new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.add(new BindToRegisterNode(value));
                return true;
            }
        };
        for (final JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            Class<?> javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
            r.register1("blackhole", javaClass, blackholePlugin);
            r.register1("bindToRegister", javaClass, bindToRegisterPlugin);
            r.register1("opaque", javaClass, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.addPush(kind, new OpaqueNode(value));
                    return true;
                }
            });
        }
        InvocationPlugin spillPlugin = new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new SpillRegistersNode());
                return true;
            }
        };
        r.register0("spillRegisters", spillPlugin);
        r.register1("guardingNonNull", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.addPush(value.getStackKind(), b.nullCheckedValue(value));
                return true;
            }
        });
        r.register1("ensureVirtualized", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, false));
                return true;
            }
        });
        r.register1("ensureVirtualizedHere", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, true));
                return true;
            }
        });
        r.register0("breakpoint", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new BreakpointNode(new ValueNode[0]));
                return true;
            }
        });
        r.register1("isCompilationConstant", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(value.isJavaConstant()));
                return true;
            }
        });
    }

    private static void registerJMHBlackholePlugins(InvocationPlugins plugins, Replacements replacements) {
        String[] names;
        InvocationPlugin blackholePlugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver blackhole, ValueNode value) {
                blackhole.get();
                b.add(new BlackholeNode(value));
                return true;
            }

            @Override
            public boolean isDecorator() {
                return true;
            }
        };
        for (String name : names = new String[]{"org.openjdk.jmh.infra.Blackhole", "org.openjdk.jmh.logic.BlackHole"}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, name, replacements);
            for (JavaKind kind : JavaKind.values()) {
                if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
                Class<?> javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
                r.registerOptional2("consume", (Type)((Object)InvocationPlugin.Receiver.class), javaClass, blackholePlugin);
            }
            r.registerOptional2("consume", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object[].class), blackholePlugin);
        }
    }

    private static void registerJFRThrowablePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "oracle.jrockit.jfr.jdkevents.ThrowableTracer", replacements);
        r.register2("traceThrowable", (Type)((Object)Throwable.class), (Type)((Object)String.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                b.add(new VirtualizableInvokeMacroNode(MacroNode.MacroParams.of(b, targetMethod, throwable, message)));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
    }

    private static void registerMethodHandleImplPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.MethodHandleImpl", replacements);
        r.registerOptional2("castReference", (Type)((Object)Class.class), (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode javaClass, ValueNode object) {
                b.genCheckcastDynamic(object, javaClass);
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.register2("profileBoolean", Boolean.TYPE, (Type)((Object)int[].class), new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode counters) {
                if (b.needsExplicitException()) {
                    return false;
                }
                if (result.isConstant()) {
                    b.push(JavaKind.Boolean, result);
                    return true;
                }
                if (counters.isConstant()) {
                    ValueNode newResult = result;
                    int[] ctrs = ConstantReflectionUtil.loadIntArrayConstant(b.getConstantReflection(), (JavaConstant)counters.asConstant(), 2);
                    if (ctrs != null && ctrs.length == 2) {
                        int trueCount = ctrs[1];
                        int falseCount = ctrs[0];
                        int totalCount = trueCount + falseCount;
                        if (totalCount == 0) {
                            b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter));
                        } else if (falseCount == 0 || trueCount == 0) {
                            boolean expected = falseCount == 0;
                            LogicNode condition = b.add(IntegerEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, result, b.add(ConstantNode.forBoolean(!expected)), NodeView.DEFAULT));
                            b.append(new FixedGuardNode(condition, DeoptimizationReason.UnreachedCode, DeoptimizationAction.InvalidateReprofile, true));
                            newResult = b.add(ConstantNode.forBoolean(expected));
                        }
                    }
                    b.addPush(JavaKind.Boolean, newResult);
                    return true;
                }
                b.addPush(JavaKind.Boolean, new ProfileBooleanNode(b.getConstantReflection(), MacroNode.MacroParams.of(b, targetMethod, result, counters)));
                return true;
            }
        });
        if (JavaVersionUtil.JAVA_SPEC >= 9) {
            r.register1("isCompileConstant", (Type)((Object)Object.class), new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode obj) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(obj.isConstant()));
                    return true;
                }
            });
        }
    }

    private static void registerPreconditionsPlugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC >= 9) {
            InvocationPlugins.Registration preconditions = new InvocationPlugins.Registration(plugins, "jdk.internal.util.Preconditions", replacements);
            preconditions.register3("checkIndex", Integer.TYPE, Integer.TYPE, (Type)((Object)BiFunction.class), new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode index, ValueNode length, ValueNode oobef) {
                    LogicNode rangeCheck;
                    if (b.needsExplicitException()) {
                        return false;
                    }
                    ValueNode checkedIndex = index;
                    ValueNode checkedLength = length;
                    LogicNode lengthNegative = IntegerLessThanNode.create(length, ConstantNode.forInt(0), NodeView.DEFAULT);
                    if (!lengthNegative.isContradiction()) {
                        FixedGuardNode guard = b.append(new FixedGuardNode(lengthNegative, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateRecompile, true));
                        checkedLength = PiNode.create(length, length.stamp(NodeView.DEFAULT).improveWith(StampFactory.positiveInt()), guard);
                    }
                    if (!(rangeCheck = IntegerBelowNode.create(index, checkedLength, NodeView.DEFAULT)).isTautology()) {
                        FixedGuardNode guard = b.append(new FixedGuardNode(rangeCheck, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateRecompile));
                        long upperBound = Math.max(0L, ((IntegerStamp)checkedLength.stamp(NodeView.DEFAULT)).upperBound() - 1L);
                        checkedIndex = PiNode.create(index, index.stamp(NodeView.DEFAULT).improveWith(StampFactory.forInteger(JavaKind.Int, 0L, upperBound)), guard);
                    }
                    b.addPush(JavaKind.Int, checkedIndex);
                    return true;
                }
            });
        }
    }

    private static void registerJcovCollectPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.tdk.jcov.runtime.Collect", replacements);
        r.register1("hit", Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                return b.parsingIntrinsic();
            }
        });
    }

    static {
        Field coder = null;
        try {
            STRING_VALUE_FIELD = String.class.getDeclaredField("value");
            if (JavaVersionUtil.JAVA_SPEC > 8) {
                coder = String.class.getDeclaredField("coder");
            }
        }
        catch (NoSuchFieldException e) {
            throw new GraalError(e);
        }
        STRING_CODER_FIELD = coder;
        DIRECTIVE_SPECULATIONS = new SpeculationReasonGroup("GraalDirective", BytecodePosition.class);
    }

    public static class StringLatin1IndexOfCharPlugin
    implements InvocationPlugin {
        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode ch, ValueNode origFromIndex) {
            if (!b.canMergeIntrinsicReturns()) {
                return false;
            }
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ConstantNode zero = ConstantNode.forInt(0);
                helper.emitReturnIf(helper.ushr(ch, 8), Condition.NE, zero, ConstantNode.forInt(-1), 0.25);
                ValueNode nonNullValue = b.nullCheckedValue(value);
                ValueNode length = helper.arraylength(nonNullValue);
                helper.emitReturnIf(origFromIndex, Condition.GE, length, ConstantNode.forInt(-1), 0.25);
                LogicNode condition = helper.createCompare(origFromIndex, CanonicalCondition.LT, zero);
                ValueNode fromIndex = ConditionalNode.create(condition, zero, origFromIndex, NodeView.DEFAULT);
                SignExtendNode toByte = b.add(new SignExtendNode(b.add(new NarrowNode(ch, JavaKind.Byte.getBitCount())), JavaKind.Int.getBitCount()));
                helper.emitFinalReturn(JavaKind.Int, new ArrayIndexOfDispatchNode(ArrayIndexOf.STUB_INDEX_OF_1_BYTE, JavaKind.Byte, JavaKind.Byte, false, nonNullValue, length, fromIndex, toByte));
            }
            return true;
        }
    }

    public static final class CacheWritebackPlugin
    implements InvocationPlugin {
        final boolean isPreSync;

        public CacheWritebackPlugin(boolean isPreSync) {
            this.isPreSync = isPreSync;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address) {
            unsafe.get();
            b.add(new CacheWritebackNode(address));
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe) {
            unsafe.get();
            b.add(new CacheWritebackSyncNode(this.isPreSync));
            return true;
        }
    }

    public static class UnsafeFencePlugin
    implements InvocationPlugin {
        private final int barriers;

        public UnsafeFencePlugin(int barriers) {
            this.barriers = barriers;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe) {
            unsafe.get();
            b.add(new MembarNode(this.barriers));
            return true;
        }
    }

    public static class UnsafeCompareAndSwapPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;
        private final JavaKind accessKind;
        private final boolean isLogic;

        public UnsafeCompareAndSwapPlugin(JavaKind returnKind, JavaKind accessKind, MemoryOrderMode memoryOrder, boolean isLogic, boolean explicitUnsafeNullChecks) {
            super(returnKind, explicitUnsafeNullChecks);
            this.memoryOrder = memoryOrder;
            this.accessKind = accessKind;
            this.isLogic = isLogic;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode expected, ValueNode newValue) {
            unsafe.get();
            if (this.isLogic) {
                this.createUnsafeAccess(object, b, (obj, loc) -> new UnsafeCompareAndSwapNode(obj, offset, expected, newValue, this.accessKind, loc, this.memoryOrder));
            } else {
                this.createUnsafeAccess(object, b, (obj, loc) -> new UnsafeCompareAndExchangeNode(obj, offset, expected, newValue, this.accessKind, loc, this.memoryOrder));
            }
            return true;
        }
    }

    public static class UnsafePutPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;

        public UnsafePutPlugin(JavaKind kind, boolean explicitUnsafeNullChecks) {
            this(kind, MemoryOrderMode.PLAIN, explicitUnsafeNullChecks);
        }

        private UnsafePutPlugin(JavaKind kind, MemoryOrderMode memoryOrder, boolean explicitUnsafeNullChecks) {
            super(kind, explicitUnsafeNullChecks);
            this.memoryOrder = memoryOrder;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address, ValueNode value) {
            assert (!this.memoryOrder.emitBarriers) : "Barriers for address based Unsafe put is not supported.";
            unsafe.get();
            ValueNode maskedValue = b.maskSubWordValue(value, this.unsafeAccessKind);
            b.add(new UnsafeMemoryStoreNode(address, maskedValue, this.unsafeAccessKind, NamedLocationIdentity.OFF_HEAP_LOCATION));
            b.getGraph().markUnsafeAccess();
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
            boolean emitBarriers;
            if (this.memoryOrder == MemoryOrderMode.OPAQUE && StampTool.isPointerAlwaysNull(object)) {
                return this.apply(b, targetMethod, unsafe, offset, value);
            }
            unsafe.get();
            boolean isVolatile = this.memoryOrder == MemoryOrderMode.VOLATILE;
            boolean bl = emitBarriers = this.memoryOrder.emitBarriers && !isVolatile;
            if (emitBarriers) {
                b.add(new MembarNode(this.memoryOrder.preWriteBarriers));
            }
            ValueNode maskedValue = b.maskSubWordValue(value, this.unsafeAccessKind);
            this.createUnsafeAccess(object, b, (obj, loc) -> new RawStoreNode(obj, offset, maskedValue, this.unsafeAccessKind, loc, true, isVolatile));
            if (emitBarriers) {
                b.add(new MembarNode(this.memoryOrder.postWriteBarriers));
            }
            return true;
        }
    }

    public static class UnsafeGetPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;

        public UnsafeGetPlugin(JavaKind returnKind, boolean explicitUnsafeNullChecks) {
            this(returnKind, MemoryOrderMode.PLAIN, explicitUnsafeNullChecks);
        }

        public UnsafeGetPlugin(JavaKind kind, MemoryOrderMode memoryOrder, boolean explicitUnsafeNullChecks) {
            super(kind, explicitUnsafeNullChecks);
            this.memoryOrder = memoryOrder;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address) {
            unsafe.get();
            b.addPush(this.unsafeAccessKind, new UnsafeMemoryLoadNode(address, this.unsafeAccessKind, NamedLocationIdentity.OFF_HEAP_LOCATION));
            b.getGraph().markUnsafeAccess();
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset) {
            boolean emitBarriers;
            if (this.memoryOrder == MemoryOrderMode.OPAQUE && StampTool.isPointerAlwaysNull(object)) {
                return this.apply(b, targetMethod, unsafe, offset);
            }
            unsafe.get();
            boolean isVolatile = this.memoryOrder == MemoryOrderMode.VOLATILE;
            boolean bl = emitBarriers = this.memoryOrder.emitBarriers && !isVolatile;
            if (emitBarriers) {
                b.add(new MembarNode(this.memoryOrder.preReadBarriers));
            }
            UnsafeAccessPlugin.UnsafeNodeConstructor unsafeNodeConstructor = null;
            unsafeNodeConstructor = isVolatile ? (obj, loc) -> new RawVolatileLoadNode(obj, offset, this.unsafeAccessKind, loc) : (obj, loc) -> new RawLoadNode(obj, offset, this.unsafeAccessKind, loc);
            this.createUnsafeAccess(object, b, unsafeNodeConstructor);
            if (emitBarriers) {
                b.add(new MembarNode(this.memoryOrder.postReadBarriers));
            }
            return true;
        }
    }

    public static abstract class UnsafeAccessPlugin
    implements InvocationPlugin {
        protected final JavaKind unsafeAccessKind;
        private final boolean explicitUnsafeNullChecks;

        public UnsafeAccessPlugin(JavaKind kind, boolean explicitUnsafeNullChecks) {
            this.unsafeAccessKind = kind;
            this.explicitUnsafeNullChecks = explicitUnsafeNullChecks;
        }

        private static FixedWithNextNode createObjectAccessNode(ValueNode value, UnsafeNodeConstructor nodeConstructor) {
            return nodeConstructor.create(value, LocationIdentity.ANY_LOCATION);
        }

        private static FixedWithNextNode createMemoryAccessNode(StructuredGraph graph, UnsafeNodeConstructor nodeConstructor) {
            return nodeConstructor.create(ConstantNode.forLong(0L, graph), NamedLocationIdentity.OFF_HEAP_LOCATION);
        }

        private static boolean isLoad(ValueNode node) {
            return node.getStackKind() != JavaKind.Void;
        }

        private void setAccessNodeResult(FixedWithNextNode node, GraphBuilderContext b) {
            if (UnsafeAccessPlugin.isLoad(node)) {
                b.addPush(this.unsafeAccessKind, node);
            } else {
                b.add(node);
            }
        }

        protected final void createUnsafeAccess(ValueNode value, GraphBuilderContext b, UnsafeNodeConstructor nodeConstructor) {
            StructuredGraph graph = b.getGraph();
            graph.markUnsafeAccess();
            if (this.unsafeAccessKind == JavaKind.Object) {
                ValueNode object = value;
                if (this.explicitUnsafeNullChecks) {
                    object = b.nullCheckedValue(object);
                }
                this.setAccessNodeResult(UnsafeAccessPlugin.createObjectAccessNode(object, nodeConstructor), b);
            } else if (StampTool.isPointerAlwaysNull(value)) {
                this.setAccessNodeResult(UnsafeAccessPlugin.createMemoryAccessNode(graph, nodeConstructor), b);
            } else if (!this.explicitUnsafeNullChecks || StampTool.isPointerNonNull(value)) {
                this.setAccessNodeResult(UnsafeAccessPlugin.createObjectAccessNode(value, nodeConstructor), b);
            } else {
                PiNode nonNullObject = graph.addWithoutUnique(new PiNode(value, StampFactory.objectNonNull()));
                FixedWithNextNode objectAccess = graph.add(UnsafeAccessPlugin.createObjectAccessNode(nonNullObject, nodeConstructor));
                FixedWithNextNode memoryAccess = graph.add(UnsafeAccessPlugin.createMemoryAccessNode(graph, nodeConstructor));
                ValueNode[] accessNodes = new FixedWithNextNode[]{objectAccess, memoryAccess};
                LogicNode condition = graph.addOrUniqueWithInputs(IsNullNode.create(value));
                IfNode ifNode = b.add(new IfNode(condition, memoryAccess, objectAccess, ProfileData.BranchProbabilityData.unknown()));
                nonNullObject.setGuard(ifNode.falseSuccessor());
                MergeNode merge = b.append(new MergeNode());
                for (FixedWithNextNode fixedWithNextNode : accessNodes) {
                    EndNode endNode = graph.add(new EndNode());
                    fixedWithNextNode.setNext(endNode);
                    if (fixedWithNextNode instanceof StateSplit) {
                        if (UnsafeAccessPlugin.isLoad(fixedWithNextNode)) {
                            b.push(this.unsafeAccessKind, fixedWithNextNode);
                        }
                        b.setStateAfter((StateSplit)((Object)fixedWithNextNode));
                        if (UnsafeAccessPlugin.isLoad(fixedWithNextNode)) {
                            ValueNode popped = b.pop(this.unsafeAccessKind);
                            assert (popped == fixedWithNextNode);
                        }
                    }
                    merge.addForwardEnd(endNode);
                }
                if (UnsafeAccessPlugin.isLoad(objectAccess)) {
                    ValuePhiNode phi = new ValuePhiNode(objectAccess.stamp(NodeView.DEFAULT), merge, accessNodes);
                    b.push(this.unsafeAccessKind, graph.addOrUnique(phi));
                }
                b.setStateAfter(merge);
            }
        }

        @FunctionalInterface
        public static interface UnsafeNodeConstructor {
            public FixedWithNextNode create(ValueNode var1, LocationIdentity var2);
        }
    }

    public static class UnboxPlugin
    implements InvocationPlugin {
        private final JavaKind kind;

        UnboxPlugin(JavaKind kind) {
            this.kind = kind;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
            if (b.parsingIntrinsic()) {
                ResolvedJavaMethod rootMethod = b.getGraph().method();
                if (b.getMetaAccess().lookupJavaType(BoxingSnippets.class).isAssignableFrom(rootMethod.getDeclaringClass())) {
                    return false;
                }
            }
            ValueNode valueNode = UnboxNode.create(b.getMetaAccess(), b.getConstantReflection(), receiver.get(), this.kind);
            b.addPush(this.kind, valueNode);
            return true;
        }

        void register(InvocationPlugins plugins) {
            String name = this.kind.toJavaClass().getSimpleName() + "Value";
            plugins.register((InvocationPlugin)this, this.kind.toBoxedJavaClass(), name, new Type[]{InvocationPlugin.Receiver.class});
        }
    }

    public static class BoxPlugin
    implements InvocationPlugin {
        private final JavaKind kind;

        BoxPlugin(JavaKind kind) {
            this.kind = kind;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            if (b.parsingIntrinsic()) {
                ResolvedJavaMethod rootMethod = b.getGraph().method();
                if (b.getMetaAccess().lookupJavaType(BoxingSnippets.class).isAssignableFrom(rootMethod.getDeclaringClass())) {
                    return false;
                }
            }
            ResolvedJavaType resultType = b.getMetaAccess().lookupJavaType(this.kind.toBoxedJavaClass());
            b.addPush(JavaKind.Object, BoxNode.create(value, resultType, this.kind));
            return true;
        }

        void register(InvocationPlugins plugins) {
            plugins.register((InvocationPlugin)this, this.kind.toBoxedJavaClass(), "valueOf", this.kind.toJavaClass());
        }
    }

    public static class UnsignedMathPlugin
    implements InvocationPlugin {
        private final Condition condition;

        public UnsignedMathPlugin(Condition condition) {
            this.condition = condition;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
            Condition.CanonicalizedCondition canonical = this.condition.canonicalize();
            StructuredGraph graph = b.getGraph();
            ValueNode lhs = canonical.mustMirror() ? y : x;
            ValueNode rhs = canonical.mustMirror() ? x : y;
            ConstantNode trueValue = ConstantNode.forBoolean(!canonical.mustNegate(), graph);
            ConstantNode falseValue = ConstantNode.forBoolean(canonical.mustNegate(), graph);
            LogicNode compare = CompareNode.createCompareNode(graph, b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, canonical.getCanonicalCondition(), lhs, rhs, NodeView.DEFAULT);
            b.addPush(JavaKind.Boolean, new ConditionalNode(compare, trueValue, falseValue));
            return true;
        }
    }

    public static enum IntegerExactOp {
        INTEGER_ADD_EXACT,
        INTEGER_INCREMENT_EXACT,
        INTEGER_SUBTRACT_EXACT,
        INTEGER_DECREMENT_EXACT,
        INTEGER_MULTIPLY_EXACT;

    }

    static final class MathSqrtPlugin
    implements InvocationPlugin {
        MathSqrtPlugin() {
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            b.push(JavaKind.Double, b.append(SqrtNode.create(value, NodeView.DEFAULT)));
            return true;
        }
    }

    static class StringEqualsInvocationPlugin
    implements InvocationPlugin {
        StringEqualsInvocationPlugin() {
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode other) {
            if (!b.canMergeIntrinsicReturns()) {
                return false;
            }
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ConstantNode trueValue = ConstantNode.forBoolean(true);
                ConstantNode falseValue = ConstantNode.forBoolean(false);
                ValueNode thisString = receiver.get();
                helper.emitReturnIf(b.add(new ObjectEqualsNode(thisString, other)), trueValue, 0.010000000000000009);
                TypeReference stringType = TypeReference.createTrusted(b.getAssumptions(), b.getMetaAccess().lookupJavaType(String.class));
                AbstractBeginNode stringArg2Guard = helper.emitReturnIfNot(InstanceOfNode.create(stringType, other), b.add(falseValue), 0.010000000000000009);
                ObjectStamp stamp = StampFactory.objectNonNull(stringType);
                PiNode otherString = b.add(new PiNode(other, (Stamp)stamp, stringArg2Guard.asNode()));
                if (JavaVersionUtil.JAVA_SPEC > 8) {
                    ResolvedJavaField coderField = b.getMetaAccess().lookupJavaField(STRING_CODER_FIELD);
                    ValueNode thisCoder = helper.loadField(thisString, coderField);
                    ValueNode thatCoder = helper.loadField(otherString, coderField);
                    helper.emitReturnIfNot(b.add(new IntegerEqualsNode(thisCoder, thatCoder)), falseValue, 0.010000000000000009);
                }
                ResolvedJavaField valueField = b.getMetaAccess().lookupJavaField(STRING_VALUE_FIELD);
                ValueNode thisValue = b.nullCheckedValue(helper.loadField(otherString, valueField));
                ValueNode thatValue = b.nullCheckedValue(helper.loadField(thisString, valueField));
                ValueNode thisLength = helper.arraylength(thisValue);
                ValueNode thatLength = helper.arraylength(thatValue);
                helper.emitReturnIfNot(IntegerEqualsNode.create(thisLength, thatLength, NodeView.DEFAULT), falseValue, 0.010000000000000009);
                helper.emitReturnIf(IntegerEqualsNode.create(thisLength, ConstantNode.forInt(0), NodeView.DEFAULT), trueValue, 0.010000000000000009);
                helper.emitFinalReturn(JavaKind.Boolean, b.append(new ArrayEqualsNode(thisValue, thatValue, thisLength.isConstant() ? thisLength : thatLength, JavaVersionUtil.JAVA_SPEC > 8 ? JavaKind.Byte : JavaKind.Char)));
            }
            return true;
        }
    }

    public static class ArrayEqualsInvocationPlugin
    implements InvocationPlugin {
        private final JavaKind kind;

        public ArrayEqualsInvocationPlugin(JavaKind kind) {
            this.kind = kind;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
            if (!b.canMergeIntrinsicReturns()) {
                return false;
            }
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                helper.emitReturnIf(b.add(new ObjectEqualsNode(arg1, arg2)), b.add(ConstantNode.forBoolean(true)), 0.010000000000000009);
                AbstractBeginNode nonNullArg1guard = helper.emitReturnIf(IsNullNode.create(arg1), b.add(ConstantNode.forBoolean(false)), 0.010000000000000009);
                AbstractBeginNode nonNullArg2guard = helper.emitReturnIf(IsNullNode.create(arg2), b.add(ConstantNode.forBoolean(false)), 0.010000000000000009);
                Stamp stamp1 = AbstractPointerStamp.pointerNonNull(arg1.stamp(NodeView.DEFAULT));
                PiNode nonNullArg1 = b.add(new PiNode(arg1, stamp1, nonNullArg1guard.asNode()));
                ArrayLengthNode arg1Length = b.add(new ArrayLengthNode(nonNullArg1));
                Stamp stamp2 = AbstractPointerStamp.pointerNonNull(arg1.stamp(NodeView.DEFAULT));
                PiNode nonNullArg2 = b.add(new PiNode(arg2, stamp2, nonNullArg2guard.asNode()));
                ArrayLengthNode arg2Length = b.add(new ArrayLengthNode(nonNullArg2));
                helper.emitReturnIfNot(IntegerEqualsNode.create(arg1Length, arg2Length, NodeView.DEFAULT), b.add(ConstantNode.forBoolean(false)), 0.99);
                helper.emitFinalReturn(JavaKind.Boolean, b.append(new ArrayEqualsNode(nonNullArg1, nonNullArg2, arg1Length, this.kind)));
            }
            return true;
        }
    }
}

