/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import java.lang.reflect.Type;
import java.util.Arrays;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CopySignNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MaxNode;
import org.graalvm.compiler.nodes.calc.MinNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfDispatchNode;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.StringLatin1Substitutions;
import org.graalvm.compiler.replacements.StringUTF16Substitutions;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.amd64.AMD64StringLatin1InflateNode;
import org.graalvm.compiler.replacements.amd64.AMD64StringSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64StringUTF16CompressNode;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.BitCountNode;
import org.graalvm.compiler.replacements.nodes.CountLeadingZerosNode;
import org.graalvm.compiler.replacements.nodes.CountTrailingZerosNode;
import org.graalvm.compiler.replacements.nodes.FusedMultiplyAddNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class AMD64GraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    @Override
    public void register(GraphBuilderConfiguration.Plugins plugins, Replacements replacements, Architecture architecture, boolean registerForeignCallMath, boolean useFMAIntrinsics, OptionValues options) {
        AMD64GraphBuilderPlugins.register(plugins, replacements, (AMD64)architecture, useFMAIntrinsics, options);
    }

    public static void register(GraphBuilderConfiguration.Plugins plugins, final Replacements replacements, final AMD64 arch, final boolean useFMAIntrinsics, final OptionValues options) {
        final InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                AMD64GraphBuilderPlugins.registerThreadPlugins(invocationPlugins, arch);
                AMD64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int, arch, replacements);
                AMD64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long, arch, replacements);
                if (GraalOptions.EmitStringSubstitutions.getValue(options).booleanValue()) {
                    if (JavaVersionUtil.JAVA_SPEC <= 8) {
                        AMD64GraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements);
                    } else {
                        AMD64GraphBuilderPlugins.registerStringLatin1Plugins(invocationPlugins, replacements);
                        AMD64GraphBuilderPlugins.registerStringUTF16Plugins(invocationPlugins, replacements);
                    }
                }
                AMD64GraphBuilderPlugins.registerMathPlugins(invocationPlugins, useFMAIntrinsics, arch, replacements);
                AMD64GraphBuilderPlugins.registerArraysEqualsPlugins(invocationPlugins, replacements);
            }
        });
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, AMD64 arch) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            assert (arch.getFeatures().contains(AMD64.CPUFeature.SSE2));
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class));
            r.register0("onSpinWait", new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    b.append(new PauseNode());
                    return true;
                }
            });
        }
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, JavaKind kind, AMD64 arch, Replacements replacements) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass, replacements);
        r.register1("numberOfLeadingZeros", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.addPush(JavaKind.Int, CountLeadingZerosNode.create(arg));
                return true;
            }
        });
        r.register1("numberOfTrailingZeros", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.addPush(JavaKind.Int, CountTrailingZerosNode.create(arg));
                return true;
            }
        });
        r.registerConditional1(arch.getFeatures().contains(AMD64.CPUFeature.POPCNT), "bitCount", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new BitCountNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins, boolean useFMAIntrinsics, AMD64 arch, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class), replacements);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
        AMD64GraphBuilderPlugins.registerBinaryMath(r, "pow", BinaryMathIntrinsicNode.BinaryOperation.POW);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            AMD64GraphBuilderPlugins.registerFMA(r, useFMAIntrinsics && arch.getFeatures().contains(AMD64.CPUFeature.FMA));
        }
        if (arch.getFeatures().contains(AMD64.CPUFeature.AVX)) {
            AMD64GraphBuilderPlugins.registerMinMax(r);
        }
        if (arch.getFeatures().contains(AMD64.CPUFeature.AVX512VL)) {
            r.register2("copySign", Float.TYPE, Float.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode magnitude, ValueNode sign) {
                    b.addPush(JavaKind.Float, new CopySignNode(magnitude, sign));
                    return true;
                }
            });
            r.register2("copySign", Double.TYPE, Double.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode magnitude, ValueNode sign) {
                    b.addPush(JavaKind.Double, new CopySignNode(magnitude, sign));
                    return true;
                }
            });
        }
    }

    private static void registerFMA(InvocationPlugins.Registration r, boolean isEnabled) {
        r.registerConditional3(isEnabled, "fma", Double.TYPE, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Double, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
        r.registerConditional3(isEnabled, "fma", Float.TYPE, Float.TYPE, Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Float, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register1(name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(UnaryMathIntrinsicNode.create(value, operation)));
                return true;
            }
        });
    }

    private static void registerBinaryMath(InvocationPlugins.Registration r, String name, final BinaryMathIntrinsicNode.BinaryOperation operation) {
        r.register2(name, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, b.append(BinaryMathIntrinsicNode.create(x, y, operation)));
                return true;
            }
        });
    }

    private static void registerMinMax(InvocationPlugins.Registration r) {
        JavaKind[] supportedKinds;
        for (final JavaKind kind : supportedKinds = new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            r.register2("max", kind.toJavaClass(), kind.toJavaClass(), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, b.append(MaxNode.create(x, y, NodeView.DEFAULT)));
                    return true;
                }
            });
            r.register2("min", kind.toJavaClass(), kind.toJavaClass(), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, b.append(MinNode.create(x, y, NodeView.DEFAULT)));
                    return true;
                }
            });
        }
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)String.class), replacements);
            r.setAllowOverwrite(true);
            r.registerMethodSubstitution(AMD64StringSubstitutions.class, "indexOf", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            r.registerMethodSubstitution(AMD64StringSubstitutions.class, "indexOf", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE});
            r.register2("compareTo", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)String.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode otherString) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        ResolvedJavaField field = b.getMetaAccess().lookupJavaField(StandardGraphBuilderPlugins.STRING_VALUE_FIELD);
                        ValueNode receiverString = receiver.get();
                        helper.emitReturnIf(receiverString, Condition.EQ, otherString, ConstantNode.forInt(0), 0.25);
                        ValueNode receiverValue = b.nullCheckedValue(helper.loadField(receiverString, field));
                        ValueNode otherValue = b.nullCheckedValue(helper.loadField(otherString, field));
                        helper.emitFinalReturn(JavaKind.Int, new ArrayCompareToNode(receiverValue, otherValue, helper.shl(helper.arraylength(receiverValue), 1), helper.shl(helper.arraylength(otherValue), 1), JavaKind.Char, JavaKind.Char));
                    }
                    return true;
                }
            });
        }
    }

    private static void registerStringLatin1Plugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringLatin1", replacements);
        r.setAllowOverwrite(true);
        r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Byte));
        r.register2("compareToUTF16", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Char));
        r.register5("inflate", (Type)((Object)byte[].class), Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcIndex, ValueNode dest, ValueNode destIndex, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    helper.intrinsicRangeCheck(len, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(srcIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode srcLength = helper.length(b.nullCheckedValue(src));
                    helper.intrinsicRangeCheck(helper.add(srcIndex, len), Condition.GT, srcLength);
                    ValueNode scaledDestIndex = helper.scale(destIndex, JavaKind.Char);
                    helper.intrinsicRangeCheck(scaledDestIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode end = helper.add(scaledDestIndex, helper.scale(len, JavaKind.Char));
                    ValueNode destLength = helper.length(b.nullCheckedValue(dest));
                    helper.intrinsicRangeCheck(end, Condition.GT, destLength);
                    ValueNode srcPointer = helper.arrayElementPointer(src, JavaKind.Byte, srcIndex);
                    ValueNode destPointer = helper.arrayElementPointer(dest, JavaKind.Byte, scaledDestIndex);
                    b.add(new AMD64StringLatin1InflateNode(srcPointer, destPointer, len, JavaKind.Byte));
                }
                return true;
            }
        });
        r.register5("inflate", (Type)((Object)byte[].class), Integer.TYPE, (Type)((Object)char[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcIndex, ValueNode dest, ValueNode destIndex, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    helper.intrinsicRangeCheck(len, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(srcIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode srcLength = helper.length(b.nullCheckedValue(src));
                    helper.intrinsicRangeCheck(helper.add(srcIndex, len), Condition.GT, srcLength);
                    helper.intrinsicRangeCheck(destIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode end = helper.add(destIndex, len);
                    ValueNode destLength = helper.length(b.nullCheckedValue(dest));
                    helper.intrinsicRangeCheck(end, Condition.GT, destLength);
                    ValueNode srcPointer = helper.arrayElementPointer(src, JavaKind.Byte, srcIndex);
                    ValueNode destPointer = helper.arrayElementPointer(dest, JavaKind.Char, destIndex);
                    b.add(new AMD64StringLatin1InflateNode(srcPointer, destPointer, len, JavaKind.Char));
                }
                return true;
            }
        });
        r.registerMethodSubstitution(StringLatin1Substitutions.class, "indexOf", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.register3("indexOf", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new StandardGraphBuilderPlugins.StringLatin1IndexOfCharPlugin());
    }

    private static void registerStringUTF16Plugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        r.setAllowOverwrite(true);
        r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Char));
        r.register2("compareToLatin1", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Byte, true));
        r.register5("compress", (Type)((Object)byte[].class), Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcIndex, ValueNode dest, ValueNode destIndex, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    helper.intrinsicRangeCheck(len, Condition.LT, ConstantNode.forInt(0));
                    ValueNode scaledSrcIndex = helper.scale(srcIndex, JavaKind.Char);
                    helper.intrinsicRangeCheck(scaledSrcIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode end = helper.add(scaledSrcIndex, helper.scale(len, JavaKind.Char));
                    ValueNode srcLength = helper.length(b.nullCheckedValue(src));
                    helper.intrinsicRangeCheck(end, Condition.GT, srcLength);
                    helper.intrinsicRangeCheck(destIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode destLength = helper.length(b.nullCheckedValue(dest));
                    helper.intrinsicRangeCheck(helper.add(destIndex, len), Condition.GT, destLength);
                    ValueNode srcPointer = helper.arrayElementPointer(src, JavaKind.Byte, scaledSrcIndex);
                    ValueNode destPointer = helper.arrayElementPointer(dest, JavaKind.Byte, destIndex);
                    b.addPush(JavaKind.Int, new AMD64StringUTF16CompressNode(srcPointer, destPointer, len, JavaKind.Byte));
                }
                return true;
            }
        });
        r.register5("compress", (Type)((Object)char[].class), Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcIndex, ValueNode dest, ValueNode destIndex, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    helper.intrinsicRangeCheck(len, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(srcIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode end = helper.add(srcIndex, len);
                    ValueNode srcLength = helper.length(b.nullCheckedValue(src));
                    helper.intrinsicRangeCheck(end, Condition.GT, srcLength);
                    helper.intrinsicRangeCheck(destIndex, Condition.LT, ConstantNode.forInt(0));
                    ValueNode destLength = helper.length(b.nullCheckedValue(dest));
                    helper.intrinsicRangeCheck(helper.add(destIndex, len), Condition.GT, destLength);
                    ValueNode srcPointer = helper.arrayElementPointer(src, JavaKind.Char, srcIndex);
                    ValueNode destPointer = helper.arrayElementPointer(dest, JavaKind.Byte, destIndex);
                    b.addPush(JavaKind.Int, new AMD64StringUTF16CompressNode(srcPointer, destPointer, len, JavaKind.Char));
                }
                return true;
            }
        });
        r.registerMethodSubstitution(StringUTF16Substitutions.class, "indexOfUnsafe", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(StringUTF16Substitutions.class, "indexOfLatin1Unsafe", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.register4("indexOfCharUnsafe", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode ch, ValueNode fromIndex, ValueNode max) {
                ZeroExtendNode toChar = b.add(new ZeroExtendNode(b.add(new NarrowNode(ch, JavaKind.Char.getBitCount())), JavaKind.Int.getBitCount()));
                b.addPush(JavaKind.Int, new ArrayIndexOfDispatchNode(ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT, JavaKind.Byte, JavaKind.Char, false, value, max, fromIndex, toChar));
                return true;
            }
        });
        InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, (Type)((Object)StringUTF16Substitutions.class), replacements);
        r2.register2("getChar", (Type)((Object)byte[].class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Char, new JavaReadNode(JavaKind.Char, (AddressNode)new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), OnHeapMemoryAccess.BarrierType.NONE, false));
                return true;
            }
        });
    }

    private static void registerArraysEqualsPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Arrays.class), replacements);
        r.register2("equals", (Type)((Object)float[].class), (Type)((Object)float[].class), new StandardGraphBuilderPlugins.ArrayEqualsInvocationPlugin(JavaKind.Float));
        r.register2("equals", (Type)((Object)double[].class), (Type)((Object)double[].class), new StandardGraphBuilderPlugins.ArrayEqualsInvocationPlugin(JavaKind.Double));
    }

    private static final class ArrayCompareToPlugin
    implements InvocationPlugin {
        private final JavaKind valueKind;
        private final JavaKind otherKind;
        private final boolean swapped;

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind, boolean swapped) {
            this.valueKind = valueKind;
            this.otherKind = otherKind;
            this.swapped = swapped;
        }

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind) {
            this(valueKind, otherKind, false);
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode other) {
            ValueNode nonNullValue = b.nullCheckedValue(value);
            ValueNode nonNullOther = b.nullCheckedValue(other);
            ArrayLengthNode valueLength = b.add(new ArrayLengthNode(nonNullValue));
            ArrayLengthNode otherLength = b.add(new ArrayLengthNode(nonNullOther));
            if (this.swapped) {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(nonNullOther, nonNullValue, otherLength, valueLength, this.valueKind, this.otherKind));
            } else {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(nonNullValue, nonNullOther, valueLength, otherLength, this.valueKind, this.otherKind));
            }
            return true;
        }
    }
}

