/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CountTrailingZerosNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<CountTrailingZerosNode> TYPE = NodeClass.create(CountTrailingZerosNode.class);

    protected CountTrailingZerosNode(ValueNode value) {
        super(TYPE, CountTrailingZerosNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode folded = CountTrailingZerosNode.tryFold(value);
        if (folded != null) {
            return folded;
        }
        return new CountTrailingZerosNode(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return CountTrailingZerosNode.computeStamp(newStamp, this.getValue());
    }

    static Stamp computeStamp(Stamp newStamp, ValueNode value) {
        assert (newStamp.isCompatible(value.stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        return StampTool.stampForTrailingZeros(valueStamp);
    }

    public static ValueNode tryFold(ValueNode value) {
        if (value.isConstant()) {
            JavaConstant c = value.asJavaConstant();
            if (value.getStackKind() == JavaKind.Int) {
                return ConstantNode.forInt(Integer.numberOfTrailingZeros(c.asInt()));
            }
            return ConstantNode.forInt(Long.numberOfTrailingZeros(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = CountTrailingZerosNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitCountTrailingZeros(builder.operand(this.getValue())));
    }
}

