/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;

@Node.NodeIntrinsicFactory
public class TypePunnedArrayReadIntrinsic {
    @Node.NodeIntrinsic
    public static native int read(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, Object var3, long var4);

    public static boolean intrinsify(GraphBuilderContext b, JavaKind arrayKind, JavaKind indexKind, JavaKind resultKind, ValueNode array, ValueNode index) {
        b.addPush(resultKind, new JavaReadNode(resultKind, (AddressNode)new IndexAddressNode(array, index, arrayKind, indexKind), NamedLocationIdentity.getArrayLocation(arrayKind), OnHeapMemoryAccess.BarrierType.NONE, false));
        return true;
    }

    @Node.NodeIntrinsicFactory
    public static class ReadLong {
        @Node.NodeIntrinsic
        public static native long read(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, Object var2, long var3);

        public static boolean intrinsify(GraphBuilderContext b, JavaKind arrayKind, JavaKind indexKind, ValueNode array, ValueNode index) {
            b.addPush(JavaKind.Long, new JavaReadNode(JavaKind.Long, (AddressNode)new IndexAddressNode(array, index, arrayKind, indexKind), NamedLocationIdentity.getArrayLocation(arrayKind), OnHeapMemoryAccess.BarrierType.NONE, false));
            return true;
        }
    }
}

